/*
 * Decompiled with CFR 0.152.
 */
package ctb_vehicles.common.entity;

import ctb.CTB;
import ctb.ctbplayer.CTBPlayer;
import ctb.items.ItemGun;
import ctb.packet.client.PacketCTBPlayerClient;
import ctb.packet.client.PacketMGClient;
import ctb_vehicles.common.entity.EntityVehicle;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;

public class EntitySeat
extends Entity
implements IEntityAdditionalSpawnData {
    public final List<EntitySeat> seats = new ArrayList<EntitySeat>();
    public Entity parent;
    public boolean isDriver = false;
    public boolean isTurret = false;
    public boolean isScoped = false;
    public float xOff;
    public float yOff;
    public float zOff;
    protected int seatID = 0;
    public float prevInternalYaw;
    public float internalYaw;
    public float playerYawOffset;
    public float prevPYaw;
    public float pYaw;
    public EntityLivingBase prevDriver;
    protected ItemGun mg = null;
    protected int mgAmmoType = -1;
    public int mgAmmo = 0;
    public boolean crouchingSeat = false;
    public boolean standingSeat = false;
    public boolean playerInvisible = false;
    public float yawMin;
    public float yawMax;
    public float pitchMin;
    public float pitchMax;
    protected float playerYaw;
    protected float playerPitch;
    protected float prevPlayerYaw;
    protected float prevPlayerPitch;
    public int currentMGFireDelay;
    public boolean reloading = false;

    public EntitySeat(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.6f, 1.0f);
        this.field_70145_X = true;
        this.field_70138_W = 1.0f;
    }

    public EntitySeat(World worldIn, Entity p, float xOff, float yOff, float zOff, int sID) {
        super(worldIn);
        this.parent = p;
        this.xOff = xOff;
        this.yOff = yOff;
        this.zOff = zOff;
        this.field_70138_W = 1.0f;
        this.seatID = sID;
        this.func_70012_b(p.field_70165_t, p.field_70163_u, p.field_70161_v, 0.0f, 0.0f);
        this.func_70105_a(0.6f, 1.0f);
    }

    public void spawnSeats() {
        for (EntitySeat seat : this.seats) {
            seat.parent = this;
            seat.prevPYaw = this.pYaw;
            this.field_70170_p.func_72838_d((Entity)seat);
        }
    }

    public EntitySeat setMaxYaw(float maxYaw) {
        this.yawMin = -maxYaw;
        this.yawMax = maxYaw;
        return this;
    }

    public EntitySeat setYawParams(float minYaw, float maxYaw) {
        this.yawMin = -minYaw;
        this.yawMax = maxYaw;
        return this;
    }

    public EntitySeat setPitchParams(float minPitch, float maxPitch) {
        this.pitchMin = -maxPitch;
        this.pitchMax = minPitch;
        return this;
    }

    public EntitySeat setPlayerYawOffset(int offset) {
        this.playerYawOffset = offset;
        return this;
    }

    public EntitySeat setDriver() {
        this.isDriver = true;
        return this;
    }

    public EntitySeat setTurret() {
        this.isTurret = true;
        return this.setScoped();
    }

    public EntitySeat setScoped() {
        this.isScoped = true;
        return this;
    }

    public EntitySeat setStandingSeat() {
        this.standingSeat = true;
        return this;
    }

    public EntitySeat setStandingSeat(boolean standingSeat) {
        this.standingSeat = standingSeat;
        return this;
    }

    public EntitySeat setCrouchingSeat() {
        this.crouchingSeat = true;
        return this;
    }

    public EntitySeat setCrouchingSeat(boolean standingSeat) {
        this.crouchingSeat = standingSeat;
        return this;
    }

    public EntitySeat setPlayerInvisible() {
        this.playerInvisible = true;
        return this;
    }

    public Entity getRider() {
        return !this.func_184188_bt().isEmpty() ? (Entity)this.func_184188_bt().get(0) : null;
    }

    public void fireMG() {
        if (this.mg != null && this.currentMGFireDelay <= 0 && this.mg.stats.delay.length > 0) {
            this.currentMGFireDelay = this.mg.stats.delay[0];
        }
    }

    public EntityVehicle getParentVehicle() {
        if (this.parent instanceof EntityVehicle) {
            return (EntityVehicle)this.parent;
        }
        if (this.parent instanceof EntitySeat) {
            return ((EntitySeat)this.parent).getParentVehicle();
        }
        return null;
    }

    public ItemGun getMGItem() {
        return this.mg;
    }

    public void setMG(ItemGun gun) {
        this.mg = gun;
        if (this.mgAmmoType >= 0 && this.mgAmmoType < gun.ammo.length) {
            this.mgAmmo = gun.ammo[this.mgAmmoType].maxAmmo;
        }
    }

    public boolean isMGSeat() {
        return this.mg != null;
    }

    public void setAmmoType(int ammoType) {
        this.mgAmmoType = ammoType;
    }

    public int getMgAmmoType() {
        return this.mgAmmoType;
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        if (this.getParentVehicle() != null && this.getParentVehicle().getHealth() <= 0.0f) {
            return false;
        }
        EntityPlayer p2 = null;
        for (int i = 0; i < this.func_184188_bt().size(); ++i) {
            Entity passenger = (Entity)this.func_184188_bt().get(i);
            if (!(passenger instanceof EntityPlayer)) continue;
            p2 = (EntityPlayer)passenger;
            break;
        }
        if (p2 != null && p2 != player) {
            return true;
        }
        if (this.mg != null) {
            this.mgAmmo = this.mgAmmoType >= 0 && this.mgAmmoType < this.mg.ammo.length ? this.mg.ammo[this.mgAmmoType].maxAmmo : this.mg.getMaxAmmo();
        }
        if (!this.field_70170_p.field_72995_K) {
            CTBPlayer ctbPlayer = CTBPlayer.get((EntityPlayer)player);
            if (ctbPlayer.getStance() != 0) {
                ctbPlayer.setStance(0);
                CTB.ctbChannel.sendToAll((IMessage)new PacketCTBPlayerClient(player));
            }
            if (this.isMGSeat() && !this.isScoped) {
                boolean emptySpace = false;
                for (int i = 0; i < 9; ++i) {
                    if (player.field_71071_by.func_70301_a(i) != ItemStack.field_190927_a) continue;
                    player.field_71071_by.field_70461_c = i;
                    CTB.ctbChannel.sendTo((IMessage)new PacketMGClient(null, 2), (EntityPlayerMP)player);
                    ItemStack mgStack = new ItemStack((Item)this.mg);
                    this.mg.createNBTData(mgStack);
                    mgStack.func_77978_p().func_74757_a("mgItem", true);
                    mgStack.func_77978_p().func_74768_a("ammoType", this.mgAmmoType);
                    mgStack.func_77978_p().func_74768_a("ammo", this.mgAmmo);
                    player.func_184611_a(EnumHand.MAIN_HAND, mgStack);
                    ctbPlayer.bipodOut = 1;
                    emptySpace = true;
                    break;
                }
                if (!emptySpace) {
                    return false;
                }
            }
            player.func_184220_m((Entity)this);
            if (player instanceof EntityPlayerMP) {
                ((EntityPlayerMP)player).field_71135_a.func_73660_a();
            }
        }
        return true;
    }

    protected void func_70088_a() {
    }

    public double func_70042_X() {
        return (double)this.field_70131_O / 2.0 * 0.75;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.currentMGFireDelay > 0) {
            --this.currentMGFireDelay;
        }
        this.field_70134_J = false;
        this.field_70179_y = 0.0;
        this.field_70181_x = 0.0;
        this.field_70159_w = 0.0;
        if (this.parent == null || this.parent.field_70128_L) {
            int gracePeriod = 20;
            if (!this.field_70170_p.field_72995_K && this.field_70173_aa > gracePeriod) {
                this.func_70106_y();
            }
        } else {
            EntityLivingBase p2 = null;
            for (int i = 0; i < this.func_184188_bt().size(); ++i) {
                Entity passenger = (Entity)this.func_184188_bt().get(i);
                if (!(passenger instanceof EntityLivingBase)) continue;
                p2 = (EntityLivingBase)passenger;
                break;
            }
            if (p2 != null) {
                if (this.prevDriver == null) {
                    p2.field_70177_z = this.internalYaw + 90.0f + (this.getYawMin() + this.getYawMax()) / 2.0f;
                    if (this.field_70170_p.field_72995_K) {
                        // empty if block
                    }
                }
                this.prevDriver = p2;
                if (this.isMGSeat() && !this.isScoped && this.prevDriver.func_184614_ca().func_77978_p() != null && this.prevDriver.func_184614_ca().func_77973_b() instanceof ItemGun) {
                    this.mgAmmo = this.prevDriver.func_184614_ca().func_77978_p().func_74762_e("ammo");
                }
            } else if (this.prevDriver != null) {
                this.prevDriver.func_70634_a(this.field_70165_t, this.parent.field_70163_u, this.field_70161_v);
                if (this.isMGSeat() && !this.isScoped && this.prevDriver instanceof EntityPlayer) {
                    EntityPlayer player = (EntityPlayer)this.prevDriver;
                    CTBPlayer ctbPlayer = CTBPlayer.get((EntityPlayer)player);
                    for (int inv = 0; inv < player.field_71071_by.func_70302_i_(); ++inv) {
                        ItemStack s;
                        if (player.field_71071_by.func_70301_a(inv) == ItemStack.field_190927_a || !(player.field_71071_by.func_70301_a(inv).func_77973_b() instanceof ItemGun) || (s = player.field_71071_by.func_70301_a(inv)).func_77978_p() == null || !s.func_77978_p().func_74767_n("mgItem")) continue;
                        player.field_71071_by.func_70299_a(inv, ItemStack.field_190927_a);
                    }
                    ctbPlayer.bipodOut = 0;
                    CTB.ctbChannel.sendToAll((IMessage)new PacketCTBPlayerClient(player));
                }
                this.prevDriver = null;
            }
            if (this.parent instanceof EntitySeat) {
                EntitySeat parent = (EntitySeat)this.parent;
                if (!parent.seats.isEmpty() && !parent.seats.contains((Object)this)) {
                    parent.seats.add(this);
                } else if (parent.seats.isEmpty() && this.isDriver) {
                    parent.seats.add(this);
                }
                if (this.isDriver || this.getParentVehicle() != null && this.getParentVehicle().getControllingSeat() == this) {
                    parent.field_70177_z = this.field_70177_z;
                    if (parent.getParentVehicle() != null) {
                        parent.getParentVehicle().field_70177_z = this.field_70177_z;
                    }
                } else {
                    this.internalYaw = this.field_70177_z = -(parent.field_70177_z % 360.0f);
                }
            } else if (this.parent instanceof EntityVehicle) {
                EntityVehicle parent = (EntityVehicle)this.parent;
                if (!parent.seats.isEmpty() && !parent.seats.contains((Object)this)) {
                    parent.seats.add(this);
                } else if (parent.seats.isEmpty() && this.isDriver) {
                    parent.seats.add(this);
                }
                if (this.isDriver || this.getParentVehicle() != null && this.getParentVehicle().getControllingSeat() == this) {
                    parent.driversSeat = this;
                    parent.field_70177_z = this.field_70177_z;
                } else {
                    this.internalYaw = parent.driversSeat != null ? (this.field_70177_z = parent.driversSeat.internalYaw) : (this.field_70177_z = -(parent.field_70177_z % 360.0f));
                }
            }
            this.prevPYaw = this.pYaw;
            this.pYaw = this.internalYaw;
            this.updateSeatPosition();
        }
    }

    protected void updateSeatPosition() {
        float yaw = (this.internalYaw - 180.0f) % 360.0f;
        if (this.parent instanceof EntitySeat) {
            yaw = (this.getParentSeatRotation() - 180.0f) % 360.0f;
        }
        this.field_70165_t = this.parent.field_70165_t + ((double)(MathHelper.func_76134_b((float)(yaw / 180.0f * (float)Math.PI)) * this.xOff) - (double)(MathHelper.func_76126_a((float)(yaw / 180.0f * (float)Math.PI)) * this.zOff));
        this.field_70163_u = this.parent.field_70163_u + (double)this.yOff;
        this.field_70161_v = this.parent.field_70161_v + ((double)(MathHelper.func_76126_a((float)((yaw + 90.0f) / 180.0f * (float)Math.PI)) * this.zOff) - (double)(MathHelper.func_76134_b((float)((yaw + 90.0f) / 180.0f * (float)Math.PI)) * this.xOff));
        if (this.field_70170_p.field_72995_K) {
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        }
    }

    public float getParentSeatRotation() {
        if (this.parent instanceof EntitySeat) {
            EntitySeat parentSeat = (EntitySeat)this.parent;
            float turretRot = 0.0f;
            return turretRot + parentSeat.internalYaw + parentSeat.getParentSeatRotation();
        }
        return 0.0f;
    }

    public float getYawMin() {
        return this.yawMin;
    }

    public float getYawMax() {
        return this.yawMax;
    }

    public float getPitchMin() {
        return this.pitchMin;
    }

    public float getPitchMax() {
        return this.pitchMax;
    }

    public void updateRiderPosition() {
        Object p2 = null;
        for (int i = 0; i < this.func_184188_bt().size(); ++i) {
            Entity passenger = (Entity)this.func_184188_bt().get(i);
            passenger.func_70107_b(this.field_70165_t, this.field_70163_u + this.func_70042_X() + passenger.func_70033_W(), this.field_70161_v);
        }
    }

    protected void func_70037_a(NBTTagCompound tagCompound) {
        int pid = tagCompound.func_74762_e("parent");
        Entity p = this.field_70170_p.func_73045_a(pid);
        if (p != null) {
            this.parent = p;
        }
        this.isDriver = tagCompound.func_74767_n("isDriver");
        this.isTurret = tagCompound.func_74767_n("isTurret");
        this.isScoped = tagCompound.func_74767_n("isScoped");
        this.playerInvisible = tagCompound.func_74767_n("playerInvisible");
        this.xOff = tagCompound.func_74760_g("xOff");
        this.yOff = tagCompound.func_74760_g("yOff");
        this.zOff = tagCompound.func_74760_g("zOff");
    }

    protected void func_70014_b(NBTTagCompound tagCompound) {
        tagCompound.func_74768_a("parent", this.parent == null ? 0 : this.parent.func_145782_y());
        tagCompound.func_74757_a("isDriver", this.isDriver);
        tagCompound.func_74757_a("isTurret", this.isTurret);
        tagCompound.func_74757_a("isScoped", this.isScoped);
        tagCompound.func_74757_a("playerInvisible", this.playerInvisible);
        tagCompound.func_74776_a("xOff", this.xOff);
        tagCompound.func_74776_a("yOff", this.yOff);
        tagCompound.func_74776_a("zOff", this.zOff);
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeInt(this.parent == null ? 0 : this.parent.func_145782_y());
        buffer.writeBoolean(this.isDriver);
        buffer.writeBoolean(this.isTurret);
        buffer.writeBoolean(this.isScoped);
        buffer.writeFloat(this.xOff);
        buffer.writeFloat(this.yOff);
        buffer.writeFloat(this.zOff);
        buffer.writeFloat(this.pYaw);
        buffer.writeFloat(this.yawMin);
        buffer.writeFloat(this.yawMax);
        buffer.writeFloat(this.pitchMin);
        buffer.writeFloat(this.pitchMax);
        buffer.writeFloat(this.playerYawOffset);
        buffer.writeBoolean(this.standingSeat);
        buffer.writeBoolean(this.crouchingSeat);
        buffer.writeBoolean(this.playerInvisible);
        buffer.writeInt(this.mgAmmo);
        buffer.writeInt(this.mgAmmoType);
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)(this.mg != null ? ((ResourceLocation)Item.field_150901_e.func_177774_c((Object)this.mg)).toString() : ""));
    }

    public void readSpawnData(ByteBuf additionalData) {
        int pID = additionalData.readInt();
        this.isDriver = additionalData.readBoolean();
        this.isTurret = additionalData.readBoolean();
        this.isScoped = additionalData.readBoolean();
        this.xOff = additionalData.readFloat();
        this.yOff = additionalData.readFloat();
        this.zOff = additionalData.readFloat();
        this.internalYaw = this.pYaw = additionalData.readFloat();
        this.yawMin = additionalData.readFloat();
        this.yawMax = additionalData.readFloat();
        this.pitchMin = additionalData.readFloat();
        this.pitchMax = additionalData.readFloat();
        this.playerYawOffset = additionalData.readFloat();
        this.standingSeat = additionalData.readBoolean();
        this.crouchingSeat = additionalData.readBoolean();
        this.playerInvisible = additionalData.readBoolean();
        this.mgAmmo = additionalData.readInt();
        this.mgAmmoType = additionalData.readInt();
        String mgName = ByteBufUtils.readUTF8String((ByteBuf)additionalData);
        if (!mgName.isEmpty()) {
            this.mg = (ItemGun)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(mgName));
        }
        if (this.field_70170_p.func_73045_a(pID) != null) {
            this.parent = this.field_70170_p.func_73045_a(pID);
        }
    }
}

