/*
 * Decompiled with CFR 0.152.
 */
package ctb_vehicles.common.entity;

import ctb.CTB;
import ctb.CTBServerTicker;
import ctb.ctbplayer.CTBPlayer;
import ctb.entity.EntitySoldier;
import ctb.handlers.CTBDataHandler;
import ctb.handlers.api.CTBVConnector;
import ctb.loading.SoundLoader;
import ctb.progression.ProgressionSystem;
import ctb_vehicles.CTBVehicles;
import ctb_vehicles.client.CTBVClient;
import ctb_vehicles.client.packet.PacketVehicleSoundClient;
import ctb_vehicles.client.sound.VehicleSound;
import ctb_vehicles.common.entity.EntitySeat;
import ctb_vehicles.common.entity.SeatCreator;
import ctb_vehicles.common.entity.hitboxes.HitboxCreator;
import ctb_vehicles.common.entity.hitboxes.VHFace;
import ctb_vehicles.common.entity.hitboxes.VehicleHitbox;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityVehicle
extends Entity
implements IEntityAdditionalSpawnData {
    public Entity driver;
    public List<VehicleHitbox> mainHitboxes = new ArrayList<VehicleHitbox>();
    public List<VehicleHitbox> complexHitboxes = new ArrayList<VehicleHitbox>();
    public final List<EntitySeat> seats = new ArrayList<EntitySeat>();
    public float throttleSpeed = 0.0f;
    public float maxThrottle;
    public float acceleration = 0.01f;
    public float maxTurnRate;
    public String resourceName;
    public String textureName;
    public double frontLength;
    public double backLength;
    private int currentSkin = 0;
    public int noHealthTime;
    private boolean isBoatEmpty = true;
    private int boatPosRotationIncrements;
    private double boatX;
    private double boatY;
    private double boatZ;
    private double boatYaw;
    private double boatPitch;
    @SideOnly(value=Side.CLIENT)
    private double velocityX;
    @SideOnly(value=Side.CLIENT)
    private double velocityY;
    @SideOnly(value=Side.CLIENT)
    private double velocityZ;
    private boolean isPlayerIn = false;
    public EntitySeat driversSeat;
    public UUID matchId;
    private float pYaw;
    private int fire;
    public boolean prevDriven;
    public boolean driven;
    public int fireDelay = 80;
    public int currentFireDelay;
    public float gunPitch = 0.0f;
    public float prevGunPitch = 0.0f;
    public float treadOffset = 0.0f;
    @SideOnly(value=Side.CLIENT)
    private VehicleSound rummageSound;
    private static final DataParameter<Integer> HITTIME_ID = EntityDataManager.func_187226_a(EntityVehicle.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Float> HEALTH_ID = EntityDataManager.func_187226_a(EntityVehicle.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> MAXHEALTH_ID = EntityDataManager.func_187226_a(EntityVehicle.class, (DataSerializer)DataSerializers.field_187193_c);
    private boolean createdSeats;
    @SideOnly(value=Side.CLIENT)
    public VehicleSound vehicleSound;
    private int lerpSteps;
    private double lerpX;
    private double lerpY;
    private double lerpZ;
    private double lerpYaw;
    private double lerpPitch;
    double ippX = 0.0;
    double ippZ = 0.0;

    public double func_70033_W() {
        return 0.1f;
    }

    public EntityVehicle(World p_i1704_1_) {
        super(p_i1704_1_);
        this.field_70156_m = true;
        this.func_70105_a(2.5f, 1.0f);
        this.field_70138_W = 1.0f;
        this.setSkin(this.randomSkin());
        this.maxThrottle = 1.0f;
        this.maxTurnRate = 1.25f;
        this.field_70158_ak = true;
    }

    public EntityVehicle(World p_i1705_1_, double p_i1705_2_, double p_i1705_4_, double p_i1705_6_) {
        this(p_i1705_1_);
        this.func_70107_b(p_i1705_2_, p_i1705_4_ + this.func_70033_W(), p_i1705_6_);
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.field_70169_q = p_i1705_2_;
        this.field_70167_r = p_i1705_4_;
        this.field_70166_s = p_i1705_6_;
        this.field_70138_W = 1.0f;
        this.setSkin(this.randomSkin());
        this.maxThrottle = 1.0f;
        this.maxTurnRate = 1.25f;
    }

    public void spawnSeats() {
        this.createdSeats = true;
        this.pYaw = this.field_70177_z;
        for (EntitySeat seat : this.seats) {
            seat.parent = this;
            seat.pYaw = seat.internalYaw = this.pYaw;
            seat.prevPYaw = seat.internalYaw;
            if (seat.mg != null) {
                seat.mgAmmo = seat.mgAmmoType >= 0 && seat.mgAmmoType < seat.mg.ammo.length ? seat.mg.ammo[seat.mgAmmoType].maxAmmo : seat.mg.getMaxAmmo();
            }
            this.field_70170_p.func_72838_d((Entity)seat);
            if (seat.isDriver) {
                this.driversSeat = seat;
            }
            seat.spawnSeats();
        }
    }

    protected boolean func_70041_e_() {
        return false;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(HITTIME_ID, (Object)0);
        this.field_70180_af.func_187214_a(HEALTH_ID, (Object)Float.valueOf(120.0f));
        this.field_70180_af.func_187214_a(MAXHEALTH_ID, (Object)Float.valueOf(120.0f));
    }

    public float getMaxHealth() {
        return ((Float)this.field_70180_af.func_187225_a(MAXHEALTH_ID)).floatValue();
    }

    public void setMaxHealth(float p_70266_1_) {
        this.field_70180_af.func_187227_b(MAXHEALTH_ID, (Object)Float.valueOf(p_70266_1_));
        this.field_70180_af.func_187217_b(MAXHEALTH_ID);
        this.setHealth(p_70266_1_);
    }

    public float getHealth() {
        return ((Float)this.field_70180_af.func_187225_a(HEALTH_ID)).floatValue();
    }

    public void setHealth(float p_70266_1_) {
        this.field_70180_af.func_187227_b(HEALTH_ID, (Object)Float.valueOf(p_70266_1_));
        this.field_70180_af.func_187217_b(HEALTH_ID);
    }

    private int getTimeSinceHit() {
        return (Integer)this.field_70180_af.func_187225_a(HITTIME_ID);
    }

    private void setTimeSinceHit(int p_70265_1_) {
        this.field_70180_af.func_187227_b(HITTIME_ID, (Object)p_70265_1_);
        this.field_70180_af.func_187217_b(HITTIME_ID);
    }

    public void createHitbox() {
        this.mainHitboxes.clear();
        this.complexHitboxes.clear();
        this.mainHitboxes = HitboxCreator.createHitboxFor(this);
        this.complexHitboxes = HitboxCreator.createHitboxFor(this, "complex");
    }

    public boolean isEntityInside(Entity entity) {
        double diff = this.field_70170_p.field_72995_K ? 1.0 : (double)-0.6f;
        return this.isPointInside(new Vec3d(entity.field_70165_t, entity.field_70163_u - diff, entity.field_70161_v));
    }

    public boolean isHitboxInsideMainHitbox(VehicleHitbox hb, double x, double y, double z) {
        VehicleHitbox hitbox;
        ArrayList<VehicleHitbox> allMainHitboxes = new ArrayList<VehicleHitbox>(this.mainHitboxes);
        Iterator<VehicleHitbox> iterator = allMainHitboxes.iterator();
        return iterator.hasNext() && (hitbox = iterator.next()).hitboxIntersects(hb, x, y, z);
    }

    public boolean isPointInside(Vec3d point) {
        ArrayList<VehicleHitbox> allMainHitboxes = new ArrayList<VehicleHitbox>(this.mainHitboxes);
        for (VehicleHitbox hitbox : allMainHitboxes) {
            if (!hitbox.pointIntersects(point)) continue;
            return true;
        }
        return false;
    }

    public boolean rayCastIntersect(Vec3d point, Vec3d end) {
        ArrayList<VehicleHitbox> allMainHitboxes = new ArrayList<VehicleHitbox>(this.mainHitboxes);
        for (VehicleHitbox hitbox : allMainHitboxes) {
            if (!hitbox.rayCastIntersects(point, end)) continue;
            return true;
        }
        return false;
    }

    public ArrayList<Vec3d> getIntersectionsComplex(Vec3d point, Vec3d end) {
        ArrayList<Vec3d> intersections = new ArrayList<Vec3d>();
        ArrayList<VehicleHitbox> allMainHitboxes = new ArrayList<VehicleHitbox>(this.complexHitboxes);
        for (VehicleHitbox hitbox : allMainHitboxes) {
            hitbox.updateHitbox(this);
            Vec3d intersect = hitbox.getIntersect(point, end);
            if (intersect == null) continue;
            intersections.add(intersect);
        }
        return intersections;
    }

    public boolean isPointInsideOffset(Vec3d point, double x, double y, double z) {
        ArrayList<VehicleHitbox> allMainHitboxes = new ArrayList<VehicleHitbox>(this.mainHitboxes);
        for (VehicleHitbox hitbox : allMainHitboxes) {
            if (!hitbox.pointIntersectsOffset(point, x, y, z)) continue;
            return true;
        }
        return false;
    }

    public float getVehicleWeight() {
        switch (this.getResourceName()) {
            case "sdkfz250": {
                return 5.8f;
            }
            case "kp": 
            case "kpj": 
            case "kps": {
                return 2.0f;
            }
            case "cardenloyd": 
            case "cardenloydf": 
            case "cardenloydb": 
            case "cardenloydn": 
            case "cardenloydj": 
            case "t27": 
            case "tks": 
            case "l33f": {
                return 2.87f;
            }
            case "ucarrier": {
                return 3.86f;
            }
            case "maultier": 
            case "maultier_canvas": {
                return 5.5f;
            }
            case "type94_truck": {
                return 4.8f;
            }
            case "opel_blitz": 
            case "opel_blitz_canvas": {
                return 4.6f;
            }
            case "cckw": 
            case "cckw_canvas": {
                return 4.0f;
            }
            case "wc51": 
            case "wc51_mg": {
                return 2.3f;
            }
            case "kubelwagen": 
            case "kubelwagen_mg": 
            case "kubelwagen_canvas": {
                return 0.8f;
            }
        }
        return 1.2f;
    }

    public AxisAlignedBB func_70114_g(Entity entityIn) {
        return new AxisAlignedBB(this.field_70165_t - 4.0, this.field_70163_u - this.func_70033_W() + 3.0, this.field_70161_v - 4.0, this.field_70165_t + 4.0, this.field_70163_u + 4.0, this.field_70161_v + 4.0);
    }

    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        for (int i = 0; i < this.seats.size(); ++i) {
            if (this.seats.get(i).func_184207_aI()) continue;
            this.seats.get(i).func_184230_a(player, hand);
            return true;
        }
        return false;
    }

    public boolean func_70104_M() {
        return true;
    }

    public double func_70042_X() {
        return (double)this.field_70131_O - 0.5;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source.func_76346_g() != null && source.func_76346_g().func_184187_bx() instanceof EntitySeat && ((EntitySeat)source.func_76346_g().func_184187_bx()).getParentVehicle() == this) {
            return false;
        }
        if (source.func_76346_g() instanceof EntityPlayer && CTBVConnector.getDriver((Entity)this) instanceof EntityPlayer && CTBPlayer.get((EntityPlayer)((EntityPlayer)source.func_76346_g())).side == CTBPlayer.get((EntityPlayer)((EntityPlayer)this.driversSeat.func_184188_bt().get((int)0))).side) {
            return false;
        }
        this.func_184185_a(SoundLoader.getSoundEvent((String)"ctb:hit"), 2.0f, 1.0f);
        if (this.func_180431_b(source) || this.getHealth() <= 0.0f) {
            return false;
        }
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
            boolean flag;
            this.setTimeSinceHit(10);
            this.setHealth(this.getHealth() - amount);
            boolean bl = flag = source.func_76346_g() instanceof EntityPlayer && ((EntityPlayer)source.func_76346_g()).field_71075_bZ.field_75098_d && !source.field_76373_n.equalsIgnoreCase("gun") && !source.field_76373_n.equalsIgnoreCase("gren") && !source.field_76373_n.equalsIgnoreCase("explosion");
            if (this.getHealth() <= 0.0f) {
                if (source.func_76346_g() instanceof EntityPlayer && CTBVConnector.getDriver((Entity)this) instanceof EntityPlayer) {
                    ProgressionSystem.addXP((EntityPlayer)((EntityPlayer)source.func_76346_g()), (String)"vehicle_kill", (String)CTBVConnector.getDriver((Entity)this).func_70005_c_());
                }
                for (int i = 0; i < this.seats.size(); ++i) {
                    EntitySeat seta = this.seats.get(i);
                    if (seta.getRider() == null) continue;
                    seta.getRider().func_184210_p();
                }
                if (!this.field_70170_p.field_72995_K) {
                    this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundLoader.getSoundEvent((String)"ctb:explode_v"), SoundCategory.BLOCKS, 10.0f, (1.0f + (this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat()) * 0.2f) * 0.7f, false);
                }
            } else if (flag) {
                this.func_70106_y();
            }
            return true;
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70057_ab() {
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    public void func_70107_b(double x, double y, double z) {
        super.func_70107_b(x, y, z);
        this.updateHitboxPositions();
    }

    @SideOnly(value=Side.CLIENT)
    public void setPositionAndRotation2(double x, double y, double z, float yaw, float pitch, int rotationIncrements) {
        if (this.isBoatEmpty) {
            this.boatPosRotationIncrements = rotationIncrements + 5;
        } else {
            double d3 = x - this.field_70165_t;
            double d4 = y - this.field_70163_u;
            double d5 = z - this.field_70161_v;
            double d6 = d3 * d3 + d4 * d4 + d5 * d5;
            if (d6 <= 1.0) {
                return;
            }
            this.boatPosRotationIncrements = 3;
        }
        this.boatX = x;
        this.boatY = y;
        this.boatZ = z;
        this.boatYaw = yaw;
        this.boatPitch = pitch;
        this.field_70159_w = this.velocityX;
        this.field_70181_x = this.velocityY;
        this.field_70179_y = this.velocityZ;
        this.updateHitboxPositions();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70016_h(double x, double y, double z) {
        this.velocityX = this.field_70159_w = x;
        this.velocityY = this.field_70181_x = y;
        this.velocityZ = this.field_70179_y = z;
    }

    public void updateHitboxPositions() {
        if (this.mainHitboxes == null) {
            return;
        }
        try {
            for (VehicleHitbox hitbox : this.mainHitboxes) {
                hitbox.updateHitbox(this);
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        this.lerpX = x;
        this.lerpY = y;
        this.lerpZ = z;
        this.lerpYaw = yaw;
        this.lerpPitch = pitch;
        this.lerpSteps = 10;
    }

    public void func_70071_h_() {
        int i;
        super.func_70071_h_();
        if (this.currentFireDelay > 0) {
            --this.currentFireDelay;
            if (!this.field_70170_p.field_72995_K && this.seats.get(0).getRider() instanceof EntityPlayerMP && this.currentFireDelay == 20) {
                CTBVehicles.ctbvChannel.sendTo((IMessage)new PacketVehicleSoundClient("load", (EntityLivingBase)this.seats.get(0).getRider(), this, false), (EntityPlayerMP)this.seats.get(0).getRider());
            }
        }
        this.prevDriven = this.driven;
        EntitySeat controllerSeat = this.getControllingSeat();
        boolean bl = this.driven = controllerSeat != null && controllerSeat.getRider() != null;
        if (!this.field_70170_p.field_72995_K && this.prevDriven != this.driven && !this.driven) {
            this.field_70181_x = 0.0;
            this.field_70163_u += 0.1;
            this.updateHitboxPositions();
        }
        if (!this.field_70170_p.field_72995_K && !this.driven && this.field_70173_aa > 200 && this.field_70173_aa % 20 == 0) {
            for (i = 0; i < this.seats.size(); ++i) {
                EntitySeat seat = this.seats.get(i);
                if (seat == null) continue;
                for (int i2 = 0; i2 < seat.func_184188_bt().size(); ++i2) {
                    Entity passenger = (Entity)seat.func_184188_bt().get(i2);
                    if (!(passenger instanceof EntitySoldier)) continue;
                    passenger.func_184210_p();
                }
            }
        }
        if (this.getHealth() <= 0.0f) {
            ++this.noHealthTime;
            for (i = 0; i < 2; ++i) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_LARGE, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0, new int[0]);
            }
            if (this.noHealthTime == 2400) {
                this.func_70106_y();
            }
        }
        if (this.field_70173_aa > 40 && !this.field_70170_p.field_72995_K && CTBDataHandler.hasGame() && CTBServerTicker.gamemode != null && !CTBServerTicker.gamemode.getMatchID().equals(this.matchId)) {
            this.func_70106_y();
        }
        if (!this.createdSeats && !this.field_70170_p.field_72995_K) {
            this.addSeats(this.field_70170_p);
            this.spawnSeats();
        }
        if (this.getTimeSinceHit() > 0) {
            this.setTimeSinceHit(this.getTimeSinceHit() - 1);
        }
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        double d0 = 0.0;
        double d10 = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y);
        if (d10 > 0.26249999999999996) {
            int j = 0;
            while ((double)j < 1.0 + d10 * 60.0) {
                double randomTick;
                if (this.field_70146_Z.nextBoolean() && (randomTick = Math.random()) < 0.1) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, this.field_70165_t, this.field_70163_u - 0.125, this.field_70161_v, 0.0, (double)0.05f, 0.0, new int[0]);
                }
                ++j;
            }
        }
        if (this.field_70170_p.field_72995_K && controllerSeat != null && controllerSeat.getRider() instanceof EntityPlayer && this.maxThrottle > 0.0f && (this.vehicleSound == null || this.vehicleSound.func_147667_k())) {
            this.vehicleSound = CTBVClient.playVehicleSound((EntityPlayer)controllerSeat.getRider(), "engineidle", this);
        }
        if (this.field_70170_p.field_72995_K && this.isBoatEmpty) {
            if (this.lerpSteps > 0) {
                double d0x = this.field_70165_t + (this.lerpX - this.field_70165_t) / (double)this.lerpSteps;
                double d1x = this.field_70163_u + (this.lerpY - this.field_70163_u) / (double)this.lerpSteps;
                double d2x = this.field_70161_v + (this.lerpZ - this.field_70161_v) / (double)this.lerpSteps;
                double d3x = MathHelper.func_76138_g((double)(this.lerpYaw - (double)this.field_70177_z));
                this.field_70177_z = (float)((double)this.field_70177_z + d3x / (double)this.lerpSteps);
                this.field_70125_A = (float)((double)this.field_70125_A + (this.lerpPitch - (double)this.field_70125_A) / (double)this.lerpSteps);
                --this.lerpSteps;
                this.func_70107_b(d0x, d1x, d2x);
                this.func_70101_b(this.field_70177_z, this.field_70125_A);
            } else {
                double d2 = this.field_70165_t + this.field_70159_w;
                double d4 = this.field_70163_u + this.field_70181_x;
                double d11 = this.field_70161_v + this.field_70179_y;
                this.func_70107_b(d2, d4, d11);
                if (this.field_70122_E) {
                    this.field_70159_w *= 0.5;
                    this.field_70181_x *= 0.5;
                    this.field_70179_y *= 0.5;
                }
                this.field_70159_w *= (double)0.99f;
                this.field_70181_x *= (double)0.95f;
                this.field_70179_y *= (double)0.99f;
            }
        } else {
            double d2 = d0 * 2.0 - 1.0;
            this.field_70181_x += 0.04 * d2;
            if (this.driven && controllerSeat != null) {
                this.driver = controllerSeat.getRider();
                this.pYaw = controllerSeat.pYaw;
                EntityPlayer player = (EntityPlayer)this.driver;
                CTBPlayer data = CTBPlayer.get((EntityPlayer)player);
                float f = this.field_70177_z + 90.0f;
                this.driver.field_70143_R = 0.0f;
                if (!this.isPlayerIn) {
                    this.isPlayerIn = true;
                }
                this.field_70177_z = controllerSeat.field_70177_z;
                this.boatYaw = this.field_70177_z;
                this.field_70126_B %= 360.0f;
                if (data.gasPressed == 1 && this.maxThrottle > 0.0f) {
                    double randomFuelTake;
                    if (Math.abs(this.field_70159_w) + Math.abs(this.field_70179_y) < (double)0.001f) {
                        this.throttleSpeed = 0.1f;
                    }
                    if (this.throttleSpeed <= 0.0f) {
                        this.throttleSpeed += this.acceleration;
                    }
                    if (this.throttleSpeed < this.maxThrottle) {
                        this.throttleSpeed += this.acceleration;
                    }
                    if (this.throttleSpeed > this.maxThrottle) {
                        this.throttleSpeed = this.maxThrottle;
                    }
                    if ((randomFuelTake = Math.random()) < 0.1) {
                        this.consumeFuel();
                    }
                    this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_LARGE, this.boatX + 0.5, this.boatY + (double)1.02f, this.boatZ + 0.5, 0.0, 0.2, 0.0, new int[0]);
                    this.field_70159_w = -Math.sin(f * (float)Math.PI / 180.0f) * (double)this.throttleSpeed;
                    this.field_70179_y = Math.cos(f * (float)Math.PI / 180.0f) * (double)this.throttleSpeed;
                } else if (data.gasPressed == 2) {
                    if (this.throttleSpeed > 0.0f) {
                        this.throttleSpeed -= this.acceleration * 2.0f;
                    }
                    if (this.getResourceName().startsWith("kp")) {
                        if (this.throttleSpeed > -this.maxThrottle) {
                            this.throttleSpeed -= this.acceleration;
                        }
                        if (this.throttleSpeed < -this.maxThrottle) {
                            this.throttleSpeed = -this.maxThrottle;
                        }
                    } else {
                        if (this.throttleSpeed > -this.maxThrottle / 2.0f) {
                            this.throttleSpeed -= this.acceleration / 1.5f;
                        }
                        if (this.throttleSpeed < -this.maxThrottle / 2.0f) {
                            this.throttleSpeed = -(this.maxThrottle / 2.0f);
                        }
                    }
                    this.field_70159_w = -Math.sin(f * (float)Math.PI / 180.0f) * (double)this.throttleSpeed;
                    this.field_70179_y = Math.cos(f * (float)Math.PI / 180.0f) * (double)this.throttleSpeed;
                } else {
                    if (this.throttleSpeed > 0.0f) {
                        this.throttleSpeed -= 0.005f;
                        if (this.throttleSpeed < 0.01f) {
                            this.throttleSpeed = 0.0f;
                            this.field_70159_w = 0.0;
                            this.field_70179_y = 0.0;
                        }
                    }
                    if (this.throttleSpeed < 0.0f) {
                        this.throttleSpeed += 0.005f;
                        if (this.throttleSpeed > -0.01f) {
                            this.throttleSpeed = 0.0f;
                            this.field_70159_w = 0.0;
                            this.field_70179_y = 0.0;
                        }
                    }
                    this.field_70159_w = -Math.sin(f * (float)Math.PI / 180.0f) * (double)this.throttleSpeed;
                    this.field_70179_y = Math.cos(f * (float)Math.PI / 180.0f) * (double)this.throttleSpeed;
                }
                if (data.brakePressed == 1) {
                    if (this.throttleSpeed > 0.0f) {
                        this.throttleSpeed -= this.acceleration * 2.0f;
                    } else if (this.throttleSpeed < 0.0f) {
                        this.throttleSpeed += this.acceleration * 2.0f;
                    }
                    if (Math.abs(this.throttleSpeed) < this.acceleration * 2.0f) {
                        this.throttleSpeed = 0.0f;
                    }
                }
            } else {
                if (this.isPlayerIn) {
                    this.isPlayerIn = false;
                }
                float f = this.field_70177_z + 90.0f;
                this.field_70159_w = -Math.sin(f * (float)Math.PI / 180.0f) * (double)this.throttleSpeed;
                this.field_70179_y = Math.cos(f * (float)Math.PI / 180.0f) * (double)this.throttleSpeed;
                if (this.throttleSpeed > 0.0f) {
                    this.throttleSpeed -= this.acceleration;
                } else if (this.throttleSpeed < 0.0f) {
                    this.throttleSpeed += this.acceleration;
                }
                if (this.throttleSpeed != 0.0f && Math.abs(this.throttleSpeed) < this.acceleration) {
                    this.throttleSpeed = 0.0f;
                    this.field_70159_w = 0.0;
                    this.field_70179_y = 0.0;
                }
            }
            if (!this.field_70170_p.field_72995_K) {
                if (this.maxThrottle > 0.0f) {
                    ArrayList<EntityVehicle> collidingVehicles = this.getCollidingVehicles(this.field_70159_w / 5.0, this.field_70181_x / 5.0, this.field_70179_y / 5.0);
                    for (EntityVehicle vehicle : collidingVehicles) {
                        if (!vehicle.func_70104_M()) continue;
                        this.func_70108_f(vehicle);
                    }
                }
                if (this.driver != null && this.driver.field_70128_L) {
                    this.driver = null;
                }
            }
            this.moveEntity(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70125_A = 0.0f;
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
            if (!this.field_70170_p.field_72995_K) {
                List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72314_b(4.0, 4.0, 4.0));
                double motion = Math.abs(this.field_70159_w) + Math.abs(this.field_70179_y);
                int hitEntities = 0;
                if (list != null && !list.isEmpty()) {
                    for (int k1 = 0; k1 < list.size(); ++k1) {
                        Entity entity = (Entity)list.get(k1);
                        if (entity instanceof EntityVehicle || entity instanceof EntitySeat || entity.func_184187_bx() instanceof EntitySeat || !(entity instanceof EntityLivingBase)) continue;
                        float damage = (float)Math.floor(motion * 45.0);
                        if (entity == this.driver || entity.field_70128_L || entity.func_184187_bx() != null) continue;
                        Vec3d pointVec = new Vec3d(entity.field_70165_t, entity.field_70163_u + (double)entity.field_70131_O + (double)0.1f, entity.field_70161_v);
                        Vec3d pointVec2 = new Vec3d(entity.field_70165_t, entity.field_70163_u + (double)(entity.field_70131_O / 2.0f), entity.field_70161_v);
                        Vec3d pointVec3 = new Vec3d(entity.field_70165_t, entity.field_70163_u + (double)entity.field_70131_O, entity.field_70161_v);
                        if (damage > 5.0f && Math.abs(this.throttleSpeed) > 0.3f && (this.isPointInside(pointVec) || this.isPointInside(pointVec2) || this.isPointInside(pointVec3))) {
                            if (controllerSeat != null && controllerSeat.getRider() != null) {
                                entity.func_70097_a(CTB.causeRunOverDamage((Entity)controllerSeat.getRider()), damage);
                            } else {
                                entity.func_70097_a(CTB.runover, damage);
                            }
                        }
                        ++hitEntities;
                    }
                }
                for (int i2 = 0; i2 < hitEntities; ++i2) {
                    if (this.throttleSpeed > 0.1f) {
                        this.throttleSpeed -= 0.02f;
                        if (this.throttleSpeed < 0.1f) {
                            this.throttleSpeed = 0.1f;
                        }
                    }
                    if (!(this.throttleSpeed < -0.1f)) continue;
                    this.throttleSpeed += 0.02f;
                    if (!(this.throttleSpeed > -0.1f)) continue;
                    this.throttleSpeed = -0.1f;
                }
            }
        }
        this.prevGunPitch = this.gunPitch;
        if (controllerSeat != null && controllerSeat.getRider() != null) {
            this.gunPitch = controllerSeat.getRider().field_70125_A;
        }
        this.driver = null;
        this.updateHitboxPositions();
        this.ippX = this.field_70159_w;
        this.ippZ = this.field_70179_y;
    }

    public void func_70108_f(Entity entityIn) {
        if (entityIn.func_184187_bx() instanceof EntitySeat) {
            return;
        }
        if (entityIn instanceof EntityVehicle) {
            EntityVehicle vehicle = (EntityVehicle)entityIn;
            double d0 = entityIn.field_70165_t - this.field_70165_t;
            double d1 = entityIn.field_70161_v - this.field_70161_v;
            double d2 = MathHelper.func_76132_a((double)d0, (double)d1);
            if (d2 >= (double)0.01f) {
                float theirWeight;
                double their_motion;
                d2 = MathHelper.func_76133_a((double)d2);
                d0 /= d2;
                d1 /= d2;
                double d3 = 1.0 / d2;
                if (d3 > 1.0) {
                    d3 = 1.0;
                }
                d0 *= d3;
                d1 *= d3;
                d0 *= (double)0.05f;
                d1 *= (double)0.05f;
                d0 *= (double)(1.0f - this.field_70144_Y);
                d1 *= (double)(1.0f - this.field_70144_Y);
                double their_throttle = (double)vehicle.throttleSpeed * 10.0;
                if (their_throttle < 1.0) {
                    their_throttle = 1.0;
                }
                if ((their_motion = (Math.abs(entityIn.field_70159_w) + Math.abs(entityIn.field_70179_y)) * 5.0) < 1.0) {
                    their_motion = 1.0;
                }
                double d0_this = d0 * (their_motion *= their_throttle);
                double d1_this = d1 * their_motion;
                float ourWeight = this.getVehicleWeight();
                double velocityLoss = ourWeight > (theirWeight = vehicle.getVehicleWeight()) ? (double)(1.0f - theirWeight / ourWeight) : (double)(ourWeight / theirWeight);
                this.field_70159_w *= (velocityLoss /= 2.0);
                this.field_70179_y *= velocityLoss;
                if (ourWeight > theirWeight) {
                    d0_this *= velocityLoss;
                    d1_this *= velocityLoss;
                }
                this.func_70024_g(-d0_this, 0.0, -d1_this);
                float ourMoveAmount = (float)Math.sqrt(Math.abs(this.ippX * this.ippX) + Math.abs(this.ippZ * this.ippZ));
                if ((double)ourMoveAmount >= (double)this.maxThrottle * 0.7) {
                    float damage = ourMoveAmount * (float)(200 + this.field_70146_Z.nextInt(100)) * (this.throttleSpeed / this.maxThrottle);
                    float damageToUs = damage / 3.0f;
                    damage *= ourWeight / theirWeight;
                    damageToUs *= theirWeight / ourWeight;
                    if (this.driven && this.driver != null) {
                        this.driver.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "Rammed for " + (int)damage + "dmg, took " + (int)damageToUs + " dmg."));
                    }
                    if (damage > 0.0f) {
                        vehicle.func_70097_a(CTB.runover, damage);
                    }
                    if (damageToUs > 0.0f) {
                        this.func_70097_a(CTB.runover, damageToUs);
                    }
                } else if (this.field_70163_u > entityIn.field_70163_u + 1.0 && this.field_70173_aa % 10 == 0) {
                    vehicle.func_70097_a(CTB.runover, 30.0f);
                }
            }
        }
    }

    public void updateRiderPosition() {
    }

    protected void func_70014_b(NBTTagCompound tagCompound) {
        tagCompound.func_74776_a("maxThrottle", this.maxThrottle);
        tagCompound.func_74776_a("acceleration", this.acceleration);
        tagCompound.func_74776_a("maxTurnRate", this.maxTurnRate);
        tagCompound.func_74778_a("resourceName", this.resourceName);
        tagCompound.func_74778_a("textureName", this.textureName);
        tagCompound.func_74776_a("pYaw", this.pYaw);
        tagCompound.func_74776_a("health", this.getHealth());
        tagCompound.func_74776_a("maxHealth", this.getMaxHealth());
        tagCompound.func_74776_a("gunPitch", this.gunPitch);
        if (this.matchId != null) {
            tagCompound.func_74778_a("matchID", this.matchId.toString());
        }
        this.createHitbox();
    }

    protected void func_70037_a(NBTTagCompound tagCompound) {
        this.maxThrottle = tagCompound.func_74760_g("maxThrottle");
        this.acceleration = tagCompound.func_74760_g("acceleration");
        this.maxTurnRate = tagCompound.func_74760_g("maxTurnRate");
        this.resourceName = tagCompound.func_74779_i("resourceName");
        this.textureName = tagCompound.func_74779_i("textureName");
        this.field_70177_z = this.pYaw = tagCompound.func_74760_g("pYaw");
        this.setHealth(tagCompound.func_74760_g("health"));
        this.setMaxHealth(tagCompound.func_74760_g("maxHealth"));
        this.gunPitch = tagCompound.func_74760_g("gunPitch");
        if (tagCompound.func_74779_i("matchID") != null && !tagCompound.func_74779_i("matchID").isEmpty()) {
            this.matchId = UUID.fromString(tagCompound.func_74779_i("matchID"));
        }
        this.createHitbox();
    }

    @SideOnly(value=Side.CLIENT)
    public float getShadowSize() {
        return 0.0f;
    }

    protected void updateFallState(double distanceFallenThisTick, boolean isOnGround) {
        int i = MathHelper.func_76128_c((double)this.field_70165_t);
        int j = MathHelper.func_76128_c((double)this.field_70163_u);
        int k = MathHelper.func_76128_c((double)this.field_70161_v);
        if (isOnGround) {
            if (this.field_70143_R > 6.0f) {
                this.func_180430_e(this.field_70143_R, 1.0f);
                this.field_70143_R = 0.0f;
            }
        } else if (this.field_70170_p.func_180495_p(new BlockPos(i, j - 1, k)).func_185904_a() != Material.field_151586_h && distanceFallenThisTick < 0.0) {
            this.field_70143_R = (float)((double)this.field_70143_R - distanceFallenThisTick);
        }
    }

    private void consumeFuel() {
    }

    public int getSkin() {
        return this.currentSkin;
    }

    private void setSkin(int givenSkin) {
        this.currentSkin = givenSkin;
    }

    private int randomSkin() {
        int maxSkinIndex = 3;
        return (int)(Math.random() * (double)(maxSkinIndex + 1));
    }

    public String getTextureResourceName() {
        return this.textureName != null ? this.textureName : this.getResourceName();
    }

    public String getResourceName() {
        String rname = this.resourceName;
        if (rname.contains(".")) {
            rname = rname.split("[.]")[0];
        }
        return rname;
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeFloat(this.maxThrottle);
        buffer.writeFloat(this.acceleration);
        buffer.writeFloat(this.maxTurnRate);
        buffer.writeFloat(this.getMaxHealth());
        buffer.writeFloat(this.getHealth());
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.resourceName);
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.textureName);
        this.createHitbox();
    }

    public void readSpawnData(ByteBuf additionalData) {
        this.maxThrottle = additionalData.readFloat();
        this.acceleration = additionalData.readFloat();
        this.maxTurnRate = additionalData.readFloat();
        this.setMaxHealth(additionalData.readFloat());
        this.setHealth(additionalData.readFloat());
        this.resourceName = ByteBufUtils.readUTF8String((ByteBuf)additionalData);
        this.textureName = ByteBufUtils.readUTF8String((ByteBuf)additionalData);
        this.createHitbox();
    }

    public void addSeats(World world) {
        this.seats.clear();
        SeatCreator.addSeatsFor(this);
    }

    public ArrayList<AxisAlignedBB> getCollidingBoundingBoxes(double x, double y, double z) {
        return this.getCollidingBoundingBoxes(x, y, z, false, false, 0);
    }

    public ArrayList<AxisAlignedBB> getCollidingBoundingBoxes(double x, double y, double z, boolean belowOnly, boolean complex, int addCheck) {
        if (y < 0.0) {
            // empty if block
        }
        ArrayList<VehicleHitbox> allMainHitboxes = new ArrayList<VehicleHitbox>(this.mainHitboxes);
        ArrayList<AxisAlignedBB> collidingBoundingBoxes = new ArrayList<AxisAlignedBB>();
        double xMin = this.field_70165_t - 1.0;
        double xMax = this.field_70165_t + 1.0;
        double yMin = this.field_70163_u - 1.0;
        double yMax = this.field_70163_u + 1.0;
        double zMin = this.field_70161_v - 1.0;
        double zMax = this.field_70161_v + 1.0;
        for (VehicleHitbox hitbox : allMainHitboxes) {
            for (VHFace face : hitbox.hitboxFaces) {
                for (Vec3d vec : face.points) {
                    if (vec.field_72450_a < xMin) {
                        xMin = vec.field_72450_a;
                    }
                    if (vec.field_72450_a > xMax) {
                        xMax = vec.field_72450_a;
                    }
                    if (vec.field_72448_b < yMin) {
                        yMin = vec.field_72448_b;
                    }
                    if (vec.field_72448_b > yMax) {
                        yMax = vec.field_72448_b;
                    }
                    if (vec.field_72449_c < zMin) {
                        zMin = vec.field_72449_c;
                    }
                    if (!(vec.field_72449_c > zMax)) continue;
                    zMax = vec.field_72449_c;
                }
            }
        }
        xMin -= 0.5;
        xMax += 0.5;
        zMin -= 0.5;
        zMax += 0.5;
        if (x < 0.0) {
            xMin += x;
        }
        if (x > 0.0) {
            xMax += x;
        }
        if (y < 0.0) {
            yMin += y;
        }
        if (y > 0.0) {
            yMax += y;
        }
        if (z < 0.0) {
            zMin += z;
        }
        if (z > 0.0) {
            zMax += z;
        }
        int i = MathHelper.func_76128_c((double)xMin);
        int j = MathHelper.func_76128_c((double)xMax);
        int k = MathHelper.func_76128_c((double)yMin);
        int l = MathHelper.func_76128_c((double)yMax);
        int i1 = MathHelper.func_76128_c((double)zMin);
        int j1 = MathHelper.func_76128_c((double)zMax);
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = i1; l1 < j1; ++l1) {
                for (int i2 = k - 1; i2 < l; ++i2) {
                    double centerZ;
                    BlockPos blockPos;
                    IBlockState blockState = k1 >= -30000000 && k1 < 30000000 && l1 >= -30000000 && l1 < 30000000 ? this.field_70170_p.func_180495_p(blockPos) : Blocks.field_150348_b.func_176223_P();
                    AxisAlignedBB axisalignedbb1 = blockState.func_185890_d((IBlockAccess)this.field_70170_p, blockPos = new BlockPos(k1, i2, l1));
                    if (axisalignedbb1 == null) continue;
                    axisalignedbb1 = new AxisAlignedBB((double)blockPos.func_177958_n() + axisalignedbb1.field_72340_a, (double)blockPos.func_177956_o() + axisalignedbb1.field_72338_b, (double)blockPos.func_177952_p() + axisalignedbb1.field_72339_c, (double)blockPos.func_177958_n() + axisalignedbb1.field_72336_d, (double)blockPos.func_177956_o() + axisalignedbb1.field_72337_e, (double)blockPos.func_177952_p() + axisalignedbb1.field_72334_f);
                    if (complex) {
                        if (!this.isPointInsideOffset(new Vec3d(axisalignedbb1.field_72340_a, axisalignedbb1.field_72338_b, axisalignedbb1.field_72339_c), x, y, z) && !this.isPointInsideOffset(new Vec3d(axisalignedbb1.field_72336_d, axisalignedbb1.field_72338_b, axisalignedbb1.field_72339_c), x, y, z) && !this.isPointInsideOffset(new Vec3d(axisalignedbb1.field_72336_d, axisalignedbb1.field_72338_b, axisalignedbb1.field_72334_f), x, y, z) && !this.isPointInsideOffset(new Vec3d(axisalignedbb1.field_72340_a, axisalignedbb1.field_72338_b, axisalignedbb1.field_72334_f), x, y, z) && !this.isPointInsideOffset(new Vec3d(axisalignedbb1.field_72340_a, axisalignedbb1.field_72337_e, axisalignedbb1.field_72339_c), x, y, z) && !this.isPointInsideOffset(new Vec3d(axisalignedbb1.field_72336_d, axisalignedbb1.field_72337_e, axisalignedbb1.field_72339_c), x, y, z) && !this.isPointInsideOffset(new Vec3d(axisalignedbb1.field_72336_d, axisalignedbb1.field_72337_e, axisalignedbb1.field_72334_f), x, y, z) && !this.isPointInsideOffset(new Vec3d(axisalignedbb1.field_72340_a, axisalignedbb1.field_72337_e, axisalignedbb1.field_72334_f), x, y, z)) continue;
                        collidingBoundingBoxes.add(axisalignedbb1);
                        continue;
                    }
                    double centerX = axisalignedbb1.field_72340_a + (axisalignedbb1.field_72336_d - axisalignedbb1.field_72340_a) / 2.0;
                    double centerY = axisalignedbb1.field_72338_b > this.field_70163_u + (double)addCheck ? axisalignedbb1.field_72338_b : axisalignedbb1.field_72337_e;
                    if (!this.isPointInsideOffset(new Vec3d(centerX, centerY, centerZ = axisalignedbb1.field_72339_c + (axisalignedbb1.field_72334_f - axisalignedbb1.field_72339_c) / 2.0), x, y, z)) continue;
                    collidingBoundingBoxes.add(axisalignedbb1);
                }
            }
        }
        return collidingBoundingBoxes;
    }

    public EntitySeat getControllingSeat() {
        if (this.driversSeat != null && this.driversSeat.getRider() != null) {
            return this.driversSeat;
        }
        for (int i = 0; i < this.seats.size(); ++i) {
            EntitySeat seat = this.seats.get(i);
            if (!seat.isScoped || !(seat.getRider() instanceof EntityPlayer)) continue;
            return seat;
        }
        return null;
    }

    public ArrayList<EntityVehicle> getCollidingVehicles(double x, double y, double z) {
        EntitySeat controllerSeat = this.getControllingSeat();
        int side = 0;
        if (controllerSeat != null && controllerSeat.getRider() instanceof EntityPlayer) {
            side = CTBPlayer.get((EntityPlayer)((EntityPlayer)controllerSeat.getRider())).side;
        }
        ArrayList<EntityVehicle> collidingVehicles = new ArrayList<EntityVehicle>();
        double d0 = 8.25;
        List list = this.field_70170_p.func_72872_a(EntityVehicle.class, this.func_174813_aQ().func_72314_b(d0, d0, d0));
        for (int j2 = 0; j2 < list.size(); ++j2) {
            EntityVehicle vehicle = (EntityVehicle)((Object)list.get(j2));
            if (vehicle == this || vehicle.mainHitboxes.isEmpty() || this.mainHitboxes.isEmpty()) continue;
            int side2 = 0;
            EntitySeat otherControllingSeat = vehicle.getControllingSeat();
            if (otherControllingSeat != null && otherControllingSeat.getRider() instanceof EntityPlayer) {
                side = CTBPlayer.get((EntityPlayer)((EntityPlayer)otherControllingSeat.getRider())).side;
            }
            if (side != 0 && side == side2 || !this.isHitboxInsideMainHitbox(vehicle.mainHitboxes.get(0), x, y, z) && !vehicle.isHitboxInsideMainHitbox(this.mainHitboxes.get(0), -x, -y, -z)) continue;
            collidingVehicles.add(vehicle);
        }
        return collidingVehicles;
    }

    public RayTraceResult rayCast(Vec3d posVec, float dir, double length) {
        return this.rayCast(posVec, dir, length, false);
    }

    public RayTraceResult rayCast(Vec3d posVec, float dir, double length, boolean debug) {
        float cosYaw = MathHelper.func_76134_b((float)(dir * 0.01745329f - 3.141593f));
        float sinYaw = MathHelper.func_76126_a((float)(dir * 0.01745329f - 3.141593f));
        float cosPitch = -MathHelper.func_76134_b((float)0.0f);
        float sinPitch = MathHelper.func_76126_a((float)0.0f);
        Vec3d endVec = posVec.func_72441_c((double)(sinYaw * cosPitch) * length, (double)sinPitch * length, (double)(cosYaw * cosPitch) * length);
        return this.field_70170_p.func_147447_a(posVec, endVec, false, true, false);
    }

    public Vec3d getOffset(float xOff, float yOff, float zOff, float yaw) {
        return new Vec3d(this.field_70165_t + ((double)(MathHelper.func_76134_b((float)(yaw / 180.0f * (float)Math.PI)) * xOff) - (double)(MathHelper.func_76126_a((float)(yaw / 180.0f * (float)Math.PI)) * zOff)), this.field_70163_u + (double)yOff, this.field_70161_v + ((double)(MathHelper.func_76126_a((float)((yaw + 90.0f) / 180.0f * (float)Math.PI)) * zOff) - (double)(MathHelper.func_76134_b((float)((yaw + 90.0f) / 180.0f * (float)Math.PI)) * xOff)));
    }

    public boolean hitBlock(RayTraceResult mop) {
        return mop != null && mop.field_72313_a == RayTraceResult.Type.BLOCK;
    }

    public boolean canStepBlock(BlockPos pos) {
        return this.field_70170_p.func_180495_p(pos).func_177230_c() != CTB.hedgehog;
    }

    public void moveEntity(MoverType type, double x, double y, double z) {
        EntitySeat controllingSeat = this.getControllingSeat();
        if (controllingSeat == null) {
            return;
        }
        boolean ableToMove = false;
        if (this.mainHitboxes.isEmpty()) {
            super.func_70091_d(type, x, y, z);
            return;
        }
        if (!this.field_70170_p.func_175667_e(new BlockPos((int)this.field_70165_t, 64, (int)this.field_70161_v))) {
            return;
        }
        if (y < -1.0) {
            y = -1.0;
        }
        double tries = 0.0;
        this.field_70122_E = true;
        boolean ableToMoveY = false;
        Object aabb = null;
        Vec3d startVec = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        RayTraceResult mop = null;
        float yaw = (controllingSeat.internalYaw - 180.0f) % 360.0f;
        Vec3d posVecBackLeft = this.getOffset(-2.0f, 0.0f, 1.0f, yaw);
        Vec3d posVecBackRight = this.getOffset(-2.0f, 0.0f, -1.0f, yaw);
        Vec3d posVecFrontLeft = this.getOffset(2.0f, 0.0f, 1.0f, yaw);
        Vec3d posVecFrontRight = this.getOffset(2.0f, 0.0f, -1.0f, yaw);
        if (this.hitBlock(this.field_70170_p.func_147447_a(posVecBackLeft, posVecBackLeft.func_72441_c(0.0, -this.func_70033_W(), 0.0), false, true, false)) || this.hitBlock(this.field_70170_p.func_147447_a(posVecBackRight, posVecBackRight.func_72441_c(0.0, -this.func_70033_W(), 0.0), false, true, false)) || this.hitBlock(this.field_70170_p.func_147447_a(posVecFrontLeft, posVecFrontLeft.func_72441_c(0.0, -this.func_70033_W(), 0.0), false, true, false)) || this.hitBlock(this.field_70170_p.func_147447_a(posVecFrontRight, posVecFrontRight.func_72441_c(0.0, -this.func_70033_W(), 0.0), false, true, false)) || this.hitBlock(this.field_70170_p.func_147447_a(posVecFrontRight.func_72441_c(0.0, -this.func_70033_W(), 0.0), posVecBackLeft.func_72441_c(0.0, -this.func_70033_W(), 0.0), false, true, false))) {
            ableToMoveY = false;
            this.field_70122_E = true;
        } else {
            ableToMoveY = true;
            this.field_70122_E = false;
        }
        Vec3d posVec = new Vec3d(this.field_70165_t, this.field_70163_u - this.func_70033_W() + (double)0.1f, this.field_70161_v);
        if (!ableToMoveY) {
            y = 0.0;
        }
        if (this.field_70122_E && this.field_70181_x < 0.0) {
            this.field_70181_x = 0.0;
        }
        if (x != 0.0 && z != 0.0) {
            ableToMove = true;
            float dir = this.throttleSpeed < 0.0f ? 90.0f : -90.0f;
            double castLength = this.throttleSpeed < 0.0f ? this.backLength : this.frontLength;
            Vec3d posVecLeft = this.getOffset(0.0f, -((float)this.func_70033_W()) + 0.1f, 1.0f, yaw);
            Vec3d posVecRight = this.getOffset(0.0f, -((float)this.func_70033_W()) + 0.1f, -1.0f, yaw);
            RayTraceResult mopLeft = null;
            RayTraceResult mopRight = null;
            mopLeft = this.rayCast(posVecLeft, -controllingSeat.internalYaw + dir, castLength);
            if (this.hitBlock(mopLeft) || this.hitBlock(mopRight = this.rayCast(posVecRight, -controllingSeat.internalYaw + dir, castLength)) || this.hitBlock(mop = this.rayCast(posVec, -controllingSeat.internalYaw + dir, castLength))) {
                boolean canStep;
                ableToMove = false;
                boolean bl = canStep = (this.field_70122_E || y <= 0.0) && this.driven;
                if (mopLeft != null && !this.canStepBlock(mopLeft.func_178782_a()) || mopRight != null && !this.canStepBlock(mopRight.func_178782_a()) || mop != null && !this.canStepBlock(mop.func_178782_a())) {
                    canStep = false;
                }
                if (canStep) {
                    ableToMove = true;
                    posVec = posVec.func_72441_c(0.0, (double)this.field_70138_W, 0.0);
                    posVecLeft = posVecLeft.func_72441_c(0.0, (double)this.field_70138_W, 0.0);
                    posVecRight = posVecRight.func_72441_c(0.0, (double)this.field_70138_W, 0.0);
                    mop = this.rayCast(posVecLeft, -controllingSeat.internalYaw + dir, castLength);
                    if (this.hitBlock(mop) || this.hitBlock(mopLeft = this.rayCast(posVecRight, -controllingSeat.internalYaw + dir, castLength)) || this.hitBlock(mopRight = this.rayCast(posVec, -controllingSeat.internalYaw + dir, castLength))) {
                        ableToMove = false;
                    }
                    if (ableToMove) {
                        y = this.field_70138_W;
                    }
                }
            }
            tries = 0.0;
        }
        if (ableToMove) {
            this.field_70165_t += x;
            this.field_70163_u += y;
            this.field_70161_v += z;
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        } else if (ableToMoveY) {
            this.field_70163_u += y;
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        }
        if (!ableToMove) {
            this.throttleSpeed = 0.0f;
        }
    }

    public void func_70015_d(int seconds) {
        int j;
        this.fire = j = seconds * 20;
    }

    public void func_70066_B() {
        this.fire = 0;
    }

    public boolean func_70027_ad() {
        boolean flag = this.field_70170_p != null && this.field_70170_p.field_72995_K;
        return !this.field_70178_ae && (this.fire > 0 || flag && this.func_70083_f(0));
    }

    public void func_70077_a(EntityLightningBolt lightningBolt) {
        this.func_70081_e(5);
        ++this.fire;
        if (this.fire == 0) {
            this.func_70015_d(8);
        }
    }
}

