/*
 * Decompiled with CFR 0.152.
 */
package ctb_vehicles.common.entity.hitboxes;

import ctb_vehicles.common.entity.EntityVehicle;
import ctb_vehicles.common.entity.hitboxes.HitboxModel;
import ctb_vehicles.common.entity.hitboxes.VehicleHitbox;
import ctb_vehicles.common.entity.hitboxes.germany.Kubelwagen;
import ctb_vehicles.common.entity.hitboxes.germany.LEIG;
import ctb_vehicles.common.entity.hitboxes.germany.OpelBlitz;
import ctb_vehicles.common.entity.hitboxes.germany.Placeholder;
import ctb_vehicles.common.entity.hitboxes.germany.Type92Bat;
import ctb_vehicles.common.entity.hitboxes.italy.L335;
import ctb_vehicles.common.entity.hitboxes.japan.Kurogane;
import ctb_vehicles.common.entity.hitboxes.poland.TKS;
import ctb_vehicles.common.entity.hitboxes.ru.M1927Reg;
import ctb_vehicles.common.entity.hitboxes.uk.UniversalCarrier;
import ctb_vehicles.common.entity.hitboxes.us.CCKW;
import ctb_vehicles.common.entity.hitboxes.us.M1Pack;
import ctb_vehicles.common.entity.hitboxes.us.WC51;
import ctb_vehicles.common.entity.hitboxes.us.WillysMB;
import java.util.ArrayList;
import java.util.HashMap;

public class HitboxCreator {
    public static HashMap<String, HitboxModel> hitboxModels = new HashMap();

    public static ArrayList<VehicleHitbox> createHitboxFor(EntityVehicle vehicle) {
        return HitboxCreator.createHitboxFor(vehicle, "normal");
    }

    public static ArrayList<VehicleHitbox> createHitboxFor(EntityVehicle vehicle, String hitboxType) {
        HitboxModel model = null;
        String resourceName = vehicle.getResourceName();
        if (hitboxModels.containsKey(resourceName)) {
            model = hitboxModels.get(resourceName);
        } else {
            if (resourceName.contains(",")) {
                resourceName = resourceName.substring(resourceName.indexOf(","));
            }
            if (resourceName.contains(".")) {
                resourceName = resourceName.substring(resourceName.indexOf("."));
            }
            switch (resourceName) {
                case "sdkfz9": {
                    model = new OpelBlitz();
                    break;
                }
                case "sdkfz250": {
                    model = new OpelBlitz();
                    break;
                }
                case "kp": 
                case "kpj": 
                case "kps": {
                    model = new Placeholder();
                    break;
                }
                case "cardenloyd": 
                case "cardenloydf": 
                case "cardenloydb": 
                case "cardenloydn": 
                case "cardenloydj": {
                    model = new TKS();
                    break;
                }
                case "t27": 
                case "tks": {
                    model = new TKS();
                    break;
                }
                case "l335": {
                    model = new L335();
                    break;
                }
                case "ucarrier": 
                case "ucarrier_at": {
                    model = new UniversalCarrier();
                    break;
                }
                case "type92bat": {
                    model = new Type92Bat();
                    break;
                }
                case "leig18": {
                    model = new LEIG();
                    break;
                }
                case "m1pack": {
                    model = new M1Pack();
                    break;
                }
                case "m1927reg": 
                case "m1927regcap": {
                    model = new M1927Reg();
                    break;
                }
                case "cckw": 
                case "cckw_canvas": {
                    model = new CCKW();
                    break;
                }
                case "wc51": 
                case "wc51_mg": {
                    model = new WC51();
                    break;
                }
                case "m3a1_scout": 
                case "willys_mb": 
                case "willys_mb_mg": 
                case "willys_mb_canopy": {
                    model = new WillysMB();
                    break;
                }
                case "type94_truck": {
                    model = new OpelBlitz();
                    break;
                }
                case "opel_blitz": 
                case "opel_blitz_canvas": 
                case "maultier": 
                case "maultier_canvas": {
                    model = new OpelBlitz();
                    break;
                }
                case "kubelwagen": 
                case "kubelwagen_mg": 
                case "kubelwagen_canvas": {
                    model = new Kubelwagen();
                    break;
                }
                case "kurogane": {
                    model = new Kurogane();
                }
            }
            hitboxModels.put(vehicle.resourceName, model);
        }
        if (model == null) {
            vehicle.frontLength = 2.0;
            vehicle.backLength = 2.0;
            return new ArrayList<VehicleHitbox>();
        }
        vehicle.frontLength = model.getFrontLength();
        vehicle.backLength = model.getBackLength();
        if (hitboxType.equalsIgnoreCase("complex")) {
            return model.getComplexHitbox();
        }
        if (hitboxType.equalsIgnoreCase("walking")) {
            return model.getWalkingHitbox();
        }
        return model.getMainHitbox();
    }
}

