/*
 * Decompiled with CFR 0.152.
 */
package ctb_vehicles.common.entity.hitboxes;

import ctb_vehicles.common.entity.EntityVehicle;
import ctb_vehicles.common.entity.hitboxes.VHFace;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;

public class VehicleHitbox {
    public VHFace[] base_faces;
    public VHFace[] hitboxFaces;
    public boolean isTurretHitbox = false;
    private float thickness;

    public VehicleHitbox(float thickness) {
        this.thickness = thickness;
        this.base_faces = new VHFace[]{new VHFace(new Vec3d[]{new Vec3d(0.0, 0.0, 0.0), new Vec3d(1.0, 0.0, 0.0), new Vec3d(1.0, 0.0, 1.0), new Vec3d(0.0, 0.0, 1.0)}), new VHFace(new Vec3d[]{new Vec3d(0.0, 1.0, 0.0), new Vec3d(0.0, 1.0, 1.0), new Vec3d(1.0, 1.0, 1.0), new Vec3d(1.0, 1.0, 0.0)}), new VHFace(new Vec3d[]{new Vec3d(0.0, 0.0, 0.0), new Vec3d(0.0, 0.0, 1.0), new Vec3d(0.0, 1.0, 1.0), new Vec3d(0.0, 1.0, 0.0)}), new VHFace(new Vec3d[]{new Vec3d(1.0, 0.0, 0.0), new Vec3d(1.0, 1.0, 0.0), new Vec3d(1.0, 1.0, 1.0), new Vec3d(1.0, 0.0, 1.0)}), new VHFace(new Vec3d[]{new Vec3d(0.0, 0.0, 1.0), new Vec3d(1.0, 0.0, 1.0), new Vec3d(1.0, 1.0, 1.0), new Vec3d(0.0, 1.0, 1.0)}), new VHFace(new Vec3d[]{new Vec3d(0.0, 0.0, 0.0), new Vec3d(0.0, 1.0, 0.0), new Vec3d(1.0, 1.0, 0.0), new Vec3d(1.0, 0.0, 0.0)})};
        this.hitboxFaces = new VHFace[]{new VHFace(new Vec3d[]{new Vec3d(0.0, 0.0, 0.0), new Vec3d(1.0, 0.0, 0.0), new Vec3d(1.0, 0.0, 1.0), new Vec3d(0.0, 0.0, 1.0)}), new VHFace(new Vec3d[]{new Vec3d(0.0, 1.0, 0.0), new Vec3d(0.0, 1.0, 1.0), new Vec3d(1.0, 1.0, 1.0), new Vec3d(1.0, 1.0, 0.0)}), new VHFace(new Vec3d[]{new Vec3d(0.0, 0.0, 0.0), new Vec3d(0.0, 0.0, 1.0), new Vec3d(0.0, 1.0, 1.0), new Vec3d(0.0, 1.0, 0.0)}), new VHFace(new Vec3d[]{new Vec3d(1.0, 0.0, 0.0), new Vec3d(1.0, 1.0, 0.0), new Vec3d(1.0, 1.0, 1.0), new Vec3d(1.0, 0.0, 1.0)}), new VHFace(new Vec3d[]{new Vec3d(0.0, 0.0, 1.0), new Vec3d(1.0, 0.0, 1.0), new Vec3d(1.0, 1.0, 1.0), new Vec3d(0.0, 1.0, 1.0)}), new VHFace(new Vec3d[]{new Vec3d(0.0, 0.0, 0.0), new Vec3d(0.0, 1.0, 0.0), new Vec3d(1.0, 1.0, 0.0), new Vec3d(1.0, 0.0, 0.0)})};
    }

    public VehicleHitbox(VHFace[] faces, float thickness) {
        this(thickness);
        this.base_faces = faces;
        this.hitboxFaces = faces;
    }

    public Vec3d getBottomLeft() {
        return this.base_faces[0].points.get(1);
    }

    public Vec3d getBottomRight() {
        return this.base_faces[0].points.get(2);
    }

    public Vec3d getTopLeft() {
        return this.base_faces[1].points.get(3);
    }

    public Vec3d getTopRight() {
        return this.base_faces[1].points.get(2);
    }

    public Vec3d getFrontBottomLeft() {
        return this.base_faces[0].points.get(0);
    }

    public Vec3d getFrontBottomRight() {
        return this.base_faces[0].points.get(3);
    }

    public Vec3d getFrontTopLeft() {
        return this.base_faces[1].points.get(0);
    }

    public Vec3d getFrontTopRight() {
        return this.base_faces[1].points.get(1);
    }

    public void setBottomLeft(Vec3d point) {
        this.base_faces[0].points.set(1, point);
        this.base_faces[3].points.set(0, point);
        this.base_faces[5].points.set(3, point);
    }

    public void setBottomRight(Vec3d point) {
        this.base_faces[0].points.set(2, point);
        this.base_faces[3].points.set(3, point);
        this.base_faces[4].points.set(1, point);
    }

    public void setTopLeft(Vec3d point) {
        this.base_faces[1].points.set(3, point);
        this.base_faces[3].points.set(1, point);
        this.base_faces[5].points.set(2, point);
    }

    public void setTopRight(Vec3d point) {
        this.base_faces[1].points.set(2, point);
        this.base_faces[3].points.set(2, point);
        this.base_faces[4].points.set(2, point);
    }

    public void setFrontBottomLeft(Vec3d point) {
        this.base_faces[0].points.set(0, point);
        this.base_faces[2].points.set(0, point);
        this.base_faces[5].points.set(0, point);
    }

    public void setFrontBottomRight(Vec3d point) {
        this.base_faces[0].points.set(3, point);
        this.base_faces[2].points.set(1, point);
        this.base_faces[4].points.set(0, point);
    }

    public void setFrontTopLeft(Vec3d point) {
        this.base_faces[1].points.set(0, point);
        this.base_faces[2].points.set(3, point);
        this.base_faces[5].points.set(1, point);
    }

    public void setFrontTopRight(Vec3d point) {
        this.base_faces[1].points.set(1, point);
        this.base_faces[2].points.set(2, point);
        this.base_faces[4].points.set(3, point);
    }

    public void setHitboxBottomLeft(Vec3d point) {
        this.hitboxFaces[0].points.set(1, point);
        this.hitboxFaces[3].points.set(0, point);
        this.hitboxFaces[5].points.set(3, point);
    }

    public void setHitboxBottomRight(Vec3d point) {
        this.hitboxFaces[0].points.set(2, point);
        this.hitboxFaces[3].points.set(3, point);
        this.hitboxFaces[4].points.set(1, point);
    }

    public void setHitboxTopLeft(Vec3d point) {
        this.hitboxFaces[1].points.set(3, point);
        this.hitboxFaces[3].points.set(1, point);
        this.hitboxFaces[5].points.set(2, point);
    }

    public void setHitboxTopRight(Vec3d point) {
        this.hitboxFaces[1].points.set(2, point);
        this.hitboxFaces[3].points.set(2, point);
        this.hitboxFaces[4].points.set(2, point);
    }

    public void setHitboxFrontBottomLeft(Vec3d point) {
        this.hitboxFaces[0].points.set(0, point);
        this.hitboxFaces[2].points.set(0, point);
        this.hitboxFaces[5].points.set(0, point);
    }

    public void setHitboxFrontBottomRight(Vec3d point) {
        this.hitboxFaces[0].points.set(3, point);
        this.hitboxFaces[2].points.set(1, point);
        this.hitboxFaces[4].points.set(0, point);
    }

    public void setHitboxFrontTopLeft(Vec3d point) {
        this.hitboxFaces[1].points.set(0, point);
        this.hitboxFaces[2].points.set(3, point);
        this.hitboxFaces[5].points.set(1, point);
    }

    public void setHitboxFrontTopRight(Vec3d point) {
        this.hitboxFaces[1].points.set(1, point);
        this.hitboxFaces[2].points.set(2, point);
        this.hitboxFaces[4].points.set(3, point);
    }

    public boolean hitboxIntersects(VehicleHitbox hb, double x, double y, double z) {
        VHFace face1 = hb.hitboxFaces[0];
        VHFace face2 = hb.hitboxFaces[1];
        return this.pointIntersectsOffset(face1.points.get(0), x, y, z) || this.pointIntersectsOffset(face1.points.get(1), x, y, z) || this.pointIntersectsOffset(face1.points.get(2), x, y, z) || this.pointIntersectsOffset(face1.points.get(3), x, y, z) || this.pointIntersectsOffset(face2.points.get(0), x, y, z) || this.pointIntersectsOffset(face2.points.get(1), x, y, z) || this.pointIntersectsOffset(face2.points.get(2), x, y, z) || this.pointIntersectsOffset(face2.points.get(3), x, y, z);
    }

    public boolean pointIntersects(Vec3d point) {
        for (VHFace face : this.hitboxFaces) {
            double bound;
            Vec3d p2f = face.points.get(0).func_178788_d(point);
            double dot = p2f.func_72430_b(face.getNormal()) / p2f.func_72433_c();
            if (!(dot < (bound = -1.0E-15))) continue;
            return false;
        }
        return true;
    }

    public boolean rayCastIntersects(Vec3d point, Vec3d end) {
        Vector pnt = new Vector(point);
        Vector n = new Vector(end);
        Line line = new Line(pnt, n);
        for (VHFace face : this.hitboxFaces) {
            Plane plane = new Plane(new Vector[]{new Vector(face.points.get(0)), new Vector(face.points.get(1)), new Vector(face.points.get(2)), new Vector(face.points.get(3))});
            Vector inter = line.intersectionWithPlane(plane);
            if (inter == null || !plane.contains(inter)) continue;
            return true;
        }
        return false;
    }

    public Vec3d getIntersect(Vec3d point, Vec3d end) {
        Vector pnt = new Vector(point);
        Vector n = new Vector(end);
        Line line = new Line(pnt, n);
        Vector intersect = null;
        for (VHFace face : this.hitboxFaces) {
            Plane plane = new Plane(new Vector[]{new Vector(face.points.get(0)), new Vector(face.points.get(1)), new Vector(face.points.get(2)), new Vector(face.points.get(3))});
            Vector inter = line.intersectionWithPlane(plane);
            if (inter == null || !plane.contains(inter) || intersect != null && !(pnt.distanceTo(inter) < pnt.distanceTo(intersect))) continue;
            intersect = inter;
        }
        return intersect != null ? new Vec3d(intersect.x, intersect.y, intersect.z) : null;
    }

    public boolean pointIntersectsOffset(Vec3d point, double x, double y, double z) {
        for (VHFace face : this.hitboxFaces) {
            double bound;
            Vec3d point0 = face.points.get(0).func_72441_c(x, y, z);
            Vec3d p2f = point0.func_178788_d(point);
            double dot = p2f.func_72430_b(face.getNormalOffset(x, y, z)) / p2f.func_72433_c();
            if (!(dot < (bound = -1.0E-15))) continue;
            return false;
        }
        return true;
    }

    public void updateHitbox(EntityVehicle vehicle) {
        if (vehicle.driversSeat == null) {
            return;
        }
        this.setHitboxBottomLeft(this.getAdjustedVector(this.getBottomLeft(), vehicle));
        this.setHitboxBottomRight(this.getAdjustedVector(this.getBottomRight(), vehicle));
        this.setHitboxTopLeft(this.getAdjustedVector(this.getTopLeft(), vehicle));
        this.setHitboxTopRight(this.getAdjustedVector(this.getTopRight(), vehicle));
        this.setHitboxFrontBottomLeft(this.getAdjustedVector(this.getFrontBottomLeft(), vehicle));
        this.setHitboxFrontBottomRight(this.getAdjustedVector(this.getFrontBottomRight(), vehicle));
        this.setHitboxFrontTopLeft(this.getAdjustedVector(this.getFrontTopLeft(), vehicle));
        this.setHitboxFrontTopRight(this.getAdjustedVector(this.getFrontTopRight(), vehicle));
    }

    public void getAdjustedHitbox(EntityVehicle vehicle) {
        if (vehicle.driversSeat == null) {
            return;
        }
        this.setHitboxBottomLeft(this.getAdjustedVector(this.getBottomLeft(), vehicle));
        this.setHitboxBottomRight(this.getAdjustedVector(this.getBottomRight(), vehicle));
        this.setHitboxTopLeft(this.getAdjustedVector(this.getTopLeft(), vehicle));
        this.setHitboxTopRight(this.getAdjustedVector(this.getTopRight(), vehicle));
        this.setHitboxFrontBottomLeft(this.getAdjustedVector(this.getFrontBottomLeft(), vehicle));
        this.setHitboxFrontBottomRight(this.getAdjustedVector(this.getFrontBottomRight(), vehicle));
        this.setHitboxFrontTopLeft(this.getAdjustedVector(this.getFrontTopLeft(), vehicle));
        this.setHitboxFrontTopRight(this.getAdjustedVector(this.getFrontTopRight(), vehicle));
    }

    private Vec3d getAdjustedVector(Vec3d adjust, EntityVehicle vehicle) {
        float yaw = vehicle.driversSeat.pYaw;
        double xOff = adjust.field_72450_a;
        double yOff = adjust.field_72448_b;
        double zOff = adjust.field_72449_c;
        double posX = vehicle.field_70165_t + ((double)MathHelper.func_76134_b((float)(yaw / 180.0f * (float)Math.PI)) * xOff - (double)MathHelper.func_76126_a((float)(yaw / 180.0f * (float)Math.PI)) * zOff);
        double posY = vehicle.field_70163_u + yOff;
        double posZ = vehicle.field_70161_v + ((double)MathHelper.func_76126_a((float)((yaw + 90.0f) / 180.0f * (float)Math.PI)) * zOff - (double)MathHelper.func_76134_b((float)((yaw + 90.0f) / 180.0f * (float)Math.PI)) * xOff);
        return new Vec3d(posX, posY, posZ);
    }

    public Vec3d calculateIntercept(Vec3d posVec, Vec3d lookVec, float totalDist, Vec3d vehiclePos) {
        float dist = 0.0f;
        while (dist < totalDist) {
            Vec3d combinedVec;
            if ((combinedVec = posVec.func_72441_c(lookVec.field_72450_a * (double)(dist += 0.5f), lookVec.field_72448_b * (double)dist, lookVec.field_72449_c * (double)dist)).func_72438_d(vehiclePos) > 10.0 || !this.pointIntersects(combinedVec)) continue;
            return combinedVec;
        }
        return null;
    }

    class Vector {
        double x;
        double y;
        double z;

        Vector(Vec3d vec3) {
            this.x = vec3.field_72450_a;
            this.y = vec3.field_72448_b;
            this.z = vec3.field_72449_c;
        }

        Vector(double x, double y, double z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        double distanceTo(Vector v) {
            double d0 = v.x - this.x;
            double d1 = v.y - this.y;
            double d2 = v.z - this.z;
            return MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1 + d2 * d2));
        }

        Vector add(Vector v) {
            return new Vector(this.x + v.x, this.y + v.y, this.z + v.z);
        }

        Vector subtract(Vector v) {
            return new Vector(this.x - v.x, this.y - v.y, this.z - v.z);
        }

        double dotProduct(Vector v) {
            return this.x * v.x + this.y * v.y + this.z * v.z;
        }

        Vector crossProduct(Vector v) {
            return new Vector(this.y * v.z - this.z * v.y, this.z * v.x - this.x * v.z, this.x * v.y - this.y * v.x);
        }

        Vector normalize() {
            double magnitude = Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
            return new Vector(this.x / magnitude, this.y / magnitude, this.z / magnitude);
        }

        Vector scale(double scalar) {
            return new Vector(this.x * scalar, this.y * scalar, this.z * scalar);
        }
    }

    class Plane {
        Vector[] points;
        Vector normal;

        Plane(Vector[] points) {
            this.points = points;
            this.normal = points[1].subtract(points[0]).crossProduct(points[2].subtract(points[0])).normalize();
        }

        boolean contains(Vector point) {
            for (int i = 0; i < 4; ++i) {
                Vector toPoint;
                Vector edge = this.points[(i + 1) % 4].subtract(this.points[i]);
                if (!(this.normal.dotProduct(edge.crossProduct(toPoint = point.subtract(this.points[i]))) < 0.0)) continue;
                return false;
            }
            return true;
        }
    }

    class Line {
        Vector start;
        Vector direction;

        Line(Vector start, Vector direction) {
            this.start = start;
            this.direction = direction;
        }

        Vector intersectionWithPlane(Plane plane) {
            Vector direction = this.direction.subtract(this.start);
            double denominator = plane.normal.dotProduct(direction);
            if (denominator == 0.0) {
                return null;
            }
            double t = plane.normal.dotProduct(plane.points[0].subtract(this.start)) / denominator;
            if (t < 0.0 || t > 1.0) {
                return null;
            }
            return this.start.add(direction.scale(t));
        }
    }
}

