/*
 * Decompiled with CFR 0.152.
 */
package ctb_vehicles.common.items;

import ctb.CTB;
import ctb.CTBServerTicker;
import ctb.loading.SeatInfo;
import ctb_vehicles.common.CTBVItemRegistry;
import ctb_vehicles.common.entity.EntitySeat;
import ctb_vehicles.common.entity.EntityStandardVehicle;
import ctb_vehicles.common.entity.EntityVehicle;
import ctb_vehicles.common.entity.VehicleStats;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class ItemSpawnVehicle
extends Item {
    private SeatInfo[] seatInfo;
    private float maxThrottle;
    private float maxTurnRate;
    public String resourceName;
    public String textureName;
    public static ArrayList<ItemSpawnVehicle> vehicles = new ArrayList();

    public ItemSpawnVehicle(SeatInfo[] seatInfo, float maxThrottle, float maxTurnRate, String resourceName) {
        this(seatInfo, maxThrottle, maxTurnRate, resourceName, resourceName.contains(".") ? resourceName.split("[.]")[0] : resourceName);
    }

    public ItemSpawnVehicle(SeatInfo[] seatInfo, float maxThrottle, float maxTurnRate, String resourceName, String textureName) {
        this.func_77625_d(1);
        this.func_77637_a((CreativeTabs)CTB.tabvehicles);
        CTBVItemRegistry.itemList.add(this);
        this.seatInfo = seatInfo;
        this.maxThrottle = maxThrottle / 65.0f;
        this.maxTurnRate = maxTurnRate;
        this.resourceName = resourceName;
        this.textureName = textureName;
        vehicles.add(this);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand handIn) {
        int i;
        float f8;
        float f6;
        double d3;
        float f5;
        ItemStack itemstack = player.func_184586_b(handIn);
        float f = 1.0f;
        float f1 = player.field_70127_C + (player.field_70125_A - player.field_70127_C) * f;
        float f2 = player.field_70126_B + (player.field_70177_z - player.field_70126_B) * f;
        double d0 = player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)f;
        double d1 = player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)f + 1.62 - player.func_70033_W();
        double d2 = player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)f;
        Vec3d vec3 = new Vec3d(d0, d1, d2);
        float f3 = MathHelper.func_76134_b((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = MathHelper.func_76126_a((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f7 = f4 * (f5 = -MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180))));
        Vec3d vec31 = vec3.func_72441_c((double)f7 * (d3 = 5.0), (double)(f6 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180)))) * d3, (double)(f8 = f3 * f5) * d3);
        RayTraceResult movingobjectposition = world.func_72901_a(vec3, vec31, true);
        if (movingobjectposition == null) {
            return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
        }
        Vec3d vec32 = player.func_70676_i(f);
        boolean flag = false;
        float f9 = 1.0f;
        List list = world.func_72839_b((Entity)player, player.func_174813_aQ().func_72321_a(vec32.field_72450_a * d3, vec32.field_72448_b * d3, vec32.field_72449_c * d3).func_72314_b((double)f9, (double)f9, (double)f9));
        for (i = 0; i < list.size(); ++i) {
            Entity entity = (Entity)list.get(i);
            if (!entity.func_70067_L()) continue;
            float f10 = entity.func_70111_Y();
            AxisAlignedBB axisalignedbb = entity.func_174813_aQ().func_72321_a((double)f10, (double)f10, (double)f10);
            if (!axisalignedbb.func_72318_a(vec3)) continue;
            flag = true;
        }
        if (flag) {
            return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
        }
        if (movingobjectposition.field_72313_a == RayTraceResult.Type.BLOCK) {
            i = movingobjectposition.func_178782_a().func_177958_n();
            int j = movingobjectposition.func_178782_a().func_177956_o();
            int k = movingobjectposition.func_178782_a().func_177952_p();
            if (world.func_180495_p(movingobjectposition.func_178782_a()).func_177230_c() == Blocks.field_150431_aC) {
                --j;
            }
            EntityVehicle vehicle = this.getVehicleToSpawn(world, i, j, k);
            vehicle.field_70177_z = player.field_70177_z - 90.0f;
            if (!world.func_184144_a((Entity)vehicle, vehicle.func_174813_aQ().func_72321_a(-0.1, -0.1, -0.1)).isEmpty()) {
                return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
            }
            if (!world.field_72995_K) {
                world.func_72838_d((Entity)vehicle);
            }
            if (!player.field_71075_bZ.field_75098_d) {
                itemstack.func_190920_e(itemstack.func_190916_E() - 1);
            }
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
    }

    public EntityVehicle getVehicleToSpawn(World world, double posX, double posY, double posZ) {
        EntityStandardVehicle vehicle = new EntityStandardVehicle(world, posX + 0.5, posY + 1.0, posZ + 0.5);
        vehicle.maxThrottle = this.maxThrottle;
        vehicle.maxTurnRate = this.maxTurnRate;
        vehicle.resourceName = this.resourceName;
        vehicle.textureName = this.textureName;
        if (CTBServerTicker.gamemode != null) {
            vehicle.matchId = CTBServerTicker.gamemode.getMatchID();
        }
        vehicle.func_70107_b(vehicle.field_70165_t, vehicle.field_70163_u, vehicle.field_70161_v);
        VehicleStats.setStatsFor(vehicle);
        vehicle.maxThrottle /= 1.5f;
        return vehicle;
    }

    public SeatInfo[] getSeatInfo() {
        return this.seatInfo;
    }

    public void addSeatsTo(EntityVehicle vehicle) {
        for (int se = 0; se < this.seatInfo.length; ++se) {
            SeatInfo info = this.seatInfo[se];
            EntitySeat seat = new EntitySeat(vehicle.field_70170_p, vehicle, info.getxOffset(), info.getyOffset(), info.getzOffset(), se);
            seat.yawMin = info.getYawMin();
            seat.yawMax = info.getYawMax();
            if (info.isDriver()) {
                seat.setDriver();
            }
            if (info.isMGSeat()) {
                seat.setMG(info.getMGItem());
                seat.setAmmoType(info.getAmmoType());
            }
            vehicle.seats.add(seat);
        }
    }

    public String getTextureResourceName() {
        return this.textureName;
    }

    public String getResourceName() {
        String rname = this.resourceName;
        if (rname.contains(".")) {
            rname = rname.split("[.]")[0];
        }
        return rname;
    }
}

