/*
 * Decompiled with CFR 0.152.
 */
package ctb_vehicles.common.packet;

import ctb.ctbplayer.CTBPlayer;
import ctb_vehicles.CTBVehicles;
import ctb_vehicles.client.packet.PacketDriveClient;
import ctb_vehicles.common.entity.EntitySeat;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketDrive
implements IMessage {
    private int gasPressed;
    private int sidePressed;
    private int brakePressed;
    private float throttleSpeed;
    private float seatRotYaw;

    public PacketDrive() {
    }

    public PacketDrive(CTBPlayer ctb, float throttle, float sry) {
        this.gasPressed = ctb.gasPressed;
        this.sidePressed = ctb.sidePressed;
        this.brakePressed = ctb.brakePressed;
        this.throttleSpeed = throttle;
        this.seatRotYaw = sry;
    }

    public void fromBytes(ByteBuf buf) {
        this.gasPressed = buf.readInt();
        this.sidePressed = buf.readInt();
        this.brakePressed = buf.readInt();
        this.throttleSpeed = buf.readFloat();
        this.seatRotYaw = buf.readFloat();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.gasPressed);
        buf.writeInt(this.sidePressed);
        buf.writeInt(this.brakePressed);
        buf.writeFloat(this.throttleSpeed);
        buf.writeFloat(this.seatRotYaw);
    }

    public static class Handler
    implements IMessageHandler<PacketDrive, IMessage> {
        public IMessage onMessage(PacketDrive message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            if (player != null) {
                ctx.getServerHandler().field_147369_b.func_143004_u();
                player.func_184102_h().func_152344_a(() -> Handler.lambda$onMessage$0((EntityPlayer)player, message));
            }
            return null;
        }

        private static /* synthetic */ void lambda$onMessage$0(EntityPlayer player, PacketDrive message) {
            ((EntityPlayerMP)player).func_143004_u();
            CTBPlayer ctb = CTBPlayer.get((EntityPlayer)player);
            ctb.prevGasPressed = ctb.gasPressed;
            ctb.gasPressed = message.gasPressed;
            ctb.sidePressed = message.sidePressed;
            ctb.brakePressed = message.brakePressed;
            if (player.func_184187_bx() instanceof EntitySeat) {
                EntitySeat seat = (EntitySeat)player.func_184187_bx();
                boolean drivingVehicle = seat.isDriver;
                if (!drivingVehicle && seat.isScoped && seat.getParentVehicle() != null) {
                    boolean bl = drivingVehicle = seat.getParentVehicle().driver == null;
                }
                if (drivingVehicle) {
                    seat.getParentVehicle().throttleSpeed = message.throttleSpeed;
                    seat.field_70126_B = seat.field_70177_z = message.seatRotYaw;
                    seat.internalYaw = seat.field_70177_z;
                    CTBVehicles.ctbvChannel.sendToAll((IMessage)new PacketDriveClient(player, seat, message.throttleSpeed));
                }
            }
        }
    }
}

