package me.drex.instantfeedback;

import com.blackgear.vanillabackport.common.registries.ModBiomes;
import com.blackgear.vanillabackport.common.worldgen.placements.TheGardenAwakensPlacements;
import me.drex.instantfeedback.block.ModBlocks;
import me.drex.instantfeedback.entity.ModFrogVariants;
import me.drex.instantfeedback.entity.ModPigVariants;
import me.drex.instantfeedback.item.ModCauldronInteraction;
import me.drex.instantfeedback.item.ModItems;
import me.drex.instantfeedback.worldgen.FallenDarkOakTrunkPlacer;
import me.drex.instantfeedback.worldgen.ModVegetationPlacements;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.biome.v1.BiomeModifications;
import net.fabricmc.fabric.api.biome.v1.ModificationPhase;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.loot.v3.LootTableEvents;
import net.fabricmc.fabric.api.particle.v1.FabricParticleTypes;
import net.minecraft.class_1299;
import net.minecraft.class_141;
import net.minecraft.class_190;
import net.minecraft.class_2022;
import net.minecraft.class_2048;
import net.minecraft.class_2378;
import net.minecraft.class_2396;
import net.minecraft.class_2400;
import net.minecraft.class_2893;
import net.minecraft.class_2960;
import net.minecraft.class_44;
import net.minecraft.class_5142;
import net.minecraft.class_7378;
import net.minecraft.class_77;
import net.minecraft.class_7923;
import net.minecraft.class_9381;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Map;

public class InstantFeedback implements ModInitializer {

    public static final String MOD_ID = "instantfeedback";
    public static final Logger LOGGER = LoggerFactory.getLogger(MOD_ID);

    public static final class_2400 CREAKING_EYES = FabricParticleTypes.simple();
    public static final class_2396<class_9381> TINTED_NEEDLES = FabricParticleTypes.complex(class_9381::method_58254, class_9381::method_58261);
    public static final class_5142<FallenDarkOakTrunkPlacer> FALLEN_DARK_OAK_TRUNK_PLACER = class_2378.method_10230(class_7923.field_41151, class_2960.method_60655(MOD_ID, "fallen_dark_oak_trunk_placer"), new class_5142<>(FallenDarkOakTrunkPlacer.CODEC));


    @Override
    public void onInitialize() {
        class_2378.method_10230(class_7923.field_41180, class_2960.method_60655(MOD_ID, "creaking_eyes"), CREAKING_EYES);
        class_2378.method_10230(class_7923.field_41180, class_2960.method_60655(MOD_ID, "tinted_needles"), TINTED_NEEDLES);
        ModBlocks.initialize();
        ModFrogVariants.inititalize();
        ModItems.initialize();
        BiomeModifications.create(class_2960.method_60655(MOD_ID, "pale_garden_remove_spawn"))
            .add(ModificationPhase.REMOVALS, context -> context.getBiomeKey() == ModBiomes.PALE_GARDEN, context -> {
                context.getSpawnSettings().clearSpawns();
            });

        BiomeModifications.create(class_2960.method_60655(MOD_ID, "pale_garden_replace_vegetation"))
            .add(ModificationPhase.REPLACEMENTS, context -> context.getBiomeKey() == ModBiomes.PALE_GARDEN, context -> {
                context.getGenerationSettings().removeFeature(TheGardenAwakensPlacements.PALE_GARDEN_VEGETATION);
                context.getGenerationSettings().addFeature(class_2893.class_2895.field_13178, ModVegetationPlacements.PALE_GARDEN_VEGETATION);
            });

        BiomeModifications.addFeature(
            context -> context.getBiomeKey() == ModBiomes.PALE_GARDEN,
            class_2893.class_2895.field_13178,
            ModVegetationPlacements.PATCH_PALE_PUMPKIN
        );
        BiomeModifications.addFeature(
            context -> context.getBiomeKey() == ModBiomes.PALE_GARDEN,
            class_2893.class_2895.field_13178,
            ModVegetationPlacements.PILE_PALE_LEAVES
        );
        BiomeModifications.addFeature(
            context -> context.getBiomeKey() == ModBiomes.PALE_GARDEN,
            class_2893.class_2895.field_13178,
            ModVegetationPlacements.PALE_VEGETATION
        );
        LootTableEvents.MODIFY.register((key, tableBuilder, source, registries) -> {
            var magmaCube = class_1299.field_6102.method_16351();
            if (magmaCube.equals(key) && source.isBuiltin()) {
                tableBuilder.modifyPools(builder -> {
                    builder.method_351(
                            class_77.method_411(ModItems.CERULEAN_FROGLIGHT)
                                    .method_438(class_141.method_621(class_44.method_32448(1.0F)))
                                    .method_421(class_190.method_837(
                                            class_2022.class_2023.method_8855()
                                                    .method_35131(
                                                            class_2048.class_2049.method_8916()
                                                                    .method_8921(class_1299.field_37419)
                                                                    .method_43094(class_7378.method_58154(class_7923.field_41164.method_40264(ModFrogVariants.DARK).get()))
                                                    )
                                    ))
                    );
                });
            }
        });

        ModCauldronInteraction.bootstrap();

        ServerLifecycleEvents.SERVER_STARTING.register((minecraftServer -> {
            ModPigVariants.bootstrap(minecraftServer.method_30611());
        }));
    }

    public static class_2960 id(String path) {
        return class_2960.method_60655(MOD_ID, path);
    }
}