package me.drex.instantfeedback.block;

import com.mojang.serialization.MapCodec;
import me.drex.instantfeedback.duck.ISnowGolem;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1439;
import net.minecraft.class_1473;
import net.minecraft.class_174;
import net.minecraft.class_1750;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2276;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2694;
import net.minecraft.class_2697;
import net.minecraft.class_2700;
import net.minecraft.class_2715;
import net.minecraft.class_2754;
import net.minecraft.class_3222;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import org.jetbrains.annotations.Nullable;

import java.util.function.Predicate;

public class CarvedPalePumpkinBlock extends class_2383 {
    public static final MapCodec<class_2276> CODEC = method_54094(class_2276::new);
    public static final class_2754<class_2350> FACING = class_2383.field_11177;

    @Nullable
    private class_2700 snowGolemBase;
    @Nullable
    private class_2700 snowGolemFull;
    @Nullable
    private class_2700 ironGolemBase;
    @Nullable
    private class_2700 ironGolemFull;
    private static final Predicate<class_2680> PUMPKINS_PREDICATE = blockState -> blockState != null
        && (blockState.method_27852(ModBlocks.CARVED_PALE_PUMPKIN));

    public CarvedPalePumpkinBlock(class_4970.class_2251 properties) {
        super(properties);
        this.method_9590(this.field_10647.method_11664().method_11657(FACING, class_2350.field_11043));
    }

    @Override
    protected MapCodec<? extends class_2383> method_53969() {
        return field_46280;
    }

    @Override
    protected void method_9615(class_2680 blockState, class_1937 level, class_2338 blockPos, class_2680 blockState2, boolean bl) {
        if (!blockState2.method_27852(blockState.method_26204())) {
            this.trySpawnGolem(level, blockPos);
        }
    }

    // TODO DispenseItemBehavior
    public boolean canSpawnGolem(class_4538 levelReader, class_2338 blockPos) {
        return this.getOrCreateSnowGolemBase().method_11708(levelReader, blockPos) != null || this.getOrCreateIronGolemBase().method_11708(levelReader, blockPos) != null;
    }

    private void trySpawnGolem(class_1937 level, class_2338 blockPos) {
        class_2700.class_2702 blockPatternMatch = this.getOrCreateSnowGolemFull().method_11708(level, blockPos);
        if (blockPatternMatch != null) {
            class_1473 snowGolem = class_1299.field_6047.method_5883(level);
            if (snowGolem != null) {
                snowGolem.method_6642(false);
                ((ISnowGolem) snowGolem).instantfeedback$setPalePumpkin(true);
                spawnGolemInWorld(level, blockPatternMatch, snowGolem, blockPatternMatch.method_11717(0, 2, 0).method_11683());
            }
        } else {
            class_2700.class_2702 blockPatternMatch2 = this.getOrCreateIronGolemFull().method_11708(level, blockPos);
            if (blockPatternMatch2 != null) {
                class_1439 ironGolem = class_1299.field_6147.method_5883(level);
                if (ironGolem != null) {
                    ironGolem.method_6499(true);
                    spawnGolemInWorld(level, blockPatternMatch2, ironGolem, blockPatternMatch2.method_11717(1, 2, 0).method_11683());
                }
            }
        }
    }

    private static void spawnGolemInWorld(class_1937 level, class_2700.class_2702 blockPatternMatch, class_1297 entity, class_2338 blockPos) {
        class_2276.method_45454(level, blockPatternMatch);
        entity.method_5808(blockPos.method_10263() + 0.5, blockPos.method_10264() + 0.05, blockPos.method_10260() + 0.5, 0.0F, 0.0F);
        level.method_8649(entity);

        for (class_3222 serverPlayer : level.method_18467(class_3222.class, entity.method_5829().method_1014(5.0))) {
            class_174.field_1182.method_9124(serverPlayer, entity);
        }

        class_2276.method_45456(level, blockPatternMatch);
    }

    @Override
    public class_2680 method_9605(class_1750 blockPlaceContext) {
        return this.method_9564().method_11657(FACING, blockPlaceContext.method_8042().method_10153());
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(FACING);
    }

    private class_2700 getOrCreateSnowGolemBase() {
        if (this.snowGolemBase == null) {
            this.snowGolemBase = class_2697.method_11701()
                .method_11702(" ", "#", "#")
                .method_11700('#', class_2694.method_11678(class_2715.method_11758(class_2246.field_10491)))
                .method_11704();
        }

        return this.snowGolemBase;
    }

    private class_2700 getOrCreateSnowGolemFull() {
        if (this.snowGolemFull == null) {
            this.snowGolemFull = class_2697.method_11701()
                .method_11702("^", "#", "#")
                .method_11700('^', class_2694.method_11678(PUMPKINS_PREDICATE))
                .method_11700('#', class_2694.method_11678(class_2715.method_11758(class_2246.field_10491)))
                .method_11704();
        }

        return this.snowGolemFull;
    }

    private class_2700 getOrCreateIronGolemBase() {
        if (this.ironGolemBase == null) {
            this.ironGolemBase = class_2697.method_11701()
                .method_11702("~ ~", "###", "~#~")
                .method_11700('#', class_2694.method_11678(class_2715.method_11758(class_2246.field_10085)))
                .method_11700('~', blockInWorld -> blockInWorld.method_11681().method_26215())
                .method_11704();
        }

        return this.ironGolemBase;
    }

    private class_2700 getOrCreateIronGolemFull() {
        if (this.ironGolemFull == null) {
            this.ironGolemFull = class_2697.method_11701()
                .method_11702("~^~", "###", "~#~")
                .method_11700('^', class_2694.method_11678(PUMPKINS_PREDICATE))
                .method_11700('#', class_2694.method_11678(class_2715.method_11758(class_2246.field_10085)))
                .method_11700('~', blockInWorld -> blockInWorld.method_11681().method_26215())
                .method_11704();
        }

        return this.ironGolemFull;
    }
}
