package me.drex.instantfeedback.mixin.snow_golem;

import me.drex.instantfeedback.duck.ISnowGolem;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1427;
import net.minecraft.class_1473;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_1473.class)
public abstract class SnowGolemMixin extends class_1427 implements ISnowGolem {

    @Unique
    private static final class_2940<Byte> instantfeedback$DATA_PALE_PUMPKIN_ID = class_2945.method_12791(class_1473.class, class_2943.field_13319);
    @Unique
    private static final byte instantfeedback$PALE_PUMPKIN_FLAG = 32;

    protected SnowGolemMixin(class_1299<? extends class_1427> entityType, class_1937 level) {
        super(entityType, level);
    }

    @Inject(
        method = "defineSynchedData",
        at = @At("TAIL")
    )
    public void instantfeedback$defineSynchedData(class_2945.class_9222 builder, CallbackInfo ci) {
        builder.method_56912(instantfeedback$DATA_PALE_PUMPKIN_ID, (byte)0);
    }

    @Inject(
        method = "addAdditionalSaveData",
        at = @At("TAIL")
    )
    public void instantfeedback$addAdditionalSaveData(class_2487 tag, CallbackInfo ci) {
        tag.method_10556("PalePumpkin", this.instantfeedback$hasPalePumpkin());
    }

    @Inject(
        method = "readAdditionalSaveData",
        at = @At("TAIL")
    )
    public void instantfeedback$readAdditionalSaveData(class_2487 tag, CallbackInfo ci) {
        if (tag.method_10545("Pumpkin")) {
            this.instantfeedback$setPalePumpkin(tag.method_10577("PalePumpkin"));
        }
    }

    @ModifyVariable(
            method = "performRangedAttack",
            at = @At(
                    value = "INVOKE_ASSIGN",
                    target = "Lnet/minecraft/world/level/Level;addFreshEntity(Lnet/minecraft/world/entity/Entity;)Z"
            ), index = 1
    )
    public class_1309 instantfeedback$specialEffects(class_1309 value) {
        if (instantfeedback$hasPalePumpkin()) {
            value.method_20803(100);
        }
        return value;
    }

    @Override
    public void instantfeedback$setPalePumpkin(boolean palePumpkin) {
        byte b = this.field_6011.method_12789(instantfeedback$DATA_PALE_PUMPKIN_ID);
        if (palePumpkin) {
            this.field_6011.method_12778(instantfeedback$DATA_PALE_PUMPKIN_ID, (byte)(b | instantfeedback$PALE_PUMPKIN_FLAG));
        } else {
            this.field_6011.method_12778(instantfeedback$DATA_PALE_PUMPKIN_ID, (byte)(b & ~instantfeedback$PALE_PUMPKIN_FLAG));
        }
    }

    @Override
    public boolean instantfeedback$hasPalePumpkin() {
        return (this.field_6011.method_12789(instantfeedback$DATA_PALE_PUMPKIN_ID) & instantfeedback$PALE_PUMPKIN_FLAG) != 0;
    }
}
