package me.drex.instantfeedback.worldgen;

import com.google.common.collect.Lists;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import me.drex.instantfeedback.InstantFeedback;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2465;
import net.minecraft.class_2680;
import net.minecraft.class_2944;
import net.minecraft.class_3746;
import net.minecraft.class_4643;
import net.minecraft.class_4647;
import net.minecraft.class_5141;
import net.minecraft.class_5142;
import net.minecraft.class_5819;
import java.util.List;
import java.util.function.BiConsumer;

public class FallenDarkOakTrunkPlacer extends class_5141 {
    public static final MapCodec<FallenDarkOakTrunkPlacer> CODEC = RecordCodecBuilder.mapCodec(
        instance -> method_28904(instance).apply(instance, FallenDarkOakTrunkPlacer::new)
    );
    public FallenDarkOakTrunkPlacer(int baseHeight, int heightRandA, int heightRandB) {
        super(baseHeight, heightRandA, heightRandB);
    }

    @Override
    protected class_5142<?> method_28903() {
        return InstantFeedback.FALLEN_DARK_OAK_TRUNK_PLACER;
    }

    @Override
    public List<class_4647.class_5208> method_26991(
        class_3746 levelSimulatedReader,
        BiConsumer<class_2338, class_2680> biConsumer,
        class_5819 randomSource,
        int maxHeight,
        class_2338 origin,
        class_4643 treeConfiguration
    ) {
        List<class_4647.class_5208> list = Lists.newArrayList();
        class_2350 fallDirection = class_2350.values()[randomSource.method_43048(4) + 2];

        class_2338 below = origin.method_10074();

//        setDirtAt(levelSimulatedReader, biConsumer, randomSource, below, treeConfiguration);
//        setDirtAt(levelSimulatedReader, biConsumer, randomSource, below.east(), treeConfiguration);
//        setDirtAt(levelSimulatedReader, biConsumer, randomSource, below.south(), treeConfiguration);
//        setDirtAt(levelSimulatedReader, biConsumer, randomSource, below.south().east(), treeConfiguration);

        BiConsumer<class_2338, class_2680> transformedBiConsumer = (pos, state) -> {
            biConsumer.accept(pos, state.method_11657(class_2465.field_11459, fallDirection.method_10166()));
        };

        class_2350 direction = class_2350.class_2353.field_11062.method_10183(randomSource);
        int height = maxHeight - randomSource.method_43048(4);
        int k = 2 - randomSource.method_43048(3);
        int originX = origin.method_10263();
        int originY = origin.method_10264();
        int originZ = origin.method_10260();
        int x = originX;
        int z = originZ;
        int topY = originY + maxHeight - 1;

        for (int dy = 0; dy < maxHeight; dy++) {
            if (dy >= height && k > 0) {
                x += direction.method_10148();
                z += direction.method_10165();
                k--;
            }

            int y = originY + dy;
            class_2338 pos = new class_2338(x, y, z);
            if (class_2944.method_16420(levelSimulatedReader, transform(pos, fallDirection, origin))) {
                this.method_35375(levelSimulatedReader, transformedBiConsumer, randomSource, transform(pos, fallDirection, origin), treeConfiguration);
                this.method_35375(levelSimulatedReader, transformedBiConsumer, randomSource, transform(pos.method_10078(), fallDirection, origin), treeConfiguration);
                this.method_35375(levelSimulatedReader, transformedBiConsumer, randomSource, transform(pos.method_10072(), fallDirection, origin), treeConfiguration);
                this.method_35375(levelSimulatedReader, transformedBiConsumer, randomSource, transform(pos.method_10078().method_10072(), fallDirection, origin), treeConfiguration);
            }
        }

        list.add(new class_4647.class_5208(transformed(x, topY, z, fallDirection, origin), 0, true));

        for (int dx = -1; dx <= 2; dx++) {
            for (int dz = -1; dz <= 2; dz++) {
                if ((dx < 0 || dx > 1 || dz < 0 || dz > 1) && randomSource.method_43048(3) <= 0) {
                    int t = randomSource.method_43048(3) + 2;

                    for (int u = 0; u < t; u++) {
                        this.method_35375(levelSimulatedReader, transformedBiConsumer, randomSource, transformed(originX + dx, topY - u - 1, originZ + dz, fallDirection, origin), treeConfiguration);
                    }

                    list.add(new class_4647.class_5208(transformed(x + dx, topY, z + dz, fallDirection, origin), 0, false));
                }
            }
        }

        return list;
    }

    public static class_2338 transformed(int x, int y, int z, class_2350 direction, class_2338 origin) {
        return transform(new class_2338(x, y, z), direction, origin);
    }

    public static class_2338 transform(class_2338 blockPos, class_2350 direction, class_2338 origin) {
        int x = blockPos.method_10263();
        int y = blockPos.method_10264();
        int z = blockPos.method_10260();

        int originX = origin.method_10263();
        int originY = origin.method_10264();
        int originZ = origin.method_10260();
        return switch (direction) {
            case field_11043 -> new class_2338(x, originY + z - originZ, originZ - y + originY);
            case field_11035 -> new class_2338(x, originY - z + originZ + 1, originZ + y - originY);
            case field_11034 -> new class_2338(originX + y - originY, originY + x - originX, z);
            case field_11039 -> new class_2338(originX - y + originY, originY + originX - x + 1, z);
            default -> throw new IllegalStateException();
        };
    }


}
