package me.drex.instantfeedback.worldgen;

import com.blackgear.vanillabackport.common.worldgen.placements.TheGardenAwakensPlacements;
import com.blackgear.vanillabackport.common.worldgen.treedecorators.CreakingHeartDecorator;
import com.blackgear.vanillabackport.common.worldgen.treedecorators.PaleMossDecorator;
import com.google.common.collect.ImmutableList;
import me.drex.instantfeedback.InstantFeedback;
import me.drex.instantfeedback.block.CarvedPalePumpkinBlock;
import me.drex.instantfeedback.block.ModBlocks;
import net.minecraft.class_2246;
import net.minecraft.class_2350;
import net.minecraft.class_2397;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_2975;
import net.minecraft.class_3031;
import net.minecraft.class_3141;
import net.minecraft.class_3175;
import net.minecraft.class_3226;
import net.minecraft.class_4638;
import net.minecraft.class_4643;
import net.minecraft.class_4651;
import net.minecraft.class_4657;
import net.minecraft.class_5203;
import net.minecraft.class_5206;
import net.minecraft.class_5321;
import net.minecraft.class_6005;
import net.minecraft.class_6016;
import net.minecraft.class_6646;
import net.minecraft.class_6796;
import net.minecraft.class_6803;
import net.minecraft.class_6817;
import net.minecraft.class_6880;
import net.minecraft.class_7871;
import net.minecraft.class_7891;
import net.minecraft.class_7924;
import java.util.List;
import java.util.OptionalInt;

import static com.blackgear.vanillabackport.common.registries.ModBlocks.*;

public class ModVegetationFeatures {

    public static final class_5321<class_2975<?, ?>> PATCH_PALE_PUMPKIN = class_5321.method_29179(class_7924.field_41239, class_2960.method_60655(InstantFeedback.MOD_ID, "patch_pale_pumpkin"));
    public static final class_5321<class_2975<?, ?>> PILE_PALE_LEAVES = class_5321.method_29179(class_7924.field_41239, class_2960.method_60655(InstantFeedback.MOD_ID, "pile_pale_leaves"));
    public static final class_5321<class_2975<?, ?>> PALE_VEGETATION = class_5321.method_29179(class_7924.field_41239, class_2960.method_60655(InstantFeedback.MOD_ID, "pale_vegetation"));
    public static final class_5321<class_2975<?, ?>> FALLEN_PALE_OAK_CREAKING = class_5321.method_29179(class_7924.field_41239, class_2960.method_60655(InstantFeedback.MOD_ID, "fallen_pale_oak_creaking"));
    public static final class_5321<class_2975<?, ?>> PALE_GARDEN_VEGETATION = class_5321.method_29179(class_7924.field_41239, class_2960.method_60655(InstantFeedback.MOD_ID, "pale_garden_vegetation"));

    public static void bootstrap(class_7891<class_2975<?, ?>> bootstrapContext) {
        class_7871<class_6796> placedFeatures = bootstrapContext.method_46799(class_7924.field_41245);
        class_6880<class_6796> paleOakChecked = placedFeatures.method_46747(TheGardenAwakensPlacements.PALE_OAK_CHECKED);
        class_6880<class_6796> paleOakCreakingChecked = placedFeatures.method_46747(TheGardenAwakensPlacements.PALE_OAK_CREAKING_CHECKED);
        class_6880<class_6796> fallenPaleOakCreakingChecked = placedFeatures.method_46747(ModVegetationPlacements.FALLEN_PALE_OAK_CREAKING);

        class_6803.method_39708(
            bootstrapContext,
            ModVegetationFeatures.PATCH_PALE_PUMPKIN,
            class_3031.field_21220,
            class_6803.method_39706(
                class_3031.field_13518, new class_3175(new class_4657(
                    class_6005.<class_2680>method_34971()
                        .method_34975(ModBlocks.PALE_PUMPKIN.method_9564(), 20)
                        .method_34975(ModBlocks.CARVED_PALE_PUMPKIN.method_9564().method_11657(CarvedPalePumpkinBlock.FACING, class_2350.field_11043), 1)
                        .method_34975(ModBlocks.CARVED_PALE_PUMPKIN.method_9564().method_11657(CarvedPalePumpkinBlock.FACING, class_2350.field_11034), 1)
                        .method_34975(ModBlocks.CARVED_PALE_PUMPKIN.method_9564().method_11657(CarvedPalePumpkinBlock.FACING, class_2350.field_11035), 1)
                        .method_34975(ModBlocks.CARVED_PALE_PUMPKIN.method_9564().method_11657(CarvedPalePumpkinBlock.FACING, class_2350.field_11039), 1)
                )), List.of(class_2246.field_10219),
                24
            )
        );

        class_6803.method_39708(
            bootstrapContext, PILE_PALE_LEAVES, class_3031.field_21220, class_6803.method_39705(
                class_3031.field_13518,
                new class_3175(class_4651.method_38433(PALE_OAK_LEAVES.get().method_9564().method_11657(class_2397.field_11200, true))),
                List.of(class_2246.field_10219, PALE_OAK_LEAVES.get())
            )
        );

        class_6803.method_39708(
            bootstrapContext,
            PALE_VEGETATION,
            class_3031.field_21220,
            new class_4638(164, 16, 8, class_6817.method_40367(
                class_3031.field_13518,
                new class_3175(new class_4657(
                        class_6005.<class_2680>method_34971()
                        .method_34975(ModBlocks.PALE_ROSE.method_9564(), 1)
                        .method_34975(ModBlocks.PALE_BUSH.method_9564(), 5)
                        .method_34975(ModBlocks.TALL_PALE_BUSH.method_9564(), 5)
                        .method_34975(PALE_MOSS_CARPET.get().method_9564(), 10)
                )),
                class_6646.method_38878(class_6646.field_35696, class_6646.method_38881(class_2350.field_11033.method_10163(), List.of(class_2246.field_10219)))
            )
            )
        );

        class_6803.method_39708(
            bootstrapContext,
            FALLEN_PALE_OAK_CREAKING,
            class_3031.field_24134,
            new class_4643.class_4644(
                class_4651.method_38432(PALE_OAK_LOG.get()),
                new FallenDarkOakTrunkPlacer(6, 2, 1),
                class_4651.method_38432(PALE_OAK_LEAVES.get()),
                new class_5206(class_6016.method_34998(0), class_6016.method_34998(0)),
                new class_5203(1, 1, 0, 1, 2, OptionalInt.empty())
            )
                .method_27376(ImmutableList.of(new PaleMossDecorator(0.25F, 0.8F, 0.8F), new CreakingHeartDecorator(1.0F)))
                .method_27374()
                .method_23445()
        );

        class_6803.method_39708(
            bootstrapContext,
            PALE_GARDEN_VEGETATION,
            class_3031.field_13593,
            new class_3141(List.of(new class_3226(paleOakCreakingChecked, 0.2F), new class_3226(paleOakChecked, 0.8F), new class_3226(fallenPaleOakCreakingChecked, 0.8F)), paleOakChecked)
        );

    }

}
