/*
 * Decompiled with CFR 0.152.
 */
package someassemblyrequired.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntry;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryType;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.ModLoadedCondition;
import someassemblyrequired.registry.ModLootPoolEntries;

public class OptionalLootItem
extends LootPoolSingletonContainer {
    private final ResourceLocation item;
    private final List<ICondition> loadingConditions;
    public static final MapCodec<OptionalLootItem> CODEC = RecordCodecBuilder.mapCodec(instance -> OptionalLootItem.singletonFields((RecordCodecBuilder.Instance)instance).and((App)ResourceLocation.CODEC.fieldOf("item").forGetter(OptionalLootItem::item)).and((App)ICondition.LIST_CODEC.fieldOf("loading_conditions").forGetter(OptionalLootItem::loadingConditions)).apply((Applicative)instance, OptionalLootItem::new));

    public OptionalLootItem(int weight, int quality, List<LootItemCondition> conditions, List<LootItemFunction> functions, ResourceLocation item, List<ICondition> loadingConditions) {
        super(weight, quality, conditions, functions);
        this.item = item;
        this.loadingConditions = loadingConditions;
    }

    private ResourceLocation item() {
        return this.item;
    }

    private List<ICondition> loadingConditions() {
        return this.loadingConditions;
    }

    public LootPoolEntryType getType() {
        return (LootPoolEntryType)ModLootPoolEntries.OPTIONAL_ITEM.get();
    }

    public boolean expand(LootContext context, Consumer<LootPoolEntry> entries) {
        if (!this.canRun(context) || !OptionalLootItem.testConditions(this.loadingConditions)) {
            return false;
        }
        entries.accept((LootPoolEntry)new LootPoolSingletonContainer.EntryBase(){

            public void createItemStack(Consumer<ItemStack> items, LootContext context1) {
                items.accept(new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(OptionalLootItem.this.item)));
            }
        });
        return true;
    }

    public static boolean testConditions(List<ICondition> conditions) {
        for (ICondition condition : conditions) {
            if (condition.test(ICondition.IContext.EMPTY)) continue;
            return false;
        }
        return true;
    }

    public void createItemStack(Consumer<ItemStack> pStackConsumer, LootContext pLootContext) {
        pStackConsumer.accept(new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(this.item)));
    }

    public static LootPoolSingletonContainer.Builder<?> whenLoaded(Item item) {
        return OptionalLootItem.whenLoaded(BuiltInRegistries.ITEM.getKey((Object)item));
    }

    public static LootPoolSingletonContainer.Builder<?> whenLoaded(ResourceLocation item) {
        return OptionalLootItem.optionalLootItem(item, new ICondition[]{new ModLoadedCondition(item.getNamespace())});
    }

    public static LootPoolSingletonContainer.Builder<?> optionalLootItem(ResourceLocation item, ICondition ... loadingConditions) {
        return OptionalLootItem.simpleBuilder((weight, quality, conditions, functions) -> new OptionalLootItem(weight, quality, conditions, functions, item, Arrays.asList(loadingConditions)));
    }
}

