/*
 * Decompiled with CFR 0.152.
 */
package someassemblyrequired.registry;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.neoforged.neoforge.event.OnDatapackSyncEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.Nullable;
import someassemblyrequired.SomeAssemblyRequired;
import someassemblyrequired.ingredient.IngredientProperties;
import someassemblyrequired.ingredient.IngredientPropertiesBase;
import someassemblyrequired.ingredient.PotionProperties;
import someassemblyrequired.network.UpdateIngredientsPacket;
import someassemblyrequired.registry.ModSoundEvents;

public class ModIngredients {
    public static final ResourceKey<Registry<IngredientProperties>> INGREDIENTS = ResourceKey.createRegistryKey((ResourceLocation)SomeAssemblyRequired.id("ingredients"));
    private static final IngredientPropertiesBase DEFAULT_PROPERTIES = new IngredientProperties(null, Optional.empty(), Optional.empty(), Optional.empty(), ItemStack.EMPTY, (Holder<SoundEvent>)ModSoundEvents.ADD_ITEM, 1, true, false);
    private static final Map<Item, IngredientPropertiesBase> PROPERTIES = new HashMap<Item, IngredientPropertiesBase>();

    public static void onDataPackSync(OnDatapackSyncEvent event) {
        if (event.getPlayer() == null && ServerLifecycleHooks.getCurrentServer() != null) {
            ServerLifecycleHooks.getCurrentServer().registryAccess().registry(INGREDIENTS).map(Registry::asLookup).ifPresent(ModIngredients::refresh);
        }
        event.getRelevantPlayers().forEach(player -> PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)UpdateIngredientsPacket.INSTANCE, (CustomPacketPayload[])new CustomPacketPayload[0]));
    }

    public static void refresh(HolderLookup.RegistryLookup<IngredientProperties> registry) {
        PROPERTIES.clear();
        registry.listElements().forEachOrdered(ingredient -> {
            Item item = (Item)((IngredientProperties)ingredient.value()).item().value();
            if (PROPERTIES.containsKey(item)) {
                SomeAssemblyRequired.LOGGER.error("Multiple ingredients found for item {}", (Object)BuiltInRegistries.ITEM.getKey((Object)item));
            }
            PROPERTIES.put(item, (IngredientPropertiesBase)ingredient.value());
        });
        PROPERTIES.put(Items.POTION, new PotionProperties());
    }

    @Nullable
    public static IngredientPropertiesBase get(ItemStack item) {
        return PROPERTIES.get(item.getItem());
    }

    public static IngredientPropertiesBase getOrDefault(ItemStack item) {
        if (ModIngredients.get(item) != null) {
            return ModIngredients.get(item);
        }
        return DEFAULT_PROPERTIES;
    }
}

