/*
 * Decompiled with CFR 0.152.
 */
package someassemblyrequired.data.providers;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetStewEffectFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.common.data.GlobalLootModifierProvider;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootTableIdCondition;
import someassemblyrequired.SomeAssemblyRequired;
import someassemblyrequired.data.providers.LootTables;
import someassemblyrequired.loot.RollLootTableModifier;
import someassemblyrequired.loot.SandwichLootEnabledCondition;
import someassemblyrequired.registry.ModItems;

public class LootModifiers
extends GlobalLootModifierProvider {
    protected final List<Builder> lootBuilders = new ArrayList<Builder>();

    public LootModifiers(PackOutput packOutput) {
        super(packOutput, "some_assembly_required");
    }

    private void addLoot() {
        this.addSandwich(BuiltInLootTables.f_78691_, Potions.f_43599_);
        this.addSandwich(BuiltInLootTables.f_78692_, Potions.f_43621_);
        this.addSandwich(BuiltInLootTables.f_78741_, Items.f_42730_);
        this.addSandwich(BuiltInLootTables.f_78759_, Potions.f_43603_);
        this.addSandwich(BuiltInLootTables.f_78742_, (Item)ModItems.GOLDEN_APPLE_SLICES.get());
        this.addSandwich(BuiltInLootTables.f_78760_, Potions.f_43610_);
        this.addSandwich(BuiltInLootTables.f_230876_, Potions.f_43587_);
        this.builder(BuiltInLootTables.f_78694_, 0.05).getLootPool().m_79076_(LootTables.sandwich(LootTables.item(Items.f_42718_).m_79078_((LootItemFunction.Builder)SetStewEffectFunction.m_81228_().m_165472_(MobEffects.f_19611_, (NumberProvider)UniformGenerator.m_165780_((float)7.0f, (float)10.0f)).m_165472_(MobEffects.f_19603_, (NumberProvider)UniformGenerator.m_165780_((float)7.0f, (float)10.0f)).m_165472_(MobEffects.f_19613_, (NumberProvider)UniformGenerator.m_165780_((float)6.0f, (float)8.0f)).m_165472_(MobEffects.f_19610_, (NumberProvider)UniformGenerator.m_165780_((float)5.0f, (float)7.0f)).m_165472_(MobEffects.f_19614_, (NumberProvider)UniformGenerator.m_165780_((float)10.0f, (float)20.0f)).m_165472_(MobEffects.f_19618_, (NumberProvider)UniformGenerator.m_165780_((float)7.0f, (float)10.0f)))));
        this.builder(BuiltInLootTables.f_78740_, 1.0).getLootPool().m_79076_((LootPoolEntryContainer.Builder)LootTables.sandwich(Items.f_42787_).m_79078_(LootTables.count(3, 8)));
    }

    private void addSandwich(ResourceLocation lootTable, Item item) {
        this.builder(lootTable, 0.05).getLootPool().m_79076_(LootTables.sandwich(item));
    }

    private void addSandwich(ResourceLocation lootTable, Potion potion) {
        this.builder(lootTable, 0.05).getLootPool().m_79076_(LootTables.sandwich(potion));
    }

    protected Builder builder(ResourceLocation lootTable, double chance) {
        Builder builder = new Builder(lootTable.m_135815_());
        builder.lootModifierCondition(LootTableIdCondition.builder((ResourceLocation)lootTable).m_6409_());
        builder.lootModifierCondition(SandwichLootEnabledCondition.sandwichLootEnabled());
        if (chance != 1.0) {
            builder.lootPoolCondition(LootItemRandomChanceCondition.m_81927_((float)((float)chance)));
        }
        this.lootBuilders.add(builder);
        return builder;
    }

    protected void start() {
        this.addLoot();
        for (Builder lootBuilder : this.lootBuilders) {
            this.add(lootBuilder.getName(), (IGlobalLootModifier)lootBuilder.build());
        }
        for (ResourceLocation lootTable : List.of(BuiltInLootTables.f_78754_, BuiltInLootTables.f_78758_, BuiltInLootTables.f_78755_, BuiltInLootTables.f_78756_, BuiltInLootTables.f_78757_)) {
            ArrayList<LootItemCondition> conditions = new ArrayList<LootItemCondition>();
            conditions.add(SandwichLootEnabledCondition.sandwichLootEnabled());
            conditions.add(LootTableIdCondition.builder((ResourceLocation)lootTable).m_6409_());
            this.add("inject/" + lootTable.m_135815_(), (IGlobalLootModifier)new RollLootTableModifier(conditions.toArray(new LootItemCondition[0]), LootTables.VILLAGE_SANDWICH));
        }
    }

    protected static class Builder {
        private final String lootTableName;
        private final LootPool.Builder lootPool = LootPool.m_79043_();
        private final List<LootItemCondition> conditions;
        private LootContextParamSet paramSet = LootContextParamSets.f_81411_;

        private Builder(String lootTableName) {
            this.lootTableName = "inject/" + lootTableName;
            this.conditions = new ArrayList<LootItemCondition>();
        }

        private RollLootTableModifier build() {
            return new RollLootTableModifier(this.conditions.toArray(new LootItemCondition[0]), SomeAssemblyRequired.id(this.getName()));
        }

        protected LootTable.Builder createLootTable() {
            return new LootTable.Builder().m_79161_(this.lootPool);
        }

        public LootContextParamSet getParameterSet() {
            return this.paramSet;
        }

        public LootPool.Builder getLootPool() {
            return this.lootPool;
        }

        protected String getName() {
            return this.lootTableName;
        }

        private Builder parameterSet(LootContextParamSet paramSet) {
            this.paramSet = paramSet;
            return this;
        }

        private Builder lootPoolCondition(LootItemCondition.Builder condition) {
            this.lootPool.m_79080_(condition);
            return this;
        }

        private Builder lootModifierCondition(LootItemCondition condition) {
            this.conditions.add(condition);
            return this;
        }
    }
}

