/*
 * Decompiled with CFR 0.152.
 */
package someassemblyrequired.integration.jei;

import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import someassemblyrequired.SomeAssemblyRequired;
import someassemblyrequired.integration.jei.JEIPlugin;
import someassemblyrequired.registry.ModBlocks;

public class SandwichingStationCategory
implements IRecipeCategory<Recipe> {
    private final IDrawable icon;
    private final IDrawable slot;
    private final IDrawable arrow;

    public SandwichingStationCategory(IGuiHelper helper) {
        ResourceLocation texture = SomeAssemblyRequired.id("textures/jei/sandwiching_station.png");
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModBlocks.SANDWICHING_STATION.get()));
        this.slot = helper.createDrawable(texture, 0, 0, 18, 18);
        this.arrow = helper.createDrawable(texture, 18, 0, 44, 18);
    }

    public RecipeType<Recipe> getRecipeType() {
        return JEIPlugin.SANDWICHING_STATION;
    }

    public Component getTitle() {
        return ((Block)ModBlocks.SANDWICHING_STATION.get()).m_49954_();
    }

    public int getHeight() {
        return 120;
    }

    public int getWidth() {
        return 100;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, Recipe recipe, IFocusGroup focuses) {
        int slotSize = 18;
        int slots = recipe.toppings.size() + 1;
        int totalSlotSize = slotSize + (slots - 1) * (1 + slotSize);
        int inputY = this.getHeight() / 2 - totalSlotSize / 2;
        int spacingX = 6;
        int outputX = this.getWidth() - spacingX - slotSize;
        int outputY = this.getHeight() / 2 - slotSize / 2;
        builder.addSlot(RecipeIngredientRole.OUTPUT, outputX, outputY).setBackground(this.slot, -1, -1).addItemStack(recipe.result);
        for (int slot = 0; slot < slots - 1; ++slot) {
            builder.addSlot(RecipeIngredientRole.INPUT, spacingX, inputY).setBackground(this.slot, -1, -1).addItemStack(recipe.toppings.get(recipe.toppings.size() - slot - 1));
            inputY += slotSize + 1;
        }
        builder.addSlot(RecipeIngredientRole.INPUT, spacingX, inputY).setBackground(this.slot, -1, -1).addItemStack(recipe.prefix);
    }

    public void draw(Recipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.arrow.draw(guiGraphics, this.getWidth() / 2 - this.arrow.getWidth() / 2, this.getHeight() / 2 - this.arrow.getHeight() / 2);
    }

    public record Recipe(ItemStack prefix, List<ItemStack> toppings, ItemStack result) {
    }
}

