/*
 * Decompiled with CFR 0.152.
 */
package someassemblyrequired.item.sandwich;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import someassemblyrequired.SomeAssemblyRequired;
import someassemblyrequired.block.SandwichBlock;
import someassemblyrequired.ingredient.Ingredients;
import someassemblyrequired.item.sandwich.SandwichItemHandler;
import someassemblyrequired.item.sandwich.SandwichItemRenderer;
import someassemblyrequired.item.sandwich.SandwichNameHelper;
import someassemblyrequired.registry.ModAdvancementTriggers;
import someassemblyrequired.registry.ModFoods;
import someassemblyrequired.registry.ModItems;
import someassemblyrequired.registry.ModStatistics;
import someassemblyrequired.registry.ModTags;

public class SandwichItem
extends BlockItem {
    public SandwichItem(Block block, Item.Properties builder) {
        super(block, builder);
    }

    public static ItemStack makeSandwich(Potion potion) {
        ItemStack item = new ItemStack((ItemLike)Items.f_42589_);
        PotionUtils.m_43549_((ItemStack)item, (Potion)potion);
        return SandwichItem.makeSandwich(item);
    }

    public static ItemStack makeSandwich(ItemLike ... items) {
        return SandwichItem.makeSandwich((ItemStack[])Arrays.stream(items).map(ItemStack::new).toArray(ItemStack[]::new));
    }

    public static ItemStack makeSandwich(ItemStack ... items) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        list.add(new ItemStack((ItemLike)ModItems.BREAD_SLICE.get()));
        list.addAll(Arrays.asList(items));
        list.add(new ItemStack((ItemLike)ModItems.BREAD_SLICE.get()));
        return SandwichItem.of(list);
    }

    public static ItemStack makeToastSandwich(ItemLike ... items) {
        return SandwichItem.makeToastSandwich((ItemStack[])Arrays.stream(items).map(ItemStack::new).toArray(ItemStack[]::new));
    }

    public static ItemStack makeToastSandwich(ItemStack ... items) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        list.add(new ItemStack((ItemLike)ModItems.TOASTED_BREAD_SLICE.get()));
        list.addAll(Arrays.asList(items));
        list.add(new ItemStack((ItemLike)ModItems.TOASTED_BREAD_SLICE.get()));
        return SandwichItem.of(list);
    }

    public static ItemStack makeBurger(ItemLike ... items) {
        return SandwichItem.makeBurger((ItemStack[])Arrays.stream(items).map(ItemStack::new).toArray(ItemStack[]::new));
    }

    public static ItemStack makeBurger(ItemStack ... items) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        list.add(new ItemStack((ItemLike)ModItems.BURGER_BUN_BOTTOM.get()));
        list.addAll(Arrays.asList(items));
        list.add(new ItemStack((ItemLike)ModItems.BURGER_BUN_TOP.get()));
        return SandwichItem.of(list);
    }

    public static ItemStack of(ItemStack ... items) {
        return SandwichItem.of(Arrays.asList(items));
    }

    public static ItemStack of(List<ItemStack> items) {
        ArrayList<ItemStack> flattenedItems = new ArrayList<ItemStack>();
        for (ItemStack item : items) {
            if (item.m_41613_() != 1) {
                throw new IllegalArgumentException();
            }
            if (!item.m_150930_((Item)ModItems.SANDWICH.get())) {
                flattenedItems.add(item);
                continue;
            }
            SandwichItemHandler.get((ICapabilityProvider)item).stream().map(SandwichItemHandler::getItems).flatMap(Collection::stream).forEach(flattenedItems::add);
        }
        ItemStack result = new ItemStack((ItemLike)ModItems.SANDWICH.get());
        result.m_41698_("BlockEntityTag").m_128365_("Sandwich", (Tag)SandwichItemHandler.serializeItems(flattenedItems));
        return result;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack sandwich, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(sandwich, world, tooltip, flag);
        SandwichItemHandler.get((ICapabilityProvider)sandwich).ifPresent(handler -> {
            MobEffectInstance instance = handler.getEffect();
            if (instance != null) {
                MutableComponent component = Component.m_237115_((String)instance.m_19576_());
                MobEffect effect = instance.m_19544_();
                component = Component.m_237110_((String)"potion.withDuration", (Object[])new Object[]{component, MobEffectUtil.m_267641_((MobEffectInstance)instance, (float)1.0f)});
                tooltip.add((Component)component.m_130940_(effect.m_19483_().m_19497_()));
            }
        });
        SandwichItemHandler.get((ICapabilityProvider)sandwich).ifPresent(handler -> handler.getItems().stream().collect(Collectors.groupingBy(item -> Ingredients.getFullName(item).m_6879_(), LinkedHashMap::new, Collectors.counting())).forEach((item, count) -> {
            if (count > 1L) {
                tooltip.add((Component)SomeAssemblyRequired.translate("tooltip.ingredient_count", item, count).m_130940_(ChatFormatting.GRAY));
            } else {
                tooltip.add((Component)item.m_130940_(ChatFormatting.GRAY));
            }
        }));
    }

    protected boolean m_7429_(BlockPlaceContext context, BlockState state) {
        boolean isPlacingOnTable = context.m_43725_().m_8055_(context.m_8083_().m_7495_()).m_204336_(ModTags.SANDWICHING_STATIONS);
        if (context.m_43723_() != null && (context.m_43723_().m_6144_() || isPlacingOnTable)) {
            return super.m_7429_(context, state);
        }
        return false;
    }

    public InteractionResult place(UseOnContext useOnContext, BlockPos pos, ItemStack sandwich) {
        BlockPos clickedPos = pos.m_7495_();
        BlockPlaceContext placeContext = BlockPlaceContext.m_43644_((BlockPlaceContext)new BlockPlaceContext(useOnContext), (BlockPos)clickedPos, (Direction)Direction.UP);
        if (!placeContext.m_7059_()) {
            return InteractionResult.FAIL;
        }
        if ((placeContext = this.m_7732_(placeContext)) == null) {
            return InteractionResult.FAIL;
        }
        BlockState blockstate = this.m_5965_(placeContext);
        if (blockstate == null) {
            return InteractionResult.FAIL;
        }
        Optional<SandwichItemHandler> itemHandler = SandwichItemHandler.get((ICapabilityProvider)sandwich);
        if (itemHandler.isEmpty()) {
            return InteractionResult.FAIL;
        }
        int size = SandwichBlock.getSizeFromSandwich(itemHandler.get());
        if (!this.m_7429_(placeContext, blockstate = (BlockState)blockstate.m_61124_((Property)SandwichBlock.SIZE, (Comparable)Integer.valueOf(size)))) {
            return InteractionResult.FAIL;
        }
        Level level = placeContext.m_43725_();
        Player player = placeContext.m_43723_();
        BlockState placedState = level.m_8055_(pos);
        if (placedState.m_60713_(blockstate.m_60734_())) {
            this.m_7274_(pos, level, player, sandwich, placedState);
            placedState.m_60734_().m_6402_(level, pos, placedState, (LivingEntity)player, sandwich);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                CriteriaTriggers.f_10591_.m_285767_(serverPlayer, pos, sandwich);
            }
        }
        level.m_142346_((Entity)player, GameEvent.f_157797_, pos);
        SoundType soundType = placedState.getSoundType((LevelReader)level, pos, (Entity)player);
        if (player != null) {
            level.m_5594_(player, pos, this.getPlaceSound(placedState, level, pos, player), SoundSource.BLOCKS, (soundType.m_56773_() + 1.0f) / 2.0f, soundType.m_56774_() * 0.8f);
        }
        if (player == null || !player.m_150110_().f_35937_) {
            sandwich.m_41774_(1);
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    public FoodProperties getFoodProperties(ItemStack stack, @Nullable LivingEntity entity) {
        return SandwichItemHandler.get((ICapabilityProvider)stack).map(SandwichItemHandler::getFoodProperties).orElse(ModFoods.EMPTY);
    }

    public ItemStack m_5922_(ItemStack stack, Level world, LivingEntity entity) {
        SandwichItemHandler.get((ICapabilityProvider)stack).ifPresent(sandwich -> {
            for (ItemStack item : sandwich.items) {
                Ingredients.onFoodEaten(item, entity);
            }
            if (entity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity;
                if (sandwich.isBurger()) {
                    player.m_36220_((ResourceLocation)ModStatistics.BURGERS_EATEN.get());
                } else {
                    player.m_36220_((ResourceLocation)ModStatistics.SANDWICHES_EATEN.get());
                }
                this.triggerAdvancements(stack, player);
            }
        });
        return super.m_5922_(stack, world, entity);
    }

    private void triggerAdvancements(ItemStack stack, ServerPlayer player) {
        SandwichItemHandler.get((ICapabilityProvider)stack).ifPresent(sandwich -> {
            if (sandwich.isDoubleDeckerSandwich()) {
                ModAdvancementTriggers.CONSUME_DOUBLE_DECKER_SANDWICH.trigger(player, stack);
            }
            for (ItemStack ingredient : sandwich) {
                if (!ingredient.m_150930_(Items.f_42589_) || PotionUtils.m_43579_((ItemStack)ingredient) == Potions.f_43599_) continue;
                ModAdvancementTriggers.CONSUME_POTION_SANDWICH.trigger(player, stack);
            }
            if (sandwich.isBurger()) {
                if (player.m_8951_().m_13015_(Stats.f_12988_.m_12902_((Object)((ResourceLocation)ModStatistics.BURGERS_EATEN.get()))) >= 1000) {
                    ModAdvancementTriggers.CONSUME_1000_BURGERS.m_222618_(player);
                }
            } else if (player.m_8951_().m_13015_(Stats.f_12988_.m_12902_((Object)((ResourceLocation)ModStatistics.SANDWICHES_EATEN.get()))) >= 1000) {
                ModAdvancementTriggers.CONSUME_1000_SANDWICHES.m_222618_(player);
            }
        });
    }

    public Component m_7626_(ItemStack stack) {
        if (stack.m_41788_()) {
            return super.m_7626_(stack);
        }
        return SandwichNameHelper.getSandwichDisplayName(stack);
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private final BlockEntityWithoutLevelRenderer renderer = new SandwichItemRenderer();

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return this.renderer;
            }
        });
    }

    public ICapabilityProvider initCapabilities(final ItemStack stack, @Nullable CompoundTag compoundNBT) {
        return new ICapabilityProvider(){
            private final LazyOptional<SandwichItemHandler> handler = LazyOptional.of(this::createHandler);

            private SandwichItemHandler createHandler() {
                ItemHandler handler = new ItemHandler(stack);
                handler.deserializeNBT(stack.m_41698_("BlockEntityTag").m_128437_("Sandwich", 10));
                return handler;
            }

            public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction side) {
                if (capability == ForgeCapabilities.ITEM_HANDLER) {
                    return this.handler.cast();
                }
                return LazyOptional.empty();
            }
        };
    }

    private static class ItemHandler
    extends SandwichItemHandler {
        private final ItemStack sandwich;

        private ItemHandler(ItemStack sandwich) {
            this.sandwich = sandwich;
        }

        @Override
        protected void onContentsChanged() {
            super.onContentsChanged();
            this.sandwich.m_41698_("BlockEntityTag").m_128365_("Sandwich", (Tag)this.serializeNBT());
        }
    }
}

