/*
 * Decompiled with CFR 0.152.
 */
package someassemblyrequired.block;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import someassemblyrequired.SomeAssemblyRequired;
import someassemblyrequired.block.SandwichBlock;
import someassemblyrequired.config.ModConfig;
import someassemblyrequired.ingredient.Ingredients;
import someassemblyrequired.item.sandwich.SandwichContents;
import someassemblyrequired.registry.ModBlockEntityTypes;
import someassemblyrequired.registry.ModBlocks;
import someassemblyrequired.registry.ModDataComponents;
import someassemblyrequired.registry.ModItems;

public class SandwichBlockEntity
extends BlockEntity {
    private SandwichContents contents = SandwichContents.EMPTY;

    public SandwichBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntityTypes.SANDWICH.get(), pos, state);
    }

    public SandwichContents getContents() {
        return this.contents;
    }

    private void setContents(SandwichContents contents) {
        this.contents = contents;
        this.onSandwichUpdated();
    }

    public InteractionResult useWithoutItem(Player player) {
        if (this.level == null) {
            return InteractionResult.SUCCESS_NO_ITEM_USED;
        }
        ItemStack stack = (ItemStack)this.contents.getLast();
        Ingredients.playRemoveSound(stack, this.level, player, this.getBlockPos());
        this.setContents(this.getContents().dropLast());
        BlockPos pos = this.getBlockPos();
        if (Ingredients.getFood(stack, (LivingEntity)player).usingConvertsTo().isEmpty() && !player.isCreative()) {
            double y = (double)pos.getY() + Math.max(0.2, (double)this.contents.getTotalHeight() * 0.03125 - 0.2);
            ItemEntity item = new ItemEntity(this.level, (double)pos.getX() + 0.5, y, (double)pos.getZ() + 0.5, stack);
            item.setPickUpDelay(5);
            this.level.addFreshEntity((Entity)item);
        }
        this.onSandwichUpdated();
        return InteractionResult.SUCCESS_NO_ITEM_USED;
    }

    public ItemInteractionResult useItemOn(ItemStack useItem, Player player, InteractionHand hand) {
        if (useItem.isEmpty()) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (!Ingredients.canAddToSandwich(useItem)) {
            return ItemInteractionResult.CONSUME;
        }
        ArrayList<ItemStack> itemsToAdd = new ArrayList<ItemStack>();
        if (useItem.is(ModItems.SANDWICH)) {
            itemsToAdd.addAll(SandwichContents.get(useItem));
        } else {
            itemsToAdd.add(useItem);
        }
        int totalHeight = this.getContents().getTotalHeight();
        for (ItemStack item : itemsToAdd) {
            totalHeight += Ingredients.getHeight(item);
        }
        if (totalHeight > (Integer)ModConfig.server.maximumSandwichHeight.get()) {
            player.displayClientMessage((Component)SomeAssemblyRequired.translate("message.full_sandwich", new Object[0]), true);
        } else {
            this.setContents(this.getContents().concat(itemsToAdd));
            Ingredients.playApplySound(useItem, this.getLevel(), player, this.getBlockPos());
            SandwichBlockEntity.shrinkHeldItem(player, hand);
        }
        return ItemInteractionResult.SUCCESS;
    }

    private static void shrinkHeldItem(Player player, InteractionHand hand) {
        if (!player.isCreative()) {
            ItemStack heldItem = player.getItemInHand(hand);
            ItemStack container = Ingredients.getFood(heldItem, (LivingEntity)player).usingConvertsTo().orElse(ItemStack.EMPTY);
            heldItem.shrink(1);
            if (!container.isEmpty()) {
                ItemStack stack = container.copy();
                if (heldItem.isEmpty()) {
                    player.setItemInHand(hand, stack);
                } else if (!player.getInventory().add(stack)) {
                    player.drop(stack, false);
                }
            }
        }
    }

    public void onSandwichUpdated() {
        if (this.level != null) {
            if (this.contents.isEmpty()) {
                this.level.removeBlock(this.getBlockPos(), false);
            } else {
                BlockState state = this.level.getBlockState(this.getBlockPos());
                if (state.is((Block)ModBlocks.SANDWICH.get())) {
                    BlockState newState = (BlockState)state.setValue((Property)SandwichBlock.SIZE, (Comparable)Integer.valueOf(SandwichBlock.getSizeFromSandwich(this.contents)));
                    this.level.setBlockAndUpdate(this.getBlockPos(), newState);
                }
                this.setChanged();
            }
        }
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput componentInput) {
        super.applyImplicitComponents(componentInput);
        this.contents = (SandwichContents)componentInput.getOrDefault((DataComponentType)ModDataComponents.SANDWICH_CONTENTS.get(), (Object)SandwichContents.EMPTY);
    }

    protected void collectImplicitComponents(DataComponentMap.Builder components) {
        super.collectImplicitComponents(components);
        components.set((DataComponentType)ModDataComponents.SANDWICH_CONTENTS.get(), (Object)this.contents);
    }

    public void removeComponentsFromTag(CompoundTag tag) {
        tag.remove("Sandwich");
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveCustomOnly(registries);
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider registries) {
        this.loadAdditional(tag, registries);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        if (tag.contains("Sandwich")) {
            SandwichContents.CODEC.decode((DynamicOps)registries.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)tag.get("Sandwich")).ifError(error -> SomeAssemblyRequired.LOGGER.error(error.message())).map(Pair::getFirst).result().ifPresent(sandwich -> {
                this.contents = sandwich;
            });
        }
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.put("Sandwich", (Tag)SandwichContents.CODEC.encodeStart((DynamicOps)registries.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)this.contents).getOrThrow());
    }
}

