/*
 * Decompiled with CFR 0.152.
 */
package someassemblyrequired.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.neoforged.neoforge.common.ModConfigSpec;

public class ServerConfig {
    public final ModConfigSpec.IntValue maximumSandwichHeight;
    public final ModConfigSpec.BooleanValue generateChestLoot;
    public final ModConfigSpec.ConfigValue<String> sandwichBonusEffect;
    public final ModConfigSpec.ConfigValue<String> burgerBonusEffect;
    public final ModConfigSpec.ConfigValue<List<Integer>> sandwichEffectDurations;
    public final ModConfigSpec.ConfigValue<List<Integer>> burgerEffectDurations;

    ServerConfig(ModConfigSpec.Builder builder) {
        this.maximumSandwichHeight = builder.comment("The maximum amount of items a sandwich can contain").translation(this.translate("maximum_sandwich_height")).defineInRange("maximum_sandwich_height", 32, 2, 256);
        this.generateChestLoot = builder.comment("Whether randomly generated sandwiches should be added to chests in villages and some other locations").translation(this.translate("generate_chest_loot")).define("generate_chest_loot", true);
        this.sandwichBonusEffect = builder.comment("The effect applied by sandwiches, depending on the number of unique ingredients").translation(this.translate("sandwich_bonus_effect")).define("sandwich_effect", (Object)ResourceLocation.fromNamespaceAndPath((String)"farmersdelight", (String)"comfort").toString());
        this.burgerBonusEffect = builder.comment("The effect applied by burgers, depending on the number of unique ingredients").translation(this.translate("burger_bonus_effect")).define("burger_effect", (Object)ResourceLocation.fromNamespaceAndPath((String)"farmersdelight", (String)"nourishment").toString());
        this.sandwichEffectDurations = builder.comment("The durations of the effect applied by sandwiches in seconds, depending on the number of unique ingredients").translation(this.translate("sandwich_bonus_effect_durations")).define("sandwich_effect_durations", new ArrayList<Integer>(List.of(Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(60), Integer.valueOf(120), Integer.valueOf(180), Integer.valueOf(240), Integer.valueOf(300))));
        this.burgerEffectDurations = builder.comment("The durations of the effect applied by burgers in seconds, depending on the number of unique ingredients").translation(this.translate("burger_bonus_effect_durations")).define("burger_effect_durations", new ArrayList<Integer>(List.of(Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(60), Integer.valueOf(120), Integer.valueOf(180), Integer.valueOf(240), Integer.valueOf(300))));
    }

    public Optional<Holder.Reference<MobEffect>> getSandwichBonusEffect(boolean burger) {
        ResourceLocation effectId;
        String effectName = burger ? (String)this.burgerBonusEffect.get() : (String)this.sandwichBonusEffect.get();
        try {
            effectId = ResourceLocation.parse((String)effectName);
        }
        catch (ResourceLocationException e) {
            return Optional.empty();
        }
        return BuiltInRegistries.MOB_EFFECT.getHolder(effectId);
    }

    private String translate(String name) {
        return "%s.config.server.%s".formatted("someassemblyrequired", name);
    }
}

