/*
 * Decompiled with CFR 0.152.
 */
package someassemblyrequired.loot;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntries;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import someassemblyrequired.SomeAssemblyRequired;
import someassemblyrequired.item.sandwich.SandwichContents;
import someassemblyrequired.registry.ModDataComponents;
import someassemblyrequired.registry.ModLootFunctions;

public class SetSandwichContentsFunction
extends LootItemConditionalFunction {
    private final List<LootPoolEntryContainer> entries;
    public static final MapCodec<SetSandwichContentsFunction> CODEC = RecordCodecBuilder.mapCodec(instance -> SetSandwichContentsFunction.commonFields((RecordCodecBuilder.Instance)instance).and((App)LootPoolEntries.CODEC.listOf().fieldOf("entries").forGetter(SetSandwichContentsFunction::entries)).apply((Applicative)instance, SetSandwichContentsFunction::new));

    protected SetSandwichContentsFunction(List<LootItemCondition> conditions, List<LootPoolEntryContainer> entries) {
        super(conditions);
        this.entries = entries;
    }

    private List<LootPoolEntryContainer> entries() {
        return this.entries;
    }

    protected ItemStack run(ItemStack item, LootContext context) {
        NonNullList ingredients = NonNullList.create();
        this.entries.forEach(entry -> entry.expand(context, lootPoolEntry -> lootPoolEntry.createItemStack(this.splitStacks(arg_0 -> ingredients.add(arg_0)), context)));
        for (ItemStack ingredient : ingredients) {
            if (!ingredient.isEmpty() && ingredient.getCount() == 1) continue;
            SomeAssemblyRequired.LOGGER.warn("Tried to generate sandwich with invalid ingredient '{}', ingredients must have a stack size of 1", (Object)ingredient.toString());
            return ItemStack.EMPTY;
        }
        SandwichContents contents = new SandwichContents((List<ItemStack>)ingredients);
        item.set(ModDataComponents.SANDWICH_CONTENTS, (Object)contents);
        return item;
    }

    private Consumer<ItemStack> splitStacks(Consumer<ItemStack> consumer) {
        return stack -> {
            if (stack.getCount() == 1) {
                consumer.accept((ItemStack)stack);
            } else if (stack.getCount() != 0) {
                int count = stack.getCount();
                stack.setCount(1);
                for (int i = 0; i < count; ++i) {
                    consumer.accept(stack.copy());
                }
            }
        };
    }

    public LootItemFunctionType<SetSandwichContentsFunction> getType() {
        return (LootItemFunctionType)ModLootFunctions.SET_SANDWICH_CONTENTS.get();
    }

    public static Builder setIngredients() {
        return new Builder();
    }

    public static class Builder
    extends LootItemConditionalFunction.Builder<Builder> {
        private final List<LootPoolEntryContainer> entries = Lists.newArrayList();

        protected Builder getThis() {
            return this;
        }

        public Builder withEntry(LootPoolEntryContainer.Builder<?> entry) {
            this.entries.add(entry.build());
            return this;
        }

        public LootItemFunction build() {
            return new SetSandwichContentsFunction(this.getConditions(), this.entries);
        }
    }
}

