/*
 * Decompiled with CFR 0.152.
 */
package someassemblyrequired.registry;

import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import someassemblyrequired.integration.ModCompat;
import someassemblyrequired.item.sandwich.SandwichContents;
import someassemblyrequired.item.sandwich.SandwichItem;
import someassemblyrequired.registry.ModBlocks;
import someassemblyrequired.registry.ModDataComponents;
import someassemblyrequired.registry.ModFoods;

public class ModItems {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((ResourceKey)Registries.ITEM, (String)"someassemblyrequired");
    public static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"someassemblyrequired");
    public static DeferredHolder<CreativeModeTab, CreativeModeTab> CREATIVE_TAB = CREATIVE_MODE_TABS.register("main", () -> CreativeModeTab.builder().icon(ModItems::makeIcon).title((Component)Component.translatable((String)"%s.creative_tab".formatted("someassemblyrequired"))).displayItems(ModItems::fillCreativeTab).build());
    public static final DeferredHolder<Item, Item> SANDWICHING_STATION = ITEMS.register("sandwiching_station", () -> ModItems.createBlockItem((Block)ModBlocks.SANDWICHING_STATION.get()));
    public static final DeferredHolder<Item, Item> BREAD_SLICE = ITEMS.register("bread_slice", () -> ModItems.createFoodItem(ModFoods.BREAD_SLICE));
    public static final DeferredHolder<Item, Item> TOASTED_BREAD_SLICE = ITEMS.register("toasted_bread_slice", () -> ModItems.createFoodItem(ModFoods.TOASTED_BREAD_SLICE));
    public static final DeferredHolder<Item, Item> RAW_BURGER_BUN = ITEMS.register("raw_burger_bun", () -> ModItems.createFoodItem(ModFoods.RAW_BURGER_BUN));
    public static final DeferredHolder<Item, Item> BURGER_BUN = ITEMS.register("burger_bun", () -> ModItems.createFoodItem(ModFoods.BURGER_BUN));
    public static final DeferredHolder<Item, Item> BURGER_BUN_BOTTOM = ITEMS.register("burger_bun_bottom", () -> ModItems.createFoodItem(ModFoods.BURGER_BUN_BOTTOM));
    public static final DeferredHolder<Item, Item> BURGER_BUN_TOP = ITEMS.register("burger_bun_top", () -> ModItems.createFoodItem(ModFoods.BURGER_BUN_TOP));
    public static final DeferredHolder<Item, Item> APPLE_SLICES = ITEMS.register("apple_slices", () -> ModItems.createFoodItem(ModFoods.APPLE_SLICES));
    public static final DeferredHolder<Item, Item> GOLDEN_APPLE_SLICES = ITEMS.register("golden_apple_slices", () -> new Item(new Item.Properties().food(ModFoods.GOLDEN_APPLE_SLICES).rarity(Rarity.RARE)));
    public static final DeferredHolder<Item, Item> ENCHANTED_GOLDEN_APPLE_SLICES = ITEMS.register("enchanted_golden_apple_slices", () -> new Item(new Item.Properties().food(ModFoods.ENCHANTED_GOLDEN_APPLE_SLICES).component(DataComponents.ENCHANTMENT_GLINT_OVERRIDE, (Object)true).rarity(Rarity.EPIC)));
    public static final DeferredHolder<Item, Item> CHOPPED_CARROT = ITEMS.register("chopped_carrot", () -> ModItems.createFoodItem(ModFoods.CHOPPED_CARROT));
    public static final DeferredHolder<Item, Item> CHOPPED_GOLDEN_CARROT = ITEMS.register("chopped_golden_carrot", () -> ModItems.createFoodItem(ModFoods.CHOPPED_GOLDEN_CARROT));
    public static final DeferredHolder<Item, Item> CHOPPED_BEETROOT = ITEMS.register("chopped_beetroot", () -> ModItems.createFoodItem(ModFoods.CHOPPED_BEETROOT));
    public static final DeferredHolder<Item, Item> TOMATO_SLICES = ITEMS.register("tomato_slices", () -> ModItems.createFoodItem(ModFoods.TOMATO_SLICES));
    public static final DeferredHolder<Item, Item> SLICED_ONION = ITEMS.register("sliced_onion", () -> ModItems.createFoodItem(ModFoods.SLICED_ONION));
    public static final DeferredHolder<Item, SandwichItem> SANDWICH = ITEMS.register("sandwich", () -> new SandwichItem((Block)ModBlocks.SANDWICH.get(), new Item.Properties().stacksTo(16).component(ModDataComponents.SANDWICH_CONTENTS, (Object)SandwichContents.EMPTY).food(new FoodProperties.Builder().build())));
    public static final DeferredHolder<Item, Item> SPREAD = ITEMS.register("spread", () -> new Item(new Item.Properties().component((DataComponentType)ModDataComponents.SPREAD_COLOR.get(), (Object)-1)));

    private static ItemStack makeIcon() {
        return new ItemStack((ItemLike)BREAD_SLICE.get());
    }

    private static void fillCreativeTab(CreativeModeTab.ItemDisplayParameters parameters, CreativeModeTab.Output output) {
        BuiltInRegistries.ITEM.stream().filter(item -> {
            String namespace = BuiltInRegistries.ITEM.getKey(item).getNamespace();
            return namespace.equals("someassemblyrequired");
        }).filter(item -> item != SPREAD.get()).filter(item -> item != SANDWICH.get()).forEach(arg_0 -> ((CreativeModeTab.Output)output).accept(arg_0));
        ModCompat.gatherCreativeTabSandwiches(arg_0 -> ((CreativeModeTab.Output)output).accept(arg_0));
    }

    private static Item createBlockItem(Block block) {
        return new BlockItem(block, new Item.Properties());
    }

    private static Item createFoodItem(FoodProperties food) {
        return new Item(new Item.Properties().food(food));
    }
}

