/*
 * Decompiled with CFR 0.152.
 */
package someassemblyrequired;

import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import someassemblyrequired.block.SandwichBlockRenderer;
import someassemblyrequired.config.ModConfig;
import someassemblyrequired.item.sandwich.SandwichItemRenderer;
import someassemblyrequired.registry.ModBlockEntityTypes;
import someassemblyrequired.registry.ModDataComponents;
import someassemblyrequired.registry.ModItems;

public class SomeAssemblyRequiredClient {
    public SomeAssemblyRequiredClient(IEventBus modEventBus, ModContainer container) {
        modEventBus.addListener(this::onClientSetup);
        modEventBus.addListener(this::onRegisterColorHandlers);
        modEventBus.addListener(this::onRegisterClientExtensions);
        container.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ModConfig.clientSpec);
    }

    public void onClientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> BlockEntityRenderers.register((BlockEntityType)((BlockEntityType)ModBlockEntityTypes.SANDWICH.get()), SandwichBlockRenderer::new));
    }

    public void onRegisterColorHandlers(RegisterColorHandlersEvent.Item event) {
        event.register((stack, tintIndex) -> {
            int color = (Integer)stack.getOrDefault(ModDataComponents.SPREAD_COLOR, (Object)-1);
            return tintIndex == 0 ? color : -1;
        }, new ItemLike[]{(ItemLike)ModItems.SPREAD.get()});
    }

    public void onRegisterClientExtensions(RegisterClientExtensionsEvent event) {
        event.registerItem(new IClientItemExtensions(this){
            private final BlockEntityWithoutLevelRenderer renderer = new SandwichItemRenderer();

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return this.renderer;
            }
        }, new Item[]{(Item)ModItems.SANDWICH.get()});
    }
}

