/*
 * Decompiled with CFR 0.152.
 */
package someassemblyrequired.ingredient.behavior;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.entity.EntityTeleportEvent;
import someassemblyrequired.ingredient.behavior.IngredientBehavior;

public class ChorusFruitBehavior
implements IngredientBehavior {
    @Override
    public void onEaten(ItemStack item, LivingEntity entity) {
        Level level = entity.level();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            double x1 = entity.getX();
            double y1 = entity.getY();
            double z1 = entity.getZ();
            for (int i = 0; i < 16; ++i) {
                EntityTeleportEvent.ChorusFruit event;
                double x2 = entity.getX() + (entity.getRandom().nextDouble() - 0.5) * 16.0;
                double y2 = Mth.clamp((double)(entity.getY() + (double)level2.getRandom().nextInt(16) - 8.0), (double)level2.getMinBuildHeight(), (double)(level2.getMinBuildHeight() + level2.getLogicalHeight() - 1));
                double z2 = entity.getZ() + (entity.getRandom().nextDouble() - 0.5) * 16.0;
                if (entity.isPassenger()) {
                    entity.stopRiding();
                }
                if ((event = EventHooks.onChorusFruitTeleport((LivingEntity)entity, (double)x2, (double)y2, (double)z2)).isCanceled()) {
                    return;
                }
                if (!entity.randomTeleport(event.getTargetX(), event.getTargetY(), event.getTargetZ(), true)) continue;
                SoundEvent soundEvent = entity instanceof Fox ? SoundEvents.FOX_TELEPORT : SoundEvents.CHORUS_FRUIT_TELEPORT;
                level2.playSound(null, x1, y1, z1, soundEvent, SoundSource.PLAYERS, 1.0f, 1.0f);
                entity.playSound(soundEvent, 1.0f, 1.0f);
                break;
            }
            if (entity instanceof Player) {
                Player player = (Player)entity;
                player.getCooldowns().addCooldown(item.getItem(), 20);
            }
        }
    }
}

