/*
 * Decompiled with CFR 0.152.
 */
package someassemblyrequired.item.sandwich;

import com.mojang.serialization.Codec;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;
import someassemblyrequired.config.ModConfig;
import someassemblyrequired.ingredient.Ingredients;
import someassemblyrequired.registry.ModDataComponents;
import someassemblyrequired.registry.ModItems;
import someassemblyrequired.registry.ModTags;

public final class SandwichContents
extends AbstractList<ItemStack> {
    public static final SandwichContents EMPTY = new SandwichContents(List.of());
    public static final Codec<SandwichContents> CODEC = ItemStack.CODEC.listOf(0, 256).xmap(SandwichContents::new, Function.identity());
    public static final StreamCodec<RegistryFriendlyByteBuf, SandwichContents> STREAM_CODEC = ItemStack.STREAM_CODEC.apply(ByteBufCodecs.list()).map(SandwichContents::new, Function.identity());
    private final List<ItemStack> items;

    public SandwichContents(List<ItemStack> items) {
        this.items = items.stream().map(ItemStack::copy).toList();
    }

    public static SandwichContents get(ItemStack stack) {
        return (SandwichContents)stack.getOrDefault(ModDataComponents.SANDWICH_CONTENTS, (Object)EMPTY);
    }

    public static Optional<SandwichContents> maybeGet(ItemStack stack) {
        return Optional.ofNullable((SandwichContents)stack.get(ModDataComponents.SANDWICH_CONTENTS));
    }

    public SandwichContents dropLast() {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>(this);
        items.removeLast();
        return new SandwichContents(items);
    }

    public SandwichContents concat(List<ItemStack> toAdd) {
        if (toAdd.stream().anyMatch(ItemStack::isEmpty)) {
            throw new IllegalArgumentException("Cannot add empty item to sandwich");
        }
        ArrayList<ItemStack> items = new ArrayList<ItemStack>(this);
        toAdd.stream().map(ItemStack::copy).peek(stack -> stack.setCount(1)).forEach(items::add);
        return new SandwichContents(items);
    }

    public int getTotalHeight() {
        int size = 0;
        for (ItemStack item : this) {
            size += Ingredients.getHeight(item);
        }
        return size;
    }

    public int nutrition(@Nullable LivingEntity entity) {
        int result = 0;
        for (ItemStack stack : this) {
            result += Ingredients.getFood(stack, entity).nutrition();
        }
        return result;
    }

    public float saturation(@Nullable LivingEntity entity) {
        float result = 0.0f;
        for (ItemStack stack : this) {
            result += Ingredients.getFood(stack, entity).saturation();
        }
        return result;
    }

    public boolean isBurger() {
        int breadCount;
        int bunCount = this.countItems(ModTags.BURGER_BUNS);
        return bunCount > (breadCount = this.countItems(ModTags.SANDWICH_BREAD) - bunCount);
    }

    public boolean hasTopAndBottomBread() {
        return !this.isEmpty() && ((ItemStack)this.getFirst()).is(ModTags.SANDWICH_BREAD) && ((ItemStack)this.getLast()).is(ModTags.SANDWICH_BREAD);
    }

    public boolean isDoubleDecker() {
        if (this.size() < 5 || !this.hasTopAndBottomBread() || this.get(1).is(ModTags.SANDWICH_BREAD) || this.get(this.size() - 2).is(ModTags.SANDWICH_BREAD)) {
            return false;
        }
        int breadCount = 0;
        for (ItemStack item : this) {
            if (!item.is(ModTags.SANDWICH_BREAD)) continue;
            ++breadCount;
        }
        return breadCount == 3;
    }

    public FoodProperties createFoodProperties(@Nullable LivingEntity entity) {
        int nutrition = this.nutrition(entity);
        float saturationModifier = 0.5f * this.saturation(entity) / (float)nutrition;
        FoodProperties.Builder builder = new FoodProperties.Builder().nutrition(nutrition).saturationModifier(saturationModifier);
        HashSet<Item> uniqueIngredients = new HashSet<Item>();
        LinkedHashMap<MobEffectInstance, Float> effects = new LinkedHashMap<MobEffectInstance, Float>();
        for (ItemStack stack : this) {
            FoodProperties food = Ingredients.getFood(stack, entity);
            if (food.nutrition() <= 0 || !food.effects().isEmpty() || stack.is(ModTags.SANDWICH_BREAD)) continue;
            uniqueIngredients.add(stack.getItem());
        }
        if (ModConfig.serverSpec.isLoaded()) {
            this.addBonusEffect(effects, uniqueIngredients.size());
        }
        for (ItemStack stack : this) {
            for (FoodProperties.PossibleEffect effect : Ingredients.getFood(stack, entity).effects()) {
                effects.computeIfPresent(effect.effect(), (i, f) -> Float.valueOf(1.0f - (1.0f - f.floatValue()) * (1.0f - effect.probability())));
                effects.putIfAbsent(effect.effect(), Float.valueOf(effect.probability()));
            }
        }
        effects.forEach((? super K instance, ? super V p) -> builder.effect(() -> new MobEffectInstance(instance), p.floatValue()));
        return builder.build();
    }

    private void addBonusEffect(Map<MobEffectInstance, Float> effects, int uniqueIngredientCount) {
        int duration;
        ResourceLocation effectId;
        String effectName = this.isBurger() ? (String)ModConfig.server.burgerBonusEffect.get() : (String)ModConfig.server.sandwichBonusEffect.get();
        List durations = this.isBurger() ? (List)ModConfig.server.burgerEffectDurations.get() : (List)ModConfig.server.sandwichEffectDurations.get();
        uniqueIngredientCount = Math.min(durations.size() - 1, uniqueIngredientCount);
        try {
            effectId = ResourceLocation.parse((String)effectName);
        }
        catch (ResourceLocationException e) {
            return;
        }
        Optional effect = BuiltInRegistries.MOB_EFFECT.getHolder(effectId);
        if (effect.isPresent() && !durations.isEmpty() && (duration = ((Integer)durations.get(uniqueIngredientCount)).intValue()) > 0) {
            effects.put(new MobEffectInstance((Holder)effect.get(), duration * 20, 0), Float.valueOf(1.0f));
        }
    }

    public ItemStack makeItem() {
        if (this.isEmpty()) {
            return ItemStack.EMPTY;
        }
        if (this.size() == 1) {
            return ((ItemStack)this.getFirst()).copy();
        }
        ItemStack result = new ItemStack((ItemLike)ModItems.SANDWICH.get());
        result.set((DataComponentType)ModDataComponents.SANDWICH_CONTENTS.get(), (Object)this);
        return result;
    }

    public int countItems(TagKey<Item> tagKey) {
        int result = 0;
        for (ItemStack ingredient : this) {
            if (!ingredient.is(tagKey)) continue;
            ++result;
        }
        return result;
    }

    @Override
    public ItemStack get(int index) {
        return this.items.get(index);
    }

    @Override
    public int size() {
        return this.items.size();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SandwichContents)) {
            return false;
        }
        SandwichContents contents = (SandwichContents)o;
        return ItemStack.listMatches((List)this, (List)contents);
    }

    @Override
    public int hashCode() {
        return ItemStack.hashStackList((List)this);
    }
}

