/*
 * Decompiled with CFR 0.152.
 */
package someassemblyrequired.data.providers;

import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderOwner;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomModelData;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.conditions.ConditionalOps;
import net.neoforged.neoforge.common.conditions.ModLoadedCondition;
import net.neoforged.neoforge.common.conditions.WithConditions;
import someassemblyrequired.data.providers.ingredient.CreateIngredients;
import someassemblyrequired.data.providers.ingredient.FarmersDelightIngredients;
import someassemblyrequired.data.providers.ingredient.IngredientBuilder;
import someassemblyrequired.data.providers.ingredient.MinersDelightIngredients;
import someassemblyrequired.ingredient.IngredientProperties;
import someassemblyrequired.registry.ModItems;

public record Ingredients(PackOutput packOutput) implements DataProvider
{
    private static final Map<Holder<Item>, IngredientBuilder> INGREDIENTS = new HashMap<Holder<Item>, IngredientBuilder>();
    public static final List<Holder<Item>> MODEL_OVERRIDES = new ArrayList<Holder<Item>>();

    private void addIngredients() {
        INGREDIENTS.clear();
        for (int i = 0; i < MODEL_OVERRIDES.size(); ++i) {
            Holder<Item> item2 = MODEL_OVERRIDES.get(i);
            ItemStack displayItem = new ItemStack((ItemLike)ModItems.SPREAD.get());
            displayItem.set(DataComponents.CUSTOM_MODEL_DATA, (Object)new CustomModelData(i + 1));
            this.builder(item2).setDisplayItem(displayItem);
        }
        CreateIngredients.addIngredients(this);
        FarmersDelightIngredients.addIngredients(this);
        MinersDelightIngredients.addIngredients(this);
        ItemStack displayItem = INGREDIENTS.get(ModItems.GOLDEN_APPLE_SLICES).getDisplayItem().copy();
        displayItem.set(DataComponents.ENCHANTMENT_GLINT_OVERRIDE, (Object)true);
        this.builder((Item)ModItems.ENCHANTED_GOLDEN_APPLE_SLICES.get()).setDisplayItem(displayItem);
        this.builder(Items.BEETROOT_SOUP).setSpread(9175075).setMoistSound();
        this.builder(Items.MUSHROOM_STEW).setSpread(11367505).setMoistSound();
        this.builder(Items.RABBIT_STEW).setSpread(12546612).setWetSound();
        this.builder(Items.SUSPICIOUS_STEW).setSpread(4169344).setMoistSound();
        this.builder(Items.HONEY_BOTTLE).setCustomFullName().setSpread(15771918, 0.8).setMoistSound();
        this.builder(Items.MILK_BUCKET).setCustomFullName().setSpread(0xEEFDFF).setMoistSound().setFoodProperties(new FoodProperties.Builder().usingConvertsTo((ItemLike)Items.BUCKET).build());
        this.builder(Items.POTATO).setHeight(5).customModel();
        this.builder((Item)ModItems.BURGER_BUN.get()).setHeight(6).customModel();
        String burgerBunHalf = "%s.ingredient.%s".formatted("someassemblyrequired", "burger_bun_half");
        this.builder((Item)ModItems.BURGER_BUN_BOTTOM.get()).setHeight(2).customModel().setFullName(burgerBunHalf);
        this.builder((Item)ModItems.BURGER_BUN_TOP.get()).setHeight(4).customModel().setFullName(burgerBunHalf);
        this.builder(Items.GOLD_BLOCK).setHeight(8).customModel().hidden();
        Arrays.asList((Item)ModItems.TOASTED_BREAD_SLICE.get(), (Item)ModItems.APPLE_SLICES.get(), (Item)ModItems.GOLDEN_APPLE_SLICES.get(), (Item)ModItems.ENCHANTED_GOLDEN_APPLE_SLICES.get(), (Item)ModItems.CHOPPED_CARROT.get(), (Item)ModItems.CHOPPED_GOLDEN_CARROT.get(), (Item)ModItems.CHOPPED_BEETROOT.get(), (Item)ModItems.TOMATO_SLICES.get(), (Item)ModItems.SLICED_ONION.get()).forEach(item -> this.builder((Item)item).setCustomDisplayName());
    }

    public IngredientBuilder builder(Item item) {
        return this.builder((Holder<Item>)BuiltInRegistries.ITEM.wrapAsHolder((Object)item));
    }

    public IngredientBuilder builder(Holder<Item> item) {
        if (INGREDIENTS.containsKey(item)) {
            return INGREDIENTS.get(item);
        }
        IngredientBuilder builder = new IngredientBuilder(item);
        INGREDIENTS.put(item, builder);
        return builder;
    }

    public CompletableFuture<?> run(CachedOutput cache) {
        Path outputFolder = this.packOutput().getOutputFolder();
        ArrayList futures = new ArrayList();
        this.addIngredients();
        INGREDIENTS.forEach((item, builder) -> {
            IngredientProperties ingredient = builder.build();
            ResourceLocation id = item.getKey().location();
            Object name = id.getPath();
            if (!"minecraft".equals(id.getNamespace()) && !"someassemblyrequired".equals(id.getNamespace())) {
                name = id.getNamespace() + "/" + (String)name;
            }
            Path path = outputFolder.resolve("data/%s/%s/ingredients/%s.json".formatted("someassemblyrequired", "someassemblyrequired", name));
            String modId = id.getNamespace();
            List conditions = modId.equals("minecraft") || modId.equals("someassemblyrequired") ? List.of() : List.of(new ModLoadedCondition(modId));
            futures.add(DataProvider.saveStable((CachedOutput)cache, (JsonElement)((JsonElement)ConditionalOps.createConditionalCodecWithConditions(IngredientProperties.CODEC).encodeStart((DynamicOps)JsonOps.INSTANCE, Optional.of(new WithConditions(conditions, (Object)ingredient))).getOrThrow()), (Path)path));
        });
        return CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new));
    }

    public static Holder.Reference<Item> reference(String modId, String path) {
        return Holder.Reference.createStandAlone((HolderOwner)BuiltInRegistries.ITEM.holderOwner(), (ResourceKey)ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)modId, (String)path)));
    }

    public String getName() {
        return "Ingredients";
    }

    static {
        MODEL_OVERRIDES.addAll(List.of(ModItems.BURGER_BUN, ModItems.BURGER_BUN_BOTTOM, ModItems.BURGER_BUN_TOP, ModItems.APPLE_SLICES, ModItems.GOLDEN_APPLE_SLICES, ModItems.CHOPPED_CARROT, ModItems.CHOPPED_GOLDEN_CARROT, ModItems.CHOPPED_BEETROOT, ModItems.TOMATO_SLICES, ModItems.SLICED_ONION));
        for (Item override : FarmersDelightIngredients.MODEL_OVERRIDES) {
            MODEL_OVERRIDES.add((Holder<Item>)BuiltInRegistries.ITEM.wrapAsHolder((Object)override));
        }
        MODEL_OVERRIDES.addAll(MinersDelightIngredients.MODEL_OVERRIDES);
        MODEL_OVERRIDES.add((Holder<Item>)BuiltInRegistries.ITEM.wrapAsHolder((Object)Items.POTATO));
    }
}

