/*
 * Decompiled with CFR 0.152.
 */
package someassemblyrequired.ingredient;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import someassemblyrequired.registry.ModFoods;

public interface IngredientPropertiesBase {
    public Optional<FoodProperties> food();

    default public FoodProperties getFood(ItemStack stack, @Nullable LivingEntity entity) {
        if (this.food().isPresent()) {
            return this.food().get();
        }
        FoodProperties p = stack.getFoodProperties(entity);
        if (p != null) {
            if (p.usingConvertsTo().isEmpty() && stack.hasCraftingRemainingItem()) {
                ItemStack remainder = stack.getCraftingRemainingItem().copy();
                remainder.setCount(1);
                return new FoodProperties(p.nutrition(), p.saturation(), p.canAlwaysEat(), p.eatSeconds(), Optional.of(remainder), p.effects());
            }
            return p;
        }
        return ModFoods.EMPTY;
    }

    default public Component getDisplayName(ItemStack stack) {
        return this.displayName().orElse(this.getFullName(stack));
    }

    public Optional<Component> displayName();

    default public Component getFullName(ItemStack stack) {
        return this.fullName().orElse(stack.getHoverName());
    }

    public Optional<Component> fullName();

    public ItemStack displayItem();

    default public ItemStack getDisplayItem(ItemStack stack) {
        return this.displayItem().isEmpty() ? stack : this.displayItem();
    }

    public boolean renderAsItem();

    default public boolean hidden() {
        return false;
    }

    default public int height() {
        return 1;
    }

    public Holder<SoundEvent> sound();

    default public void playSound(Level level, Player player, BlockPos pos, float pitch) {
        level.playSound(player, pos, (SoundEvent)this.sound().value(), SoundSource.BLOCKS, 1.0f, pitch);
    }
}

