/*
 * Decompiled with CFR 0.152.
 */
package someassemblyrequired.integration.create.recipe;

import com.mojang.serialization.MapCodec;
import com.simibubi.create.AllDataComponents;
import com.simibubi.create.AllFluids;
import com.simibubi.create.content.fluids.potion.PotionFluid;
import com.simibubi.create.content.fluids.potion.PotionFluidHandler;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import someassemblyrequired.recipe.SandwichSpoutingRecipe;
import someassemblyrequired.registry.ModRecipeTypes;

public class SandwichPotionSpoutingRecipe
extends SandwichSpoutingRecipe {
    private static final ItemStack BOTTLE = new ItemStack((ItemLike)Items.GLASS_BOTTLE);
    private static final SandwichPotionSpoutingRecipe INSTANCE = new SandwichPotionSpoutingRecipe();

    @Override
    public int getAmountRequired(FluidStack fluid) {
        return PotionFluidHandler.getRequiredAmountForFilledBottle((ItemStack)BOTTLE, (FluidStack)fluid);
    }

    @Override
    public boolean matches(FluidStack fluid) {
        if (!fluid.getFluid().isSame((Fluid)AllFluids.POTION.get())) {
            return false;
        }
        return fluid.get(AllDataComponents.POTION_FLUID_BOTTLE_TYPE) == PotionFluid.BottleType.REGULAR;
    }

    @Override
    public ItemStack assemble(FluidStack fluid) {
        return PotionFluidHandler.fillBottle((ItemStack)BOTTLE.copy(), (FluidStack)fluid.copy());
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipeTypes.SANDWICH_POTION_SPOUTING_SERIALIZER.get();
    }

    public static class Serializer
    implements RecipeSerializer<SandwichPotionSpoutingRecipe> {
        public MapCodec<SandwichPotionSpoutingRecipe> codec() {
            return MapCodec.unit((Object)INSTANCE);
        }

        public StreamCodec<RegistryFriendlyByteBuf, SandwichPotionSpoutingRecipe> streamCodec() {
            return StreamCodec.unit((Object)INSTANCE);
        }
    }
}

