/*
 * Decompiled with CFR 0.152.
 */
package someassemblyrequired.integration.jei.create;

import com.simibubi.create.Create;
import com.simibubi.create.compat.jei.CreateJEI;
import com.simibubi.create.content.fluids.potion.PotionFluidHandler;
import com.simibubi.create.content.fluids.transfer.FillingRecipe;
import com.simibubi.create.content.kinetics.deployer.DeployerApplicationRecipe;
import com.simibubi.create.content.kinetics.deployer.ItemApplicationRecipe;
import com.simibubi.create.content.processing.recipe.StandardProcessingRecipe;
import com.simibubi.create.content.processing.sequenced.SequencedAssemblyRecipeBuilder;
import com.simibubi.create.foundation.fluid.FluidHelper;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.advanced.ISimpleRecipeManagerPlugin;
import mezz.jei.api.registration.IAdvancedRegistration;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.fluids.FluidStack;
import someassemblyrequired.SomeAssemblyRequired;
import someassemblyrequired.integration.ModCompat;
import someassemblyrequired.integration.create.recipe.SandwichFluidSpoutingRecipe;
import someassemblyrequired.integration.jei.SandwichRecipeGenerator;
import someassemblyrequired.item.sandwich.SandwichContents;
import someassemblyrequired.item.sandwich.SandwichItem;
import someassemblyrequired.recipe.SandwichSpoutingRecipe;
import someassemblyrequired.registry.ModItems;
import someassemblyrequired.registry.ModRecipeTypes;

public class SequencedAssemblyRecipeGenerator
extends SandwichRecipeGenerator<RecipeHolder<Recipe<?>>> {
    private static final RecipeType<RecipeHolder<Recipe<?>>> SEQUENCED_ASSEMBLY = RecipeType.createRecipeHolderType((ResourceLocation)Create.asResource((String)"sequenced_assembly"));

    public static void register(IAdvancedRegistration registration) {
        registration.addTypedRecipeManagerPlugin(SEQUENCED_ASSEMBLY, (ISimpleRecipeManagerPlugin)new SequencedAssemblyRecipeGenerator());
    }

    @Override
    protected int getMaxToppings() {
        return 6;
    }

    @Override
    protected RecipeHolder<Recipe<?>> getRecipeForSandwich(ItemStack prefix, List<ItemStack> toppings, ItemStack result) {
        SequencedAssemblyRecipeBuilder recipe = new SequencedAssemblyRecipeBuilder(SomeAssemblyRequired.id("dynamic/sequenced_assembly")).transitionTo((ItemLike)ModItems.SANDWICH.get()).loops(1).addOutput(result, 1.0f).require(Ingredient.of((ItemStack[])new ItemStack[]{prefix}));
        for (ItemStack input : toppings) {
            Optional<FluidIngredient> fluidIngredient = this.getFluidFromFilling(input);
            if (fluidIngredient.isPresent()) {
                recipe.addStep(FillingRecipe::new, builder -> (StandardProcessingRecipe.Builder)builder.require((FluidIngredient)fluidIngredient.get()));
                continue;
            }
            recipe.addStep(DeployerApplicationRecipe::new, builder -> (ItemApplicationRecipe.Builder)builder.require(Ingredient.of((ItemStack[])new ItemStack[]{input})));
        }
        RecipeHolder r = recipe.build();
        return new RecipeHolder(r.id(), r.value());
    }

    @Override
    protected List<RecipeHolder<Recipe<?>>> getRecipesForBread(ItemStack bottomBread, ItemStack topBread) {
        List<RecipeHolder<Recipe<?>>> recipes = super.getRecipesForBread(bottomBread, topBread);
        this.getSpoutingRecipes().map(recipe -> recipe.assemble(FluidStack.EMPTY)).filter(item -> !item.is(Items.HONEY_BOTTLE)).map(filling -> SandwichItem.of(bottomBread, filling, topBread)).map(sandwich -> (RecipeHolder)this.getRecipeForSandwich(SandwichContents.get(sandwich))).forEach(recipes::add);
        ModCompat.EXAMPLE_POTIONS.stream().filter(potion -> !((Potion)potion.value()).getEffects().isEmpty()).map(potion -> PotionContents.createItemStack((Item)Items.POTION, (Holder)potion)).map(potion -> (RecipeHolder)this.createRecipe(bottomBread, (ItemStack)potion, topBread)).forEach(recipes::add);
        return recipes;
    }

    @Override
    protected ItemStack getFillingFromFluid(FluidStack fluid) {
        for (RecipeHolder recipe : CreateJEI.getTypedRecipes((net.minecraft.world.item.crafting.RecipeType)((net.minecraft.world.item.crafting.RecipeType)ModRecipeTypes.SANDWICH_SPOUTING.get()))) {
            if (!((SandwichSpoutingRecipe)recipe.value()).matches(fluid)) continue;
            return ((SandwichSpoutingRecipe)recipe.value()).assemble(fluid);
        }
        throw new IllegalArgumentException("Unsupported fluid: [%s]".formatted(fluid.toString()));
    }

    @Override
    protected Optional<FluidIngredient> getFluidFromFilling(ItemStack filling) {
        if (filling.is(Items.POTION)) {
            int requiredAmount = PotionFluidHandler.getRequiredAmountForFilledBottle(null, null);
            return Optional.of(FluidIngredient.fromFluidStack((FluidStack)FluidHelper.copyStackWithAmount((FluidStack)PotionFluidHandler.getFluidFromPotionItem((ItemStack)filling), (int)requiredAmount)));
        }
        return this.getSpoutingRecipes().filter(recipe -> ItemStack.isSameItemSameComponents((ItemStack)recipe.getResultItem((HolderLookup.Provider)RegistryAccess.EMPTY), (ItemStack)filling)).map(SandwichFluidSpoutingRecipe::ingredient).findFirst();
    }

    private Stream<SandwichFluidSpoutingRecipe> getSpoutingRecipes() {
        return CreateJEI.getTypedRecipesExcluding((net.minecraft.world.item.crafting.RecipeType)((net.minecraft.world.item.crafting.RecipeType)ModRecipeTypes.SANDWICH_SPOUTING.get()), recipe -> recipe.value().getSerializer() != ModRecipeTypes.SANDWICH_FLUID_SPOUTING_SERIALIZER.get()).stream().map(RecipeHolder::value).map(recipe -> (SandwichFluidSpoutingRecipe)recipe);
    }
}

