/*
 * Decompiled with CFR 0.152.
 */
package net.graftedweaponry;

import com.mojang.blaze3d.platform.NativeImage;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import javax.imageio.ImageIO;
import net.graftedweaponry.GraftedWeaponryMod;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GraftedTextures {
    private static final Map<ResourceLocation, ResourceLocation> graftedTextures = new HashMap<ResourceLocation, ResourceLocation>();
    private static final Map<String, ResourceLocation> essenceTextures = new HashMap<String, ResourceLocation>();

    public static ResourceLocation recolorEssenceTexture(String location) {
        try {
            if (essenceTextures.containsKey(location)) {
                return essenceTextures.get(location);
            }
            Minecraft mc = Minecraft.m_91087_();
            LivingEntity entity = GraftedWeaponryMod.getEntityFromId(location, (Level)mc.f_91073_);
            ResourceLocation entityTexture = mc.m_91290_().m_114382_((Entity)entity).m_5478_((Entity)entity);
            BufferedImage entityImg = ImageIO.read(((Resource)mc.m_91098_().m_213713_(entityTexture).get()).m_215507_());
            long r = 0L;
            long g = 0L;
            long b = 0L;
            int count = 0;
            for (int x = 0; x < entityImg.getWidth(); ++x) {
                for (int y = 0; y < entityImg.getHeight(); ++y) {
                    int rgba = entityImg.getRGB(x, y);
                    int alpha = rgba >> 24 & 0xFF;
                    if (alpha <= 0) continue;
                    r += (long)(rgba >> 16 & 0xFF);
                    g += (long)(rgba >> 8 & 0xFF);
                    b += (long)(rgba & 0xFF);
                    ++count;
                }
            }
            if (count == 0) {
                return ResourceLocation.parse((String)"grafted_weaponry:textures/item/essence_texture.png");
            }
            int avgR = (int)(r / (long)count);
            int avgG = (int)(g / (long)count);
            int avgB = (int)(b / (long)count);
            ResourceLocation essenceLoc = ResourceLocation.parse((String)"grafted_weaponry:textures/item/essence_texture.png");
            BufferedImage essenceImg = ImageIO.read(((Resource)mc.m_91098_().m_213713_(essenceLoc).get()).m_215507_());
            BufferedImage recolored = new BufferedImage(essenceImg.getWidth(), essenceImg.getHeight(), 2);
            for (int x = 0; x < essenceImg.getWidth(); ++x) {
                for (int y = 0; y < essenceImg.getHeight(); ++y) {
                    int rgba = essenceImg.getRGB(x, y);
                    int alpha = rgba >> 24 & 0xFF;
                    recolored.setRGB(x, y, alpha << 24 | avgR << 16 | avgG << 8 | avgB);
                }
            }
            ResourceLocation recoloredLoc = ResourceLocation.parse((String)("grafted_weaponry:essence_" + entity.m_19879_()));
            NativeImage nativeImg = new NativeImage(recolored.getWidth(), recolored.getHeight(), false);
            for (int x = 0; x < recolored.getWidth(); ++x) {
                for (int y = 0; y < recolored.getHeight(); ++y) {
                    int argb = recolored.getRGB(x, y);
                    int a = argb >> 24 & 0xFF;
                    int r2 = argb >> 16 & 0xFF;
                    int g2 = argb >> 8 & 0xFF;
                    int b2 = argb & 0xFF;
                    nativeImg.m_84988_(x, y, a << 24 | b2 << 16 | g2 << 8 | r2);
                }
            }
            mc.m_91097_().m_118495_(recoloredLoc, (AbstractTexture)new DynamicTexture(nativeImg));
            essenceTextures.put(location, recoloredLoc);
            return recoloredLoc;
        }
        catch (Exception e) {
            return ResourceLocation.parse((String)"grafted_weaponry:textures/item/essence_texture.png");
        }
    }

    public static ResourceLocation graftTexture(ResourceLocation originalTexture) {
        if (graftedTextures.containsKey(originalTexture)) {
            return graftedTextures.get(originalTexture);
        }
        try {
            BufferedImage original;
            Optional resource = Minecraft.m_91087_().m_91098_().m_213713_(originalTexture);
            if (resource.isEmpty()) {
                return originalTexture;
            }
            try (InputStream inputStream = ((Resource)resource.get()).m_215507_();){
                original = ImageIO.read(inputStream);
            }
            if (original == null) {
                return originalTexture;
            }
            int width = original.getWidth();
            int height = original.getHeight();
            BufferedImage grafted = new BufferedImage(width, height, 2);
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    int pixel = original.getRGB(x, y);
                    if (GraftedTextures.isTransparent(pixel)) continue;
                    grafted.setRGB(x, y, pixel);
                }
            }
            boolean[][] visited = new boolean[height][width];
            List<List<Point>> emptyRegions = GraftedTextures.findTransparentRegions(original, visited);
            Random random = new Random(42L);
            for (List<Point> region : emptyRegions) {
                GraftedTextures.fillRegionWithPatches(original, grafted, region, random);
            }
            GraftedTextures.ensureNoTransparentPixels(original, grafted, random);
            ResourceLocation graftedLocation = ResourceLocation.parse((String)("grafted:" + originalTexture.m_135827_() + "_" + originalTexture.m_135815_().replace("/", "_")));
            NativeImage nativeImage = new NativeImage(width, height, false);
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    int argb = grafted.getRGB(x, y);
                    if (GraftedTextures.isTransparent(argb)) {
                        argb = -16777216;
                    }
                    int a = argb >> 24 & 0xFF;
                    int r = argb >> 16 & 0xFF;
                    int g = argb >> 8 & 0xFF;
                    int b = argb & 0xFF;
                    int abgr = a << 24 | b << 16 | g << 8 | r;
                    nativeImage.m_84988_(x, y, abgr);
                }
            }
            DynamicTexture dynamicTexture = new DynamicTexture(nativeImage);
            Minecraft.m_91087_().m_91097_().m_118495_(graftedLocation, (AbstractTexture)dynamicTexture);
            graftedTextures.put(originalTexture, graftedLocation);
            return graftedLocation;
        }
        catch (Exception e) {
            e.printStackTrace();
            return originalTexture;
        }
    }

    private static boolean isTransparent(int argb) {
        return (argb >>> 24 & 0xFF) == 0;
    }

    private static List<List<Point>> findTransparentRegions(BufferedImage original, boolean[][] visited) {
        ArrayList<List<Point>> regions = new ArrayList<List<Point>>();
        int width = original.getWidth();
        int height = original.getHeight();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                if (visited[y][x]) continue;
                int pixel = original.getRGB(x, y);
                if (GraftedTextures.isTransparent(pixel)) {
                    ArrayList<Point> region = new ArrayList<Point>();
                    GraftedTextures.floodFillTransparent(original, visited, x, y, region);
                    if (region.isEmpty()) continue;
                    regions.add(region);
                    continue;
                }
                visited[y][x] = true;
            }
        }
        return regions;
    }

    private static void floodFillTransparent(BufferedImage original, boolean[][] visited, int startX, int startY, List<Point> region) {
        int width = original.getWidth();
        int height = original.getHeight();
        ArrayDeque<Point> stack = new ArrayDeque<Point>();
        stack.push(new Point(startX, startY));
        while (!stack.isEmpty()) {
            Point p = (Point)stack.pop();
            int x = p.x;
            int y = p.y;
            if (x < 0 || x >= width || y < 0 || y >= height || visited[y][x]) continue;
            int pixel = original.getRGB(x, y);
            if (!GraftedTextures.isTransparent(pixel)) {
                visited[y][x] = true;
                continue;
            }
            visited[y][x] = true;
            region.add(new Point(x, y));
            stack.push(new Point(x + 1, y));
            stack.push(new Point(x - 1, y));
            stack.push(new Point(x, y + 1));
            stack.push(new Point(x, y - 1));
        }
    }

    private static void fillRegionWithPatches(BufferedImage original, BufferedImage grafted, List<Point> region, Random random) {
        if (region.isEmpty()) {
            return;
        }
        int width = original.getWidth();
        int height = original.getHeight();
        int minX = region.stream().mapToInt(p -> p.x).min().orElse(0);
        int maxX = region.stream().mapToInt(p -> p.x).max().orElse(width - 1);
        int minY = region.stream().mapToInt(p -> p.y).min().orElse(0);
        int maxY = region.stream().mapToInt(p -> p.y).max().orElse(height - 1);
        int regionWidth = maxX - minX + 1;
        int regionHeight = maxY - minY + 1;
        boolean[][] regionMask = new boolean[regionHeight][regionWidth];
        for (Point p2 : region) {
            regionMask[p2.y - minY][p2.x - minX] = true;
        }
        List<Point> sourcePatches = GraftedTextures.findGoodSourcePatches(original, Math.min(regionWidth, regionHeight));
        if (sourcePatches.isEmpty()) {
            GraftedTextures.fillRegionPixelByPixel(original, grafted, region, random);
            return;
        }
        int maxPatches = Math.max(1, regionWidth * regionHeight / 64);
        int patchSize = Math.min(16, Math.max(4, Math.min(regionWidth, regionHeight) / 2));
        for (int patchesUsed = 0; patchesUsed < maxPatches && GraftedTextures.hasUnfilledPixels(grafted, region); ++patchesUsed) {
            Point sourcePatch = sourcePatches.get(random.nextInt(sourcePatches.size()));
            Point targetPos = GraftedTextures.findBestPatchPosition(grafted, region, patchSize, random);
            if (targetPos == null) break;
            GraftedTextures.copyPatch(original, grafted, sourcePatch, targetPos, patchSize, regionMask, minX, minY);
        }
        GraftedTextures.fillRemainingPixels(original, grafted, region);
    }

    private static List<Point> findGoodSourcePatches(BufferedImage original, int maxPatchSize) {
        ArrayList<Point> sourcePatches = new ArrayList<Point>();
        int width = original.getWidth();
        int height = original.getHeight();
        int patchSize = Math.max(1, Math.min(maxPatchSize, 16));
        int step = Math.max(1, patchSize / 2);
        for (int y = 0; y <= height - patchSize; y += step) {
            for (int x = 0; x <= width - patchSize; x += step) {
                int nonTransparentCount = 0;
                int totalPixels = patchSize * patchSize;
                for (int py = 0; py < patchSize; ++py) {
                    for (int px = 0; px < patchSize; ++px) {
                        int pixel = original.getRGB(x + px, y + py);
                        if (GraftedTextures.isTransparent(pixel)) continue;
                        ++nonTransparentCount;
                    }
                }
                if (!((double)nonTransparentCount >= (double)totalPixels * 0.6)) continue;
                sourcePatches.add(new Point(x, y));
            }
        }
        return sourcePatches;
    }

    private static Point findBestPatchPosition(BufferedImage grafted, List<Point> region, int patchSize, Random random) {
        ArrayList<Point> candidates = new ArrayList<Point>();
        for (Point p : region) {
            int pixel = grafted.getRGB(p.x, p.y);
            if (!GraftedTextures.isTransparent(pixel)) continue;
            candidates.add(new Point(p.x - patchSize / 2, p.y - patchSize / 2));
        }
        if (candidates.isEmpty()) {
            return null;
        }
        return (Point)candidates.get(random.nextInt(candidates.size()));
    }

    private static void copyPatch(BufferedImage source, BufferedImage target, Point sourcePos, Point targetPos, int patchSize, boolean[][] regionMask, int regionMinX, int regionMinY) {
        int sourceWidth = source.getWidth();
        int sourceHeight = source.getHeight();
        int targetWidth = target.getWidth();
        int targetHeight = target.getHeight();
        for (int py = 0; py < patchSize; ++py) {
            for (int px = 0; px < patchSize; ++px) {
                int sourcePixel;
                int currentPixel;
                int sourceX = sourcePos.x + px;
                int sourceY = sourcePos.y + py;
                int targetX = targetPos.x + px;
                int targetY = targetPos.y + py;
                if (sourceX < 0 || sourceX >= sourceWidth || sourceY < 0 || sourceY >= sourceHeight || targetX < 0 || targetX >= targetWidth || targetY < 0 || targetY >= targetHeight) continue;
                int maskX = targetX - regionMinX;
                int maskY = targetY - regionMinY;
                if (maskX < 0 || maskX >= regionMask[0].length || maskY < 0 || maskY >= regionMask.length || !regionMask[maskY][maskX] || !GraftedTextures.isTransparent(currentPixel = target.getRGB(targetX, targetY)) || GraftedTextures.isTransparent(sourcePixel = source.getRGB(sourceX, sourceY))) continue;
                target.setRGB(targetX, targetY, sourcePixel);
            }
        }
    }

    private static boolean hasUnfilledPixels(BufferedImage grafted, List<Point> region) {
        for (Point p : region) {
            int pixel = grafted.getRGB(p.x, p.y);
            if (!GraftedTextures.isTransparent(pixel)) continue;
            return true;
        }
        return false;
    }

    private static void fillRemainingPixels(BufferedImage original, BufferedImage grafted, List<Point> region) {
        int width = original.getWidth();
        int height = original.getHeight();
        for (Point p : region) {
            int nearbyPixel;
            int pixel = grafted.getRGB(p.x, p.y);
            if (!GraftedTextures.isTransparent(pixel) || GraftedTextures.isTransparent(nearbyPixel = GraftedTextures.findNearestNonTransparentPixel(original, grafted, p.x, p.y, width, height))) continue;
            grafted.setRGB(p.x, p.y, nearbyPixel);
        }
    }

    private static int findNearestNonTransparentPixel(BufferedImage original, BufferedImage grafted, int x, int y, int width, int height) {
        int maxRadius = Math.max(width, height);
        for (int radius = 1; radius <= maxRadius; ++radius) {
            int p;
            int p2;
            int ymin = Math.max(0, y - radius);
            int ymax = Math.min(height - 1, y + radius);
            int xmin = Math.max(0, x - radius);
            int xmax = Math.min(width - 1, x + radius);
            for (int nx = xmin; nx <= xmax; ++nx) {
                int nyBottom;
                int nyTop = ymin;
                if (nyTop >= 0) {
                    p2 = original.getRGB(nx, nyTop);
                    if (!GraftedTextures.isTransparent(p2)) {
                        return p2;
                    }
                    p2 = grafted.getRGB(nx, nyTop);
                    if (!GraftedTextures.isTransparent(p2)) {
                        return p2;
                    }
                }
                if ((nyBottom = ymax) >= height) continue;
                p = original.getRGB(nx, nyBottom);
                if (!GraftedTextures.isTransparent(p)) {
                    return p;
                }
                p = grafted.getRGB(nx, nyBottom);
                if (GraftedTextures.isTransparent(p)) continue;
                return p;
            }
            for (int ny = ymin + 1; ny <= ymax - 1; ++ny) {
                int nxRight;
                int nxLeft = xmin;
                if (nxLeft >= 0) {
                    p2 = original.getRGB(nxLeft, ny);
                    if (!GraftedTextures.isTransparent(p2)) {
                        return p2;
                    }
                    p2 = grafted.getRGB(nxLeft, ny);
                    if (!GraftedTextures.isTransparent(p2)) {
                        return p2;
                    }
                }
                if ((nxRight = xmax) >= width) continue;
                p = original.getRGB(nxRight, ny);
                if (!GraftedTextures.isTransparent(p)) {
                    return p;
                }
                p = grafted.getRGB(nxRight, ny);
                if (GraftedTextures.isTransparent(p)) continue;
                return p;
            }
        }
        int any = GraftedTextures.sampleAnyNonTransparentPixel(original, grafted);
        if (!GraftedTextures.isTransparent(any)) {
            return any;
        }
        return -16777216;
    }

    private static int sampleAnyNonTransparentPixel(BufferedImage original, BufferedImage grafted) {
        int p;
        int x;
        int y;
        int width = original.getWidth();
        int height = original.getHeight();
        for (y = 0; y < height; ++y) {
            for (x = 0; x < width; ++x) {
                p = original.getRGB(x, y);
                if (GraftedTextures.isTransparent(p)) continue;
                return p;
            }
        }
        for (y = 0; y < height; ++y) {
            for (x = 0; x < width; ++x) {
                p = grafted.getRGB(x, y);
                if (GraftedTextures.isTransparent(p)) continue;
                return p;
            }
        }
        return 0;
    }

    private static void fillRegionPixelByPixel(BufferedImage original, BufferedImage grafted, List<Point> region, Random random) {
        int pixel;
        int x;
        int y;
        ArrayList<Integer> nonTransparentPixels = new ArrayList<Integer>();
        int width = original.getWidth();
        int height = original.getHeight();
        for (y = 0; y < height; ++y) {
            for (x = 0; x < width; ++x) {
                pixel = original.getRGB(x, y);
                if (GraftedTextures.isTransparent(pixel)) continue;
                nonTransparentPixels.add(pixel);
            }
        }
        if (nonTransparentPixels.isEmpty()) {
            for (y = 0; y < height; ++y) {
                for (x = 0; x < width; ++x) {
                    pixel = grafted.getRGB(x, y);
                    if (GraftedTextures.isTransparent(pixel)) continue;
                    nonTransparentPixels.add(pixel);
                }
            }
        }
        if (nonTransparentPixels.isEmpty()) {
            for (Point p : region) {
                grafted.setRGB(p.x, p.y, -16777216);
            }
            return;
        }
        for (Point p : region) {
            int randomPixel = (Integer)nonTransparentPixels.get(random.nextInt(nonTransparentPixels.size()));
            grafted.setRGB(p.x, p.y, randomPixel);
        }
    }

    private static void ensureNoTransparentPixels(BufferedImage original, BufferedImage grafted, Random random) {
        int width = original.getWidth();
        int height = original.getHeight();
        int fallback = GraftedTextures.sampleAnyNonTransparentPixel(original, grafted);
        if (GraftedTextures.isTransparent(fallback)) {
            fallback = -16777216;
        }
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int pixel = grafted.getRGB(x, y);
                if (!GraftedTextures.isTransparent(pixel)) continue;
                int found = GraftedTextures.findNearestNonTransparentPixel(original, grafted, x, y, width, height);
                if (!GraftedTextures.isTransparent(found)) {
                    grafted.setRGB(x, y, found);
                    continue;
                }
                grafted.setRGB(x, y, fallback);
            }
        }
    }

    private static class Point {
        final int x;
        final int y;

        Point(int x, int y) {
            this.x = x;
            this.y = y;
        }
    }
}

