/*
 * Decompiled with CFR 0.152.
 */
package net.graftedweaponry;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.graftedweaponry.init.GraftedWeaponryModBlockEntities;
import net.graftedweaponry.init.GraftedWeaponryModBlocks;
import net.graftedweaponry.init.GraftedWeaponryModItems;
import net.graftedweaponry.init.GraftedWeaponryModMenus;
import net.graftedweaponry.init.GraftedWeaponryModTabs;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.util.thread.SidedThreadGroups;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="grafted_weaponry")
public class GraftedWeaponryMod {
    public static final Logger LOGGER = LogManager.getLogger(GraftedWeaponryMod.class);
    public static final String MODID = "grafted_weaponry";
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel PACKET_HANDLER = NetworkRegistry.newSimpleChannel((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"grafted_weaponry", (String)"grafted_weaponry"), () -> "1", "1"::equals, "1"::equals);
    private static int messageID = 0;
    private static final Collection<AbstractMap.SimpleEntry<Runnable, Integer>> workQueue = new ConcurrentLinkedQueue<AbstractMap.SimpleEntry<Runnable, Integer>>();

    public GraftedWeaponryMod(FMLJavaModLoadingContext context) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        IEventBus bus = context.getModEventBus();
        GraftedWeaponryModBlocks.REGISTRY.register(bus);
        GraftedWeaponryModBlockEntities.REGISTRY.register(bus);
        GraftedWeaponryModItems.REGISTRY.register(bus);
        GraftedWeaponryModTabs.REGISTRY.register(bus);
        GraftedWeaponryModMenus.REGISTRY.register(bus);
    }

    public static LivingEntity getEntityFromId(String id, Level level) {
        EntityType type = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(ResourceLocation.parse((String)id));
        if (type == null) {
            return null;
        }
        Entity entity = type.m_20615_(level);
        if (entity instanceof LivingEntity) {
            return (LivingEntity)entity;
        }
        return null;
    }

    public static <T> void addNetworkMessage(Class<T> messageType, BiConsumer<T, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, T> decoder, BiConsumer<T, Supplier<NetworkEvent.Context>> messageConsumer) {
        PACKET_HANDLER.registerMessage(messageID, messageType, encoder, decoder, messageConsumer);
        ++messageID;
    }

    public static void queueServerWork(int tick, Runnable action) {
        if (Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER) {
            workQueue.add(new AbstractMap.SimpleEntry<Runnable, Integer>(action, tick));
        }
    }

    @SubscribeEvent
    public void tick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ArrayList actions = new ArrayList();
            workQueue.forEach(work -> {
                work.setValue((Integer)work.getValue() - 1);
                if ((Integer)work.getValue() == 0) {
                    actions.add(work);
                }
            });
            actions.forEach(e -> ((Runnable)e.getKey()).run());
            workQueue.removeAll(actions);
        }
    }
}

