/*
 * Decompiled with CFR 0.152.
 */
package net.graftedweaponry.configuration;

import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;

public class GraftedWeaponryConfiguration {
    public static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec SPEC;
    public static final ForgeConfigSpec.ConfigValue<Boolean> ALWAYS_CREATIVE_ESSENCE;
    public static final ForgeConfigSpec.ConfigValue<Boolean> ESSENCE_BONUS_ROLLS;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> ESSENCE_BLACKLIST;
    public static final ForgeConfigSpec.ConfigValue<Double> KIN_SLAYER;
    public static final ForgeConfigSpec.ConfigValue<Double> DURABILITY_MULTIPLIER;
    public static final ForgeConfigSpec.ConfigValue<Double> ATTACK_SPEED_MULTIPLIER;
    public static final ForgeConfigSpec.ConfigValue<Double> ATTACK_DAMAGE_MULTIPLIER;
    public static final ForgeConfigSpec.ConfigValue<Double> AXE_HEAD_DAMAGE;
    public static final ForgeConfigSpec.ConfigValue<Double> HOOK_HANDLE_CHANCE;
    public static final ForgeConfigSpec.ConfigValue<Double> HOOK_HANDLE_COOLDOWN;
    public static final ForgeConfigSpec.ConfigValue<Double> GREATSWORD_HANDLE_NEGATION_CHANCE;
    public static final ForgeConfigSpec.ConfigValue<Double> HALBERD_HEAD_DAMAGE;
    public static final ForgeConfigSpec.ConfigValue<Double> HALBERD_ENTITY_REACH;
    public static final ForgeConfigSpec.ConfigValue<Double> HOOK_POMMEL_CHANCE;
    public static final ForgeConfigSpec.ConfigValue<Double> HOOK_POMMEL_COOLDOWN;
    public static final ForgeConfigSpec.ConfigValue<Double> MACE_HEAD_SPEED_MODIFIER;
    public static final ForgeConfigSpec.ConfigValue<Double> MACE_HEAD_CRITICAL_MULTIPLIER;
    public static final ForgeConfigSpec.ConfigValue<Double> PIKE_HEAD_ARMOR_DAMAGE;
    public static final ForgeConfigSpec.ConfigValue<Double> PIKE_HEAD_ATTACK_SPEED;
    public static final ForgeConfigSpec.ConfigValue<Double> RAPIER_HANDLE_DAMAGE_NEGATION;
    public static final ForgeConfigSpec.ConfigValue<Double> SABER_BLADE_DAMAGE_REDUCTION;
    public static final ForgeConfigSpec.ConfigValue<Double> SCYTHE_HEAD_DAMAGE_REDUCTION;
    public static final ForgeConfigSpec.ConfigValue<Double> SERRADED_BLADE_DURATION;
    public static final ForgeConfigSpec.ConfigValue<Double> SERRADED_BLADE_DAMAGE;
    public static final ForgeConfigSpec.ConfigValue<Double> SPIKED_HANDLE_DURATION;
    public static final ForgeConfigSpec.ConfigValue<Double> SPIKED_HANDLE_DAMAGE;
    public static final ForgeConfigSpec.ConfigValue<Double> SPIKED_POMMEL_PIERCING_DAMAGE;
    public static final ForgeConfigSpec.ConfigValue<Double> TWOHANDED_POMMEL_REACH;
    public static final ForgeConfigSpec.ConfigValue<Double> TWOHANDED_POMMEL_SPEED_REDUCTION;
    public static final ForgeConfigSpec.ConfigValue<Double> WARHAMMER_HEAD_SLOWNESS;
    public static final ForgeConfigSpec.ConfigValue<Double> WARHAMMER_HEAD_SLOWNESS_DURATION;
    public static final ForgeConfigSpec.ConfigValue<Double> WARHAMMER_HEAD_BYPASS_CHANCE;
    public static final ForgeConfigSpec.ConfigValue<Double> SWORD_BLADE_MELEE_BLOCK;
    public static final ForgeConfigSpec.ConfigValue<Double> HANDLE_DAMAGE_MULTIPLIER;
    public static final ForgeConfigSpec.ConfigValue<Double> POMMEL_DAMAGE_MULTIPLIER;

    static {
        BUILDER.push("Mob essence");
        ALWAYS_CREATIVE_ESSENCE = BUILDER.comment("If true, mobs will always have a 100% chance of dropping their essence if killed by a player in creative mode.").define("Always drop essence in creative", true);
        ESSENCE_BONUS_ROLLS = BUILDER.comment("If true, mobs with higher HP will have a chance to drop multiple essence naturally without looting. These bonus rolls are separate from the bonus rolls you get from looting.").define("Grant more bonus rolls based on max HP", true);
        ESSENCE_BLACKLIST = BUILDER.comment("This is a list of entity IDs for which essence will never drop. For example, adding minecraft:creeper in this list will make creepers never drop creeper mob essence. Any mob from any mod can be added here.").defineList("Entity blacklist", List.of(" "), entry -> true);
        BUILDER.pop();
        BUILDER.push("Global multipliers");
        KIN_SLAYER = BUILDER.comment("This value determines how much extra percentage of damage a weapon part will make the weapon deal against the type of entity it was made with. This will be a fixed value set here unless an override is present in a datapack.").define("Kin slayer multiplier", (Object)33.0);
        DURABILITY_MULTIPLIER = BUILDER.comment("This is the value used to scale the durability of weapon parts based on the mob's maximum health, and can be tweaked to any value to adjust how much durability each of the weapon pieces procedurally gain. Each weapon piece of any entity can have specific values set to it through datapacks, but this applies to anything that does not have specific values set.").define("Durability multiplier", (Object)35.0);
        ATTACK_SPEED_MULTIPLIER = BUILDER.comment("This is the value used to scale the attack speed of weapon parts based on the mob's movement speed, and can be tweaked to any value to adjust how much attack speed each of the weapon pieces procedurally gain. Each weapon piece of any entity can have specific values set to it through datapacks, but this applies to anything that does not have specific values set.").define("Attack speed multiplier", (Object)1.2);
        ATTACK_DAMAGE_MULTIPLIER = BUILDER.comment("This is the value used to scale the attack damage of weapon parts based on the mob's attack damage or other attributes if not present, and can be tweaked to any value to adjust how much attack damage each of the weapon pieces procedurally gain. Each weapon piece of any entity can have specific values set to it through datapacks, but this applies to anything that does not have specific values set.").define("Attack damage multiplier", (Object)1.2);
        BUILDER.pop();
        BUILDER.push("Weapon part abilities");
        AXE_HEAD_DAMAGE = BUILDER.comment("This determines how much the axe head weapon part aplifies the attack damage of the weapon. Each 0.1 counts for 10% more attack damage. If a specific axe head's stats are overwritten with a datapack, this multiplier does not apply. This multiplier is then divided by 2 and applied negatively on the attack speed of the weapon part.").define("Axe head damage multiplier", (Object)0.4);
        HOOK_HANDLE_CHANCE = BUILDER.comment("This determines how likely the hook handle's ability is to trigger when attacking. The maximum value is 1 for 1% and 100 for 100%.").define("Hook handle ability chance", (Object)20.0);
        HOOK_HANDLE_COOLDOWN = BUILDER.comment("This value determines for how many ticks the hook handle ability disables player weapons. Every 20 ticks counts for 1 second.").define("Hook handle player cooldown", (Object)40.0);
        GREATSWORD_HANDLE_NEGATION_CHANCE = BUILDER.comment("This determines how likely the greatsword handle is to negate damage when attacked. The minimum value is 0 for 0% and maximum value 100 for 100% if you want to be god for some reason.").define("Greatsword handle damage negation chance", (Object)15.0);
        HALBERD_HEAD_DAMAGE = BUILDER.comment("This determines how much the halberd head weapon part aplifies the attack damage of the weapon. Each 0.1 counts for 10% more attack damage. If a specific halberd head's stats are overwritten with a datapack, this multiplier does not apply. This multiplier is then applied negatively on the attack speed of the weapon part.").define("Halberd head damage multiplier", (Object)0.2);
        HALBERD_ENTITY_REACH = BUILDER.comment("This determines how much the halberd head weapon part increases the entity reach of the weapon. If a specific halberd head's stats are overwritten with a datapack, this value does not apply.").define("Halberd head entity reach bonus", (Object)0.5);
        HOOK_POMMEL_CHANCE = BUILDER.comment("This determines how likely the hook pommel's ability is to trigger when getting attacked. The maximum value is 1 for 1% and 100 for 100%.").define("Hook pommel ability chance", (Object)20.0);
        HOOK_POMMEL_COOLDOWN = BUILDER.comment("This value determines for how many ticks the hook pommel ability disables player weapons. Every 20 ticks counts for 1 second.").define("Hook pommel player cooldown", (Object)40.0);
        MACE_HEAD_SPEED_MODIFIER = BUILDER.comment("This value determines by how much a mace head reduces the weapon part's attack speed bonus. Each 0.1 counts for 10%. Max is 1 for 100% and min is 0 for 0%. If a datapack overwrites this weapon part's stats then this multiplier does not apply.").define("Mace head attack speed reduction multiplier", (Object)0.75);
        MACE_HEAD_CRITICAL_MULTIPLIER = BUILDER.comment("This value determines how much a mace head will multiply critical hit damage. Each 0.1 counts for 10%. Minimum is 0 for 0% and 1 for 100%.").define("Mace head critical hit multiplier", (Object)0.35);
        PIKE_HEAD_ARMOR_DAMAGE = BUILDER.comment("This value determines how much each piece of armor will reduce damage dealt by weapons using a pike head. Each 0.1 counts for 10%. Minimum is 0 for 0% and maximum is 1 for 100%.").define("Pike head armor damage reduction", (Object)0.05);
        PIKE_HEAD_ATTACK_SPEED = BUILDER.comment("This determines how much the pike head weapon part aplifies the attack speed of the weapon. Each 0.1 counts for 10% more attack speed. If a specific pike head's stats are overwritten with a datapack, this multiplier does not apply. This multiplier is then divided by 2 and applied negatively on the attack damage of the weapon part.").define("Axe head attack speed multiplier", (Object)0.25);
        RAPIER_HANDLE_DAMAGE_NEGATION = BUILDER.comment("This determines how much damage the rapier handle negates while the weapon is held. Each 0.1 counts for 10%. The minimum value is 0 for 0% and maximum value 1 for 100% if you want to be god for some reason.").define("Rapier handle damage negation", (Object)0.1);
        SABER_BLADE_DAMAGE_REDUCTION = BUILDER.comment("This determines how much the saber blade's attack damage is reduced. Each 0.1 counts for 10%. The minimum value is 0 for 0% and maximum value 1 for 100%.").define("Saber blade damage reduction", (Object)0.15);
        SCYTHE_HEAD_DAMAGE_REDUCTION = BUILDER.comment("This value determines by how much a scythe head reduces the weapon part's attack damage bonus. Each 0.1 counts for 10%. Max is 1 for 100% and min is 0 for 0%. If a datapack overwrites this weapon part's stats then this multiplier does not apply.").define("Scythe head damage reduction", (Object)0.3);
        SERRADED_BLADE_DURATION = BUILDER.comment("This value determines for how many ticks the serraded blade's DOT effect lasts on its victims. Each 20 ticks count for 1 second.").define("Serraded blade DOT duration", (Object)80.0);
        SERRADED_BLADE_DAMAGE = BUILDER.comment("This value determines what percentage of the damage of the weapon the DOT effect of the serraded blade will deal for every damage tick. Each 0.1 counts for 10% of the dealt damage which bypasses armor and enchantments. Minimum is 0 for 0% and maximum is 1 for 100%.").define("Serraded blade DOT damage", (Object)0.25);
        SPIKED_HANDLE_DURATION = BUILDER.comment("This value determines for how many ticks the spiked handle's DOT effect lasts on its victims. Each 20 ticks count for 1 second.").define("Spiked handle DOT duration", (Object)40.0);
        SPIKED_HANDLE_DAMAGE = BUILDER.comment("This value determines what percentage of the damage of the weapon the DOT effect of the spiked handle will deal for every damage tick. Each 0.1 counts for 10% of the dealt damage which bypasses armor and enchantments. Minimum is 0 for 0% and maximum is 1 for 100%.").define("Spiked handle DOT damage", (Object)0.15);
        SPIKED_POMMEL_PIERCING_DAMAGE = BUILDER.comment("This value determines how much of the damage dealt with a weapon that has a spiked pommel will penetrate through all protection. Each 0.1 counts for 10%. The minimum is 0 for 0% and the maximum is 1 for 100%.").define("Spiked pommel piercing damage", (Object)0.2);
        TWOHANDED_POMMEL_REACH = BUILDER.comment("This determines how much the two-handed pommel weapon part increases the entity reach of the weapon. If a specific two-handed pommel's stats are overwritten with a datapack, this value does not apply.").define("Two-handed pommel entity reach bonus", (Object)0.5);
        TWOHANDED_POMMEL_SPEED_REDUCTION = BUILDER.comment("This value determines by how much a two-handed pommel reduces the weapon part's attack speed bonus. Each 0.1 counts for 10%. Max is 1 for 100% and min is 0 for 0%. If a datapack overwrites this weapon part's stats then this multiplier does not apply.").define("Two-handed pommel attack speed reduction", (Object)0.2);
        WARHAMMER_HEAD_SLOWNESS = BUILDER.comment("This value determines what level of the slowness effect weapons with the warhammer head weapon part will inflict when attacking. Minimum is 0 and maximum is whatever you feel like.").define("Warhammer head slowness level", (Object)2.0);
        WARHAMMER_HEAD_SLOWNESS_DURATION = BUILDER.comment("This value determines for how many ticks a warhammer head's slowness effect will last. Each 20 ticks represent one second. Minimum is 0 and maximum is whatever you feel like.").define("Warhammer head slowness duration", (Object)80.0);
        WARHAMMER_HEAD_BYPASS_CHANCE = BUILDER.comment("This value determines how likely a weapon using the warhammer head is to bypass all damage resistance when attacking. Each 0.1 counts for 10%. Minimum is 0 for 0% and maximum is 1 for 100%.").define("Warhammer head resistance bypass chance", (Object)0.4);
        SWORD_BLADE_MELEE_BLOCK = BUILDER.comment("This value determines how much melee damage a weapon using a sword blade is able to block when using the shield ability. Each 0.1 counts for 10%. The minimum is 0 for 0% and the maximum is 1 for 100%.").define("Sword blade blocked melee damage", (Object)0.5);
        HANDLE_DAMAGE_MULTIPLIER = BUILDER.comment("This value determines how much the regular handle's damage is multiplied. Each 0.1 counts for 10%. Minimum is 0 for 0% and maximum is 1 for 100%. If a datapack overwrites this weapon part's stats then this multiplier does not apply.").define("Regular handle damage multiplier", (Object)0.1);
        POMMEL_DAMAGE_MULTIPLIER = BUILDER.comment("This value determines how much the regular pommel's damage is multiplied. Each 0.1 counts for 10%. Minimum is 0 for 0% and maximum is 1 for 100%. If a datapack overwrites this weapon part's stats then this multiplier does not apply.").define("Regular pommel damage multiplier", (Object)0.1);
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

