/*
 * Decompiled with CFR 0.152.
 */
package com.bobvarioa.buildingpacks;

import com.bobvarioa.buildingpacks.BlockPack;
import com.bobvarioa.buildingpacks.capabilty.BuildingPowerEvents;
import com.bobvarioa.buildingpacks.compat.kubejs.BuildingPacksKubeJS;
import com.bobvarioa.buildingpacks.item.BlockPackItem;
import com.bobvarioa.buildingpacks.item.templates.InventoryListener;
import com.bobvarioa.buildingpacks.register.ModBlockEntities;
import com.bobvarioa.buildingpacks.register.ModBlocks;
import com.bobvarioa.buildingpacks.register.ModItems;
import com.bobvarioa.buildingpacks.register.ModPackets;
import com.mojang.logging.LogUtils;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.NewRegistryEvent;
import net.minecraftforge.registries.RegisterEvent;
import net.minecraftforge.registries.RegistryBuilder;
import net.minecraftforge.registries.RegistryObject;
import org.slf4j.Logger;

@Mod(value="buildingpacks")
public class BuildingPacks {
    public static final String MODID = "buildingpacks";
    private static final Logger LOGGER = LogUtils.getLogger();
    public static IForgeRegistry<BlockPack> BLOCK_PACKS;
    public static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS;
    public static final RegistryObject<CreativeModeTab> BUILDING_PACKS_TAB;
    private static ResourceKey<Registry<BlockPack>> BLOCK_PACK_REGISTRY_KEY;

    private static ItemStack blockPackOf(ResourceLocation id) {
        ItemStack item = new ItemStack((ItemLike)ModItems.REG_BLOCK_PACK.get());
        CompoundTag tag = item.m_41784_();
        if (id == null) {
            return item;
        }
        tag.m_128359_("id", id.toString());
        BlockPack blockPack = (BlockPack)BLOCK_PACKS.getValue(id);
        if (blockPack == null) {
            return item;
        }
        tag.m_128405_("material", blockPack.getMaxMaterial());
        return item;
    }

    public BuildingPacks() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(this::createRegistry);
        bus.addListener(this::onRegister);
        bus.addListener(ModPackets::commonSetup);
        ModItems.register(bus);
        ModBlocks.register(bus);
        ModBlockEntities.register(bus);
        CREATIVE_MODE_TABS.register(bus);
        MinecraftForge.EVENT_BUS.addGenericListener(Entity.class, BuildingPowerEvents::attachCaps);
        MinecraftForge.EVENT_BUS.addListener(BlockPackItem::pickupItem);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.LOWEST, InventoryListener::onEnterInventory);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.LOWEST, InventoryListener::onLeaveInventory);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.LOWEST, InventoryListener::onPlayerClone);
    }

    private void createRegistry(NewRegistryEvent event) {
        RegistryBuilder builder = new RegistryBuilder();
        builder.setName(new ResourceLocation("buildingpacks:block_packs"));
        event.create(builder, reg -> {
            BLOCK_PACKS = reg;
        });
    }

    private static Block getBlock(String id, String namespace) {
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(namespace, id));
        if (block == null) {
            LOGGER.error(namespace + ":" + id + " does not exist!");
        }
        return block;
    }

    private void onRegister(RegisterEvent event) {
        event.register(BLOCK_PACK_REGISTRY_KEY, helper -> {
            PackBuilder.createWood((RegisterEvent.RegisterHelper<BlockPack>)helper, "oak");
            PackBuilder.createWood((RegisterEvent.RegisterHelper<BlockPack>)helper, "spruce");
            PackBuilder.createWood((RegisterEvent.RegisterHelper<BlockPack>)helper, "acacia");
            PackBuilder.createWood((RegisterEvent.RegisterHelper<BlockPack>)helper, "birch");
            PackBuilder.createWood((RegisterEvent.RegisterHelper<BlockPack>)helper, "dark_oak");
            PackBuilder.createWood((RegisterEvent.RegisterHelper<BlockPack>)helper, "jungle");
            PackBuilder.createWood((RegisterEvent.RegisterHelper<BlockPack>)helper, "mangrove");
            PackBuilder.createWood((RegisterEvent.RegisterHelper<BlockPack>)helper, "cherry");
            PackBuilder.createWood((RegisterEvent.RegisterHelper<BlockPack>)helper, "crimson", true);
            PackBuilder.createWood((RegisterEvent.RegisterHelper<BlockPack>)helper, "warped", true);
            PackBuilder.create("bamboo", 256).put("bamboo_block", 2.0f, true).put("bamboo_planks", 1.0f).wallSlabStairs("bamboo", true).pressurePlate("bamboo").button("bamboo").put("bamboo_door", 2.0f).put("bamboo_sign", 2.2f).put("bamboo_trapdoor", 3.0f).build((RegisterEvent.RegisterHelper<BlockPack>)helper);
            PackBuilder.create("stone", 256).put("stone", 1.0f).slabStairs("stone").pressurePlate("stone").button("stone").put("stone_bricks", 1.0f).wallSlabStairs("stone_brick", false).put("chiseled_stone_bricks", 1.0f).put("smooth_stone", 1.0f).put("smooth_stone_slab", 0.5f).build((RegisterEvent.RegisterHelper<BlockPack>)helper);
            PackBuilder.create("deepslate", 256).put("deepslate", 1.0f).put("deepslate_bricks", 1.0f).wallSlabStairs("deepslate_brick", false).put("deepslate_tiles", 1.0f).wallSlabStairs("deepslate_tile", false).put("cobbled_deepslate", 1.0f).wallSlabStairs("cobbled_deepslate", false).put("polished_deepslate", 1.0f).slabStairs("polished_deepslate").createModStoneAdditions("deepslate").build((RegisterEvent.RegisterHelper<BlockPack>)helper);
            PackBuilder.createWallSlabStairs((RegisterEvent.RegisterHelper<BlockPack>)helper, "cobblestone", false);
            PackBuilder.create("blackstone", 256).put("blackstone", 1.0f).slabStairs("blackstone").put("polished_blackstone", 1.0f).put("chiseled_polished_blackstone", 1.0f).wallSlabStairs("polished_blackstone", false).button("polished_blackstone").pressurePlate("polished_blackstone").put("polished_blackstone_bricks", 1.0f).put("cracked_polished_blackstone_bricks", 1.0f).wallSlabStairs("polished_blackstone_brick", false).build((RegisterEvent.RegisterHelper<BlockPack>)helper);
            PackBuilder.create("end_stone", 256).put("end_stone", 1.0f).put("end_stone_bricks", 1.0f).wallSlabStairs("end_stone_brick", false).build((RegisterEvent.RegisterHelper<BlockPack>)helper);
            PackBuilder.createStone((RegisterEvent.RegisterHelper<BlockPack>)helper, "granite", true);
            PackBuilder.createStone((RegisterEvent.RegisterHelper<BlockPack>)helper, "diorite", true);
            PackBuilder.createStone((RegisterEvent.RegisterHelper<BlockPack>)helper, "andesite", true);
            PackBuilder.create("netherbrick", 256).put("nether_bricks", 1.0f).wallSlabStairs("nether_brick", false).put("nether_brick_fence", 1.7f).put("chiseled_nether_bricks", 1.0f).put("cracked_nether_bricks", 1.0f).build((RegisterEvent.RegisterHelper<BlockPack>)helper);
            PackBuilder.createWallSlabStairs((RegisterEvent.RegisterHelper<BlockPack>)helper, "red_nether_brick", true);
            PackBuilder.create("sandstone", 256).put("sandstone", 1.0f).wallSlabStairs("sandstone", false).put("cut_sandstone", 1.0f).put("cut_sandstone_slab", 0.5f).put("chiseled_sandstone", 1.0f).build((RegisterEvent.RegisterHelper<BlockPack>)helper);
            PackBuilder.create("red_sandstone", 256).put("red_sandstone", 1.0f).wallSlabStairs("red_sandstone", false).put("cut_red_sandstone", 1.0f).put("cut_red_sandstone_slab", 0.5f).put("chiseled_red_sandstone", 1.0f).build((RegisterEvent.RegisterHelper<BlockPack>)helper);
            PackBuilder.create("quartz", 256).put("quartz_block", 1.0f).slabStairs("quartz").put("quartz_bricks", 1.0f).put("quartz_pillar", 1.0f).put("smooth_quartz", 1.0f).slabStairs("smooth_quartz").put("chiseled_quartz_block", 1.0f).build((RegisterEvent.RegisterHelper<BlockPack>)helper);
            PackBuilder.create("purpur", 256).put("purpur_block", 1.0f).put("purpur_pillar", 1.0f).slabStairs("purpur").build((RegisterEvent.RegisterHelper<BlockPack>)helper);
            PackBuilder.createWallSlabStairs((RegisterEvent.RegisterHelper<BlockPack>)helper, "prismarine", false);
            PackBuilder.createSlabStairs((RegisterEvent.RegisterHelper<BlockPack>)helper, "prismarine_brick", true);
            PackBuilder.createSlabStairs((RegisterEvent.RegisterHelper<BlockPack>)helper, "dark_prismarine", false);
            PackBuilder.create("mud", 256).put("mud_bricks", 1.0f).put("packed_mud", 1.0f).wallSlabStairs("mud_brick", false).build((RegisterEvent.RegisterHelper<BlockPack>)helper);
            if (ModList.get().isLoaded("biomesoplenty")) {
                PackBuilder.namespace = "biomesoplenty";
                PackBuilder.createWood((RegisterEvent.RegisterHelper<BlockPack>)helper, "fir");
                PackBuilder.createWood((RegisterEvent.RegisterHelper<BlockPack>)helper, "redwood");
                PackBuilder.createWood((RegisterEvent.RegisterHelper<BlockPack>)helper, "mahogany");
                PackBuilder.createWood((RegisterEvent.RegisterHelper<BlockPack>)helper, "palm");
                PackBuilder.createWood((RegisterEvent.RegisterHelper<BlockPack>)helper, "willow");
                PackBuilder.createWood((RegisterEvent.RegisterHelper<BlockPack>)helper, "dead");
                PackBuilder.createWood((RegisterEvent.RegisterHelper<BlockPack>)helper, "jacaranda");
                PackBuilder.createWood((RegisterEvent.RegisterHelper<BlockPack>)helper, "magic");
                PackBuilder.createWood((RegisterEvent.RegisterHelper<BlockPack>)helper, "umbran");
                PackBuilder.createWood((RegisterEvent.RegisterHelper<BlockPack>)helper, "hellbark");
                PackBuilder.create("white_sandstone", 256).put("white_sandstone", 1.0f).wallSlabStairs("white_sandstone", false).put("cut_white_sandstone", 1.0f).put("cut_white_sandstone_slab", 0.5f).put("chiseled_white_sandstone", 1.0f).build((RegisterEvent.RegisterHelper<BlockPack>)helper);
                PackBuilder.create("black_sandstone", 256).put("black_sandstone", 1.0f).wallSlabStairs("black_sandstone", false).put("cut_black_sandstone", 1.0f).put("cut_black_sandstone_slab", 0.5f).put("chiseled_black_sandstone", 1.0f).build((RegisterEvent.RegisterHelper<BlockPack>)helper);
                PackBuilder.create("brimstone", 256).put("brimstone_bricks", 1.0f).wallSlabStairs("brimstone_brick", false).put("chiseled_brimstone_bricks", 1.0f).build((RegisterEvent.RegisterHelper<BlockPack>)helper);
            }
            if (ModList.get().isLoaded("create")) {
                PackBuilder.namespace = "create";
                PackBuilder.createStoneCreate((RegisterEvent.RegisterHelper<BlockPack>)helper, "veridium");
                PackBuilder.createStoneCreate((RegisterEvent.RegisterHelper<BlockPack>)helper, "scorchia");
                PackBuilder.createStoneCreate((RegisterEvent.RegisterHelper<BlockPack>)helper, "ochrum");
                PackBuilder.createStoneCreate((RegisterEvent.RegisterHelper<BlockPack>)helper, "crimsite");
                PackBuilder.createStoneCreate((RegisterEvent.RegisterHelper<BlockPack>)helper, "limestone");
                PackBuilder.createStoneCreate((RegisterEvent.RegisterHelper<BlockPack>)helper, "asurine");
                PackBuilder.create("calcite", 256).put("minecraft", "calcite", 1.0f).createModStoneAdditions("calcite").build((RegisterEvent.RegisterHelper<BlockPack>)helper);
                PackBuilder.create("dripstone", 256).put("minecraft", "dripstone_block", 1.0f).createModStoneAdditions("dripstone").build((RegisterEvent.RegisterHelper<BlockPack>)helper);
                PackBuilder.create("tuff", 256).put("minecraft", "tuff", 1.0f).createModStoneAdditions("tuff").build((RegisterEvent.RegisterHelper<BlockPack>)helper);
            }
            if (ModList.get().isLoaded("arsnouveau")) {
                PackBuilder.namespace = "arsnouveau";
                PackBuilder.createWood((RegisterEvent.RegisterHelper<BlockPack>)helper, "archwood");
            }
            if (ModList.get().isLoaded("tconstruct")) {
                PackBuilder.namespace = "tconstruct";
                PackBuilder.createTConstructWood((RegisterEvent.RegisterHelper<BlockPack>)helper, "greenheart");
                PackBuilder.createTConstructWood((RegisterEvent.RegisterHelper<BlockPack>)helper, "skyroot");
                PackBuilder.createTConstructWood((RegisterEvent.RegisterHelper<BlockPack>)helper, "bloodshroom");
                PackBuilder.createTConstructWood((RegisterEvent.RegisterHelper<BlockPack>)helper, "enderbark");
                PackBuilder.create("seared", 256).put("seared_stone", 1.0f).slabStairs("seared_stone").wallSlabStairs("seared_bricks", false).put("seared_cracked_bricks", 1.0f).put("seared_fancy_bricks", 1.0f).put("seared_triangle_bricks", 1.0f).put("seared_cobble", 1.0f).wallSlabStairs("seared_cobble", false).put("seared_paver", 1.0f).slabStairs("seared_paver").put("seared_ladder", 1.0f).build((RegisterEvent.RegisterHelper<BlockPack>)helper);
                PackBuilder.create("scorched", 256).put("scorched_stone", 1.0f).put("polished_scorched_stone", 1.0f).put("scorched_bricks", 1.0f).slabStairs("scorched_bricks").put("scorched_bricks_fence", 1.7f).put("chiseled_scorched_bricks", 1.0f).put("scorched_road", 1.0f).slabStairs("scorched_road").put("scorched_ladder", 1.0f).build((RegisterEvent.RegisterHelper<BlockPack>)helper);
            }
            if (ModList.get().isLoaded("kubejs")) {
                BuildingPacksKubeJS.load((RegisterEvent.RegisterHelper<BlockPack>)helper);
            }
        });
    }

    static {
        CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.f_279569_, (String)MODID);
        BUILDING_PACKS_TAB = CREATIVE_MODE_TABS.register("block_packs", () -> CreativeModeTab.builder().withTabsBefore(new ResourceKey[]{CreativeModeTabs.f_256797_}).m_257737_(() -> BuildingPacks.blockPackOf(new ResourceLocation("minecraft", "oak"))).m_257501_((parameters, output) -> {
            output.m_246326_((ItemLike)ModItems.WRENCH.get());
            BlockPack.blockPacks.forEach(key -> output.m_246342_(BuildingPacks.blockPackOf(key.id)));
        }).m_257941_((Component)Component.m_237115_((String)"creative.block_packs")).m_257652_());
        BLOCK_PACK_REGISTRY_KEY = ResourceKey.m_135788_((ResourceLocation)new ResourceLocation(MODID, "block_packs"));
    }

    public static class PackBuilder {
        public static String namespace = "minecraft";
        public BlockPack blockPack;

        PackBuilder() {
        }

        public static PackBuilder create(String id, int material) {
            PackBuilder pack = new PackBuilder();
            pack.blockPack = new BlockPack(material, new ResourceLocation(namespace, id));
            return pack;
        }

        public PackBuilder slabStairs(String type) {
            this.put(type + "_stairs", 1.0f);
            this.put(type + "_slab", 0.5f);
            return this;
        }

        public PackBuilder wallSlabStairs(String type, boolean isFence) {
            this.slabStairs(type);
            if (isFence) {
                this.put(type + "_fence", 1.7f);
                this.put(type + "_fence_gate", 4.0f);
            } else {
                this.put(type + "_wall", 1.0f);
            }
            return this;
        }

        public PackBuilder pressurePlate(String type) {
            this.put(type + "_pressure_plate", 2.0f);
            return this;
        }

        public PackBuilder button(String type) {
            this.put(type + "_button", 1.0f);
            return this;
        }

        public PackBuilder createModStoneAdditions(String type) {
            if (ModList.get().isLoaded("create")) {
                String oldNamespace = namespace;
                namespace = "create";
                this.put("cut_" + type, 1.0f).wallSlabStairs("cut_" + type, false).put("polished_cut_" + type, 1.0f).wallSlabStairs("polished_cut_" + type, false).put("cut_" + type + "_bricks", 1.0f).wallSlabStairs("cut_" + type + "_brick", false).put("small_" + type + "_bricks", 1.0f).wallSlabStairs("small_" + type + "_brick", false).put("layered_" + type, 1.0f).put(type + "_pillar", 1.0f);
                namespace = oldNamespace;
            }
            return this;
        }

        public PackBuilder put(String str, float material) {
            this.blockPack.put(BuildingPacks.getBlock(str, namespace), material);
            return this;
        }

        public PackBuilder put(String namespace, String str, float material) {
            this.blockPack.put(BuildingPacks.getBlock(str, namespace), material);
            return this;
        }

        public PackBuilder put(String str, float material, boolean acceptOnly) {
            this.blockPack.put(BuildingPacks.getBlock(str, namespace), material, acceptOnly);
            return this;
        }

        public BlockPack build(RegisterEvent.RegisterHelper<BlockPack> helper) {
            helper.register(this.blockPack.id, (Object)this.blockPack);
            return this.blockPack;
        }

        public static BlockPack createWood(RegisterEvent.RegisterHelper<BlockPack> helper, String type) {
            return PackBuilder.createWood(helper, type, false);
        }

        public static BlockPack createWood(RegisterEvent.RegisterHelper<BlockPack> helper, String type, boolean isNether) {
            PackBuilder pack = PackBuilder.create(type, 256);
            pack.put(type + "_planks", 1.0f);
            pack.wallSlabStairs(type, true).pressurePlate(type).button(type).put(type + "_door", 2.0f).put(type + "_sign", 2.2f).put(type + "_trapdoor", 3.0f);
            return pack.build(helper);
        }

        public static BlockPack createTConstructWood(RegisterEvent.RegisterHelper<BlockPack> helper, String type) {
            PackBuilder pack = PackBuilder.create(type, 256);
            pack.put(type + "_planks", 1.0f).slabStairs(type + "_planks").pressurePlate(type).button(type).put(type + "_door", 2.0f).put(type + "_sign", 2.2f).put(type + "_trapdoor", 3.0f).put(type + "_fence", 1.7f).put(type + "_fence_gate", 4.0f);
            return pack.build(helper);
        }

        public static BlockPack createStone(RegisterEvent.RegisterHelper<BlockPack> helper, String type, boolean hasCreate) {
            PackBuilder pack = PackBuilder.create(type, 256).put(type, 1.0f).wallSlabStairs(type, false).put("polished_" + type, 1.0f).slabStairs("polished_" + type);
            if (hasCreate) {
                pack.createModStoneAdditions(type);
            }
            return pack.build(helper);
        }

        public static BlockPack createStoneCreate(RegisterEvent.RegisterHelper<BlockPack> helper, String type) {
            return PackBuilder.create(type, 256).put(type, 1.0f).createModStoneAdditions(type).build(helper);
        }

        public static BlockPack createWallSlabStairs(RegisterEvent.RegisterHelper<BlockPack> helper, String type, boolean addS) {
            return PackBuilder.create(type, 256).put(type + (addS ? "s" : ""), 1.0f).wallSlabStairs(type, false).build(helper);
        }

        public static BlockPack createSlabStairs(RegisterEvent.RegisterHelper<BlockPack> helper, String type, boolean addS) {
            return PackBuilder.create(type, 256).put(type + (addS ? "s" : ""), 1.0f).slabStairs(type).build(helper);
        }
    }
}

