/*
 * Decompiled with CFR 0.152.
 */
package com.bobvarioa.buildingpacks.capabilty;

import com.bobvarioa.buildingpacks.capabilty.BuildingPower;
import com.bobvarioa.buildingpacks.capabilty.IBuildingPowersHandler;
import com.bobvarioa.buildingpacks.network.PowerUpdatePacket;
import com.bobvarioa.buildingpacks.register.ModCaps;
import com.bobvarioa.buildingpacks.register.ModPackets;
import java.util.EnumMap;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildingPowerEvents {
    public static void attachCaps(AttachCapabilitiesEvent<Entity> event) {
        Object object = event.getObject();
        if (object instanceof Player) {
            final Player player = (Player)object;
            event.addCapability(IBuildingPowersHandler.ID, new ICapabilityProvider(){
                LazyOptional<IBuildingPowersHandler> powers = LazyOptional.of(() -> new IBuildingPowersHandler(){
                    private EnumMap<BuildingPower, Boolean> map = new EnumMap(BuildingPower.class);

                    @Override
                    public boolean hasPower(BuildingPower power) {
                        return this.map.getOrDefault((Object)power, false);
                    }

                    @Override
                    public void setPower(BuildingPower power, boolean enabled) {
                        if (this.map.getOrDefault((Object)power, false) == enabled) {
                            return;
                        }
                        this.map.put(power, enabled);
                        if (!player.m_9236_().f_46443_) {
                            ModPackets.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new PowerUpdatePacket(power, enabled));
                        }
                    }
                });

                @NotNull
                public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
                    return ModCaps.BUILDING_POWERS.orEmpty(cap, this.powers);
                }
            });
        }
    }
}

