/*
 * Decompiled with CFR 0.152.
 */
package com.bobvarioa.buildingpacks.client;

import com.bobvarioa.buildingpacks.BlockPack;
import com.bobvarioa.buildingpacks.block.entity.TemplateBlockEntity;
import com.bobvarioa.buildingpacks.capabilty.BuildingPower;
import com.bobvarioa.buildingpacks.capabilty.IBuildingPowersHandler;
import com.bobvarioa.buildingpacks.client.screens.BlockPackGuiOverlay;
import com.bobvarioa.buildingpacks.item.BlockPackItem;
import com.bobvarioa.buildingpacks.network.BreakBlockPacket;
import com.bobvarioa.buildingpacks.network.DropItemPacket;
import com.bobvarioa.buildingpacks.network.IndexUpdatePacket;
import com.bobvarioa.buildingpacks.register.ModBlocks;
import com.bobvarioa.buildingpacks.register.ModCaps;
import com.bobvarioa.buildingpacks.register.ModItems;
import com.bobvarioa.buildingpacks.register.ModPackets;
import com.bobvarioa.buildingpacks.utils.WorldUtils;
import com.firemerald.additionalplacements.block.AdditionalPlacementBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;
import nl.requios.effortlessbuilding.EffortlessBuildingClient;
import nl.requios.effortlessbuilding.buildmode.BuildModeEnum;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="buildingpacks", bus=Mod.EventBusSubscriber.Bus.FORGE)
@OnlyIn(value=Dist.CLIENT)
public class ClientEvents {
    public static boolean blockPackOpen = false;
    private static ResourceLocation HOTBAR = new ResourceLocation("minecraft", "hotbar");

    @SubscribeEvent
    public static void handleScroll(InputEvent.MouseScrollingEvent event) {
        int sign = (int)Math.signum(event.getScrollDelta());
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        Options options = Minecraft.m_91087_().f_91066_;
        if (player == null) {
            return;
        }
        ItemStack stack = player.m_21205_();
        if (stack.m_41720_() instanceof BlockPackItem) {
            if (!blockPackOpen && !options.f_92090_.m_90857_()) {
                return;
            }
            CompoundTag tag = stack.m_41784_();
            int index = tag.m_128451_("index");
            if (sign > 0) {
                if (--index < 0) {
                    index = BlockPackItem.getData(stack).length() - 1;
                }
            } else if (sign < 0 && ++index >= BlockPackItem.getData(stack).length()) {
                index = 0;
            }
            if (sign != 0) {
                tag.m_128405_("index", index);
                ModPackets.INSTANCE.send(PacketDistributor.SERVER.noArg(), (Object)new IndexUpdatePacket(index));
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void pickBlock(InputEvent.InteractionKeyMappingTriggered event) {
        HitResult hitResult;
        HitResult.Type hitresult$type;
        if (!event.isPickBlock()) {
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        ItemStack stack = player.m_21205_();
        if (stack.m_41720_() instanceof BlockPackItem) {
            CompoundTag tag = stack.m_41784_();
            HitResult hitResult2 = Minecraft.m_91087_().f_91077_;
            HitResult.Type hitresult$type2 = hitResult2.m_6662_();
            if (hitresult$type2 == HitResult.Type.BLOCK) {
                BlockPos blockpos = ((BlockHitResult)hitResult2).m_82425_();
                Level level = player.m_9236_();
                BlockState blockstate = level.m_8055_(blockpos);
                if (blockstate.m_60795_()) {
                    return;
                }
                Block block = WorldUtils.getRealBlock(level, blockpos, blockstate.m_60734_());
                Inventory inventory = player.m_150109_();
                for (int i = 0; i < inventory.f_35974_.size(); ++i) {
                    BlockPack data;
                    int index;
                    ItemStack itemStack = (ItemStack)inventory.f_35974_.get(i);
                    if (!Inventory.m_36045_((int)i) || !(itemStack.m_41720_() instanceof BlockPackItem) || (index = (data = BlockPackItem.getData(itemStack)).getBlockIndex(block)) == -1) continue;
                    inventory.f_35977_ = i;
                    tag.m_128405_("index", index);
                    ModPackets.INSTANCE.send(PacketDistributor.SERVER.noArg(), (Object)new IndexUpdatePacket(index));
                    event.setCanceled(true);
                    break;
                }
            }
        }
        if (stack.m_150930_((Item)ModItems.DRAFTING_PENCIL.get()) && (hitresult$type = (hitResult = Minecraft.m_91087_().f_91077_).m_6662_()) == HitResult.Type.BLOCK) {
            BlockEntity blockEntity;
            BlockPos blockpos = ((BlockHitResult)hitResult).m_82425_();
            Level level = player.m_9236_();
            BlockState blockstate = level.m_8055_(blockpos);
            if (blockstate.m_60795_()) {
                return;
            }
            Block block = blockstate.m_60734_();
            if (block.equals(ModBlocks.TEMPLATE_BLOCK.get()) && (blockEntity = level.m_7702_(blockpos)) instanceof TemplateBlockEntity) {
                TemplateBlockEntity be = (TemplateBlockEntity)blockEntity;
                block = be.blockState.m_60734_();
            }
            if (ModList.get().isLoaded("additionalplacements") && block instanceof AdditionalPlacementBlock) {
                AdditionalPlacementBlock apb = (AdditionalPlacementBlock)block;
                block = apb.parentBlock;
            }
        }
    }

    @SubscribeEvent
    public static void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        Player player = event.getEntity();
        if (!player.m_9236_().f_46443_) {
            return;
        }
        ItemStack stack = event.getItemStack();
        Item item = stack.m_41720_();
        if (item instanceof BlockPackItem) {
            BuildModeEnum buildMode;
            BlockPackItem bpi = (BlockPackItem)item;
            if (player.m_36335_().m_41519_((Item)bpi)) {
                return;
            }
            if (ModList.get().isLoaded("effortlessbuilding") && (buildMode = EffortlessBuildingClient.BUILD_MODES.getBuildMode()) != BuildModeEnum.DISABLED) {
                player.m_36335_().m_41524_((Item)bpi, 5);
                return;
            }
            BlockPos pos = event.getPos();
            BlockPack data = BlockPackItem.getData(stack);
            float mat = bpi.getMaterial(stack);
            Level level = player.m_9236_();
            BlockState blockState = level.m_8055_(pos);
            Block block = WorldUtils.getBlock(blockState.m_60734_());
            float price = data.getPrice(block);
            if (price != -1.0f && (player.m_7500_() || mat + price <= (float)data.getMaxMaterial())) {
                level.m_46961_(pos, false);
                bpi.addMaterial(stack, price);
                ModPackets.INSTANCE.send(PacketDistributor.SERVER.noArg(), (Object)new BreakBlockPacket(pos, price));
                event.setCanceled(true);
                player.m_36335_().m_41524_((Item)bpi, 5);
            }
        }
    }

    @SubscribeEvent
    public static void onRightClickWithItem(PlayerInteractEvent.RightClickItem event) {
        Item item;
        Player player = event.getEntity();
        if (!player.m_9236_().f_46443_) {
            return;
        }
        Options options = Minecraft.m_91087_().f_91066_;
        ItemStack stack = event.getItemStack();
        if (options.f_92090_.m_90857_() && (item = stack.m_41720_()) instanceof BlockPackItem) {
            BlockPackItem bpi = (BlockPackItem)item;
            event.setCanceled(true);
            blockPackOpen = !blockPackOpen;
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onKey(InputEvent.Key event) {
        Item item;
        Options options = Minecraft.m_91087_().f_91066_;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        ItemStack stack = player.m_21205_();
        if (!player.m_5833_() && (item = stack.m_41720_()) instanceof BlockPackItem) {
            BlockPackItem bpi = (BlockPackItem)item;
            CompoundTag tag = stack.m_41783_();
            BlockPack data = BlockPackItem.getData(stack);
            if (tag != null && data != null) {
                int index = tag.m_128451_("index");
                float mat = bpi.getMaterial(stack);
                Block block = data.getBlock(index);
                float price = data.getPrice(block);
                if (options.f_92094_.m_90857_()) {
                    while (options.f_92094_.m_90859_()) {
                        int amount = Screen.m_96637_() ? 64 : 1;
                        if (mat - price * (float)(amount = Math.min(amount, (int)Math.floor(mat / price))) >= 0.0f) {
                            bpi.addMaterial(stack, -price * (float)amount);
                            player.m_6674_(InteractionHand.MAIN_HAND);
                            ModPackets.INSTANCE.send(PacketDistributor.SERVER.noArg(), (Object)new DropItemPacket(amount));
                            continue;
                        }
                        if (player.m_108700_(amount == 64)) continue;
                        player.m_6674_(InteractionHand.MAIN_HAND);
                    }
                }
                if (blockPackOpen) {
                    int len = options.f_92056_.length;
                    int min = index - 4;
                    int max = index + 4;
                    while (max > data.length() - 1) {
                        --max;
                        --min;
                    }
                    while (min < 0) {
                        ++min;
                        ++max;
                    }
                    for (int i = 0; i < len; ++i) {
                        if (!options.f_92056_[i].m_90859_()) continue;
                        tag.m_128405_("index", min + i);
                        ModPackets.INSTANCE.send(PacketDistributor.SERVER.noArg(), (Object)new IndexUpdatePacket(min + i));
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void preOverlayRendered(RenderGuiOverlayEvent.Pre event) {
        if (event.getOverlay().id().equals((Object)HOTBAR)) {
            LazyOptional cap;
            if (blockPackOpen) {
                event.setCanceled(true);
                return;
            }
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player != null && (cap = player.getCapability(ModCaps.BUILDING_POWERS)).isPresent() && ((IBuildingPowersHandler)cap.resolve().get()).hasPower(BuildingPower.DRAFTING_META)) {
                event.setCanceled(true);
            }
        }
    }

    @Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="buildingpacks", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ModEvents {
        @SubscribeEvent
        public static void registerGuiOverlays(RegisterGuiOverlaysEvent event) {
            event.registerAboveAll("block_pack", (IGuiOverlay)new BlockPackGuiOverlay());
        }
    }
}

