/*
 * Decompiled with CFR 0.152.
 */
package com.bobvarioa.buildingpacks.client.renderer;

import com.bobvarioa.buildingpacks.block.entity.TemplateBlockEntity;
import com.bobvarioa.buildingpacks.capabilty.BuildingPower;
import com.bobvarioa.buildingpacks.capabilty.IBuildingPowersHandler;
import com.bobvarioa.buildingpacks.register.ModBlockEntities;
import com.bobvarioa.buildingpacks.register.ModCaps;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterShadersEvent;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="buildingpacks", bus=Mod.EventBusSubscriber.Bus.MOD)
@OnlyIn(value=Dist.CLIENT)
public class TemplateBlockRenderer
implements BlockEntityRenderer<TemplateBlockEntity> {
    private static TemplateBlockRenderer instance;
    private static BlockRenderDispatcher blockRenderDispatcher;
    private static RenderType blueprintType;

    public static TemplateBlockRenderer getInstance() {
        if (instance == null) {
            instance = new TemplateBlockRenderer();
            blockRenderDispatcher = Minecraft.m_91087_().m_91289_();
        }
        return instance;
    }

    public void render(TemplateBlockEntity pBlockEntity, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight, int pPackedOverlay) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        pPoseStack.m_85836_();
        BlockState blockState = pBlockEntity.blockState;
        if (player != null) {
            LazyOptional cap = player.getCapability(ModCaps.BUILDING_POWERS);
            if (cap.isPresent() && ((IBuildingPowersHandler)cap.resolve().get()).hasPower(BuildingPower.DRAFTING_SEE)) {
                blockRenderDispatcher.renderSingleBlock(blockState, pPoseStack, pBuffer, pPackedLight, pPackedOverlay, ModelData.EMPTY, RenderType.m_110466_());
            } else {
                pPoseStack.m_252880_(0.1f, 0.1f, 0.1f);
                pPoseStack.m_85841_(0.8f, 0.8f, 0.8f);
                blockRenderDispatcher.renderSingleBlock(blockState, pPoseStack, pBuffer, pPackedLight, pPackedOverlay, ModelData.EMPTY, blueprintType);
            }
        }
        pPoseStack.m_85849_();
    }

    @SubscribeEvent
    public static void registerBlockEntityRenderer(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer((BlockEntityType)ModBlockEntities.TEMPLATE_BLOCK.get(), ctx -> TemplateBlockRenderer.getInstance());
    }

    @SubscribeEvent
    public static void registerShaderEvent(RegisterShadersEvent event) {
        AtomicReference blueprint = new AtomicReference();
        try {
            event.registerShader(new ShaderInstance(event.getResourceProvider(), new ResourceLocation("buildingpacks", "rendertype_blueprint"), DefaultVertexFormat.f_85811_), blueprint::set);
        }
        catch (IOException e) {
            throw new RuntimeException("could not reload shaders", e);
        }
        blueprintType = RenderType.m_173215_((String)"blueprint", (VertexFormat)DefaultVertexFormat.f_85811_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)0x200000, (boolean)true, (boolean)true, (RenderType.CompositeState)RenderType.m_173207_((RenderStateShard.ShaderStateShard)new RenderStateShard.ShaderStateShard(blueprint::get)));
    }
}

