/*
 * Decompiled with CFR 0.152.
 */
package com.bobvarioa.buildingpacks.client.screens;

import com.bobvarioa.buildingpacks.BlockPack;
import com.bobvarioa.buildingpacks.client.ClientEvents;
import com.bobvarioa.buildingpacks.item.BlockPackItem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;

@OnlyIn(value=Dist.CLIENT)
public class BlockPackGuiOverlay
implements IGuiOverlay {
    protected static final ResourceLocation WIDGETS_LOCATION = new ResourceLocation("buildingpacks", "textures/gui/widgets.png");

    public void render(ForgeGui gui, GuiGraphics guiGraphics, float partialTick, int screenWidth, int screenHeight) {
        LocalPlayer player = gui.getMinecraft().f_91074_;
        if (player != null && !player.m_5833_() && ClientEvents.blockPackOpen) {
            ItemStack stack = player.m_21205_();
            Item item = stack.m_41720_();
            if (item instanceof BlockPackItem) {
                BlockPackItem bpi = (BlockPackItem)item;
                CompoundTag tag = stack.m_41783_();
                BlockPack data = BlockPackItem.getData(stack);
                if (tag != null && data != null) {
                    int index = tag.m_128451_("index");
                    int min = index - 4;
                    int max = index + 4;
                    while (max > data.length() - 1) {
                        --max;
                        --min;
                    }
                    while (min < 0) {
                        ++min;
                        ++max;
                    }
                    int adjIndex = index - min;
                    int offhandOffset = 110;
                    HumanoidArm humanoidarm = player.m_5737_().m_20828_();
                    int i = screenWidth / 2;
                    guiGraphics.m_280168_().m_85836_();
                    guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, -90.0f);
                    guiGraphics.m_280218_(WIDGETS_LOCATION, i - 91, screenHeight - 22, 0, 0, 182, 22);
                    guiGraphics.m_280218_(WIDGETS_LOCATION, i - 91 - 1 + adjIndex * 20, screenHeight - 22 - 1, 0, 22, 24, 22);
                    if (!stack.m_41619_()) {
                        if (humanoidarm == HumanoidArm.LEFT) {
                            guiGraphics.m_280218_(WIDGETS_LOCATION, i - offhandOffset - 29, screenHeight - 23, 24, 22, 29, 24);
                        } else {
                            guiGraphics.m_280218_(WIDGETS_LOCATION, i + offhandOffset, screenHeight - 23, 53, 22, 29, 24);
                        }
                    }
                    guiGraphics.m_280168_().m_85849_();
                    int l = 1;
                    for (int i1 = 0; i1 < 9; ++i1) {
                        int j1 = i - 90 + i1 * 20 + 2;
                        int k1 = screenHeight - 16 - 3;
                        if (min + i1 > data.length() - 1) continue;
                        this.renderSlot(guiGraphics, j1, k1, partialTick, (Player)player, data.getBlock(min + i1).m_5456_().m_7968_(), l++);
                    }
                    int i2 = screenHeight - 16 - 3;
                    int pX = humanoidarm == HumanoidArm.LEFT ? i - offhandOffset - 26 : i + offhandOffset + 10;
                    this.renderSlot(guiGraphics, pX, i2, partialTick, (Player)player, stack, l++);
                }
            } else {
                ClientEvents.blockPackOpen = false;
            }
        }
    }

    private void renderSlot(GuiGraphics pGuiGraphics, int pX, int pY, float pPartialTick, Player pPlayer, ItemStack pStack, int pSeed) {
        if (!pStack.m_41619_()) {
            float f = (float)pStack.m_41612_() - pPartialTick;
            if (f > 0.0f) {
                float f1 = 1.0f + f / 5.0f;
                pGuiGraphics.m_280168_().m_85836_();
                pGuiGraphics.m_280168_().m_252880_((float)(pX + 8), (float)(pY + 12), 0.0f);
                pGuiGraphics.m_280168_().m_85841_(1.0f / f1, (f1 + 1.0f) / 2.0f, 1.0f);
                pGuiGraphics.m_280168_().m_252880_((float)(-(pX + 8)), (float)(-(pY + 12)), 0.0f);
            }
            pGuiGraphics.m_280638_((LivingEntity)pPlayer, pStack, pX, pY, pSeed);
            if (f > 0.0f) {
                pGuiGraphics.m_280168_().m_85849_();
            }
            pGuiGraphics.m_280370_(Minecraft.m_91087_().f_91062_, pStack, pX, pY);
        }
    }
}

