/*
 * Decompiled with CFR 0.152.
 */
package com.bobvarioa.buildingpacks.item;

import com.bobvarioa.buildingpacks.BlockPack;
import com.bobvarioa.buildingpacks.BuildingPacks;
import com.bobvarioa.buildingpacks.client.renderer.BlockPackRenderer;
import com.bobvarioa.buildingpacks.item.templates.BlockItemExtensions;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import org.jetbrains.annotations.Nullable;

public class BlockPackItem
extends BlockItem {
    public final int mult;

    public BlockPackItem(Item.Properties pProperties, int mult) {
        super(Blocks.f_50016_, pProperties);
        this.mult = mult;
    }

    public Block m_40614_() {
        return super.m_40614_();
    }

    public Component m_7626_(ItemStack pStack) {
        ResourceLocation id = ResourceLocation.m_135820_((String)pStack.m_41784_().m_128461_("id"));
        if (id == null) {
            return Component.m_237115_((String)"item.buildingpacks.pack");
        }
        return Component.m_237115_((String)("item.buildingpacks.pack." + id.m_214298_())).m_130946_(" ").m_7220_((Component)Component.m_237115_((String)"item.buildingpacks.pack"));
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltip, TooltipFlag pFlag) {
        super.m_7373_(pStack, pLevel, pTooltip, pFlag);
        pTooltip.add((Component)Component.m_237115_((String)"item.buildingpacks.tooltip.material").m_130946_(": ").m_130946_(Float.valueOf(this.getMaterial(pStack)).toString()).m_130946_("/").m_130946_(Integer.valueOf(this.getMaxMaterial(pStack)).toString()));
    }

    public static BlockPack getData(ItemStack stack) {
        ResourceLocation id = ResourceLocation.m_135820_((String)stack.m_41784_().m_128461_("id"));
        if (id != null) {
            BlockPack blockPack = (BlockPack)BuildingPacks.BLOCK_PACKS.getValue(id);
            return blockPack;
        }
        return null;
    }

    public int getMaxMaterial(ItemStack stack) {
        BlockPack blockPack = BlockPackItem.getData(stack);
        if (blockPack == null) {
            return 0;
        }
        return blockPack.getMaxMaterial() * this.mult;
    }

    public float getMaterial(ItemStack stack) {
        return stack.m_41784_().m_128457_("material");
    }

    public static Block getSelectedBlock(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        BlockPack data = BlockPackItem.getData(stack);
        if (tag != null && data != null) {
            int index = tag.m_128451_("index");
            return data.getBlock(index);
        }
        return Blocks.f_50016_;
    }

    public boolean m_142522_(ItemStack pStack) {
        return true;
    }

    public float addMaterial(ItemStack stack, float amount) {
        CompoundTag tag = stack.m_41784_();
        float mat = tag.m_128457_("material");
        float change = Mth.m_14036_((float)(mat + amount), (float)0.0f, (float)this.getMaxMaterial(stack));
        tag.m_128350_("material", change);
        return change;
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return BlockPackRenderer.getInstance();
            }
        });
    }

    public static void pickupItem(EntityItemPickupEvent event) {
        Player player = event.getEntity();
        Inventory inventory = player.m_150109_();
        ItemStack stack = event.getItem().m_32055_();
        Item item = stack.m_41720_();
        if (item instanceof BlockItem) {
            BlockItem item2 = (BlockItem)item;
            Block block = item2.m_40614_();
            for (int i = 0; i < inventory.f_35974_.size(); ++i) {
                int times;
                ItemStack itemStack = (ItemStack)inventory.f_35974_.get(i);
                Item item3 = itemStack.m_41720_();
                if (!(item3 instanceof BlockPackItem)) continue;
                BlockPackItem bpi = (BlockPackItem)item3;
                BlockPack data = BlockPackItem.getData(itemStack);
                float mat = bpi.getMaterial(itemStack);
                float price = data.getPrice(block);
                if (price == -1.0f || (times = Math.min(stack.m_41613_(), (int)Math.floor(((float)bpi.getMaxMaterial(itemStack) - mat) / price))) <= 0) continue;
                bpi.addMaterial(itemStack, price * (float)times);
                stack.m_41764_(stack.m_41613_() - times);
                if (stack.m_41613_() != 0) continue;
                event.setCanceled(true);
            }
        }
    }

    public void dropItem(ItemStack stack, Player player, int amount) {
        Block block;
        float price;
        float mat;
        BlockPack data = BlockPackItem.getData(stack);
        if (data != null && (mat = this.getMaterial(stack)) - (price = data.getPrice(block = BlockPackItem.getSelectedBlock(stack))) * (float)(amount = Math.min(amount, (int)Math.floor(mat / price))) >= 0.0f) {
            this.addMaterial(stack, -price * (float)amount);
            ItemStack itemStack = new ItemStack((ItemLike)block.m_5456_());
            itemStack.m_41764_(amount);
            player.m_36176_(itemStack, true);
            return;
        }
        player.m_36176_(stack, true);
    }

    public InteractionResult m_40576_(BlockPlaceContext pContext) {
        if (!pContext.m_7059_()) {
            return InteractionResult.FAIL;
        }
        BlockPlaceContext blockplacecontext = this.m_7732_(pContext);
        if (blockplacecontext != null) {
            Block block;
            Item item;
            ItemStack stack = pContext.m_43722_();
            BlockPack data = BlockPackItem.getData(stack);
            float mat = this.getMaterial(stack);
            CompoundTag tag = stack.m_41784_();
            if (!(mat > 0.0f)) {
                return InteractionResult.FAIL;
            }
            int index = tag.m_128451_("index");
            if (index >= 0 && index < data.length() && (item = (block = data.getBlock(index)).m_5456_()) instanceof BlockItem) {
                BlockItem bi = (BlockItem)item;
                BlockItemExtensions bie = (BlockItemExtensions)bi;
                float price = data.getPrice(block);
                if (mat - price >= 0.0f) {
                    BlockState blockstate = bie.buildingpacks$getPlacementState(pContext);
                    if (blockstate != null && bie.buildingpacks$canPlace(pContext, blockstate)) {
                        if (!bie.buildingpacks$placeBlock(blockplacecontext, blockstate)) {
                            return InteractionResult.FAIL;
                        }
                        BlockPos blockpos = blockplacecontext.m_8083_();
                        Level level = blockplacecontext.m_43725_();
                        Player player = blockplacecontext.m_43723_();
                        ItemStack itemstack = blockplacecontext.m_43722_();
                        BlockState blockState = level.m_8055_(blockpos);
                        if (blockState.m_60713_(blockstate.m_60734_())) {
                            blockState.m_60734_().m_6402_(level, blockpos, blockState, (LivingEntity)player, itemstack);
                            if (player instanceof ServerPlayer) {
                                CriteriaTriggers.f_10591_.m_285767_((ServerPlayer)player, blockpos, itemstack);
                            }
                        }
                        SoundType soundtype = blockState.getSoundType((LevelReader)level, blockpos, (Entity)pContext.m_43723_());
                        level.m_5594_(player, blockpos, bie.buildingpacks$getPlaceSound(blockState, level, blockpos, pContext.m_43723_()), SoundSource.BLOCKS, (soundtype.m_56773_() + 1.0f) / 2.0f, soundtype.m_56774_() * 0.8f);
                        level.m_220407_(GameEvent.f_157797_, blockpos, GameEvent.Context.m_223719_((Entity)player, (BlockState)blockState));
                        if (!player.m_7500_() && !level.m_5776_()) {
                            this.addMaterial(stack, -price);
                        }
                        return InteractionResult.m_19078_((boolean)level.f_46443_);
                    }
                    return InteractionResult.FAIL;
                }
            }
            return InteractionResult.FAIL;
        }
        return InteractionResult.FAIL;
    }

    public boolean m_142305_(ItemStack pStack, ItemStack pOther, Slot pSlot, ClickAction pAction, Player pPlayer, SlotAccess pAccess) {
        Item item;
        if (pAction == ClickAction.SECONDARY && (item = pOther.m_41720_()) instanceof BlockItem) {
            int times;
            BlockItem bi = (BlockItem)item;
            BlockPack data = BlockPackItem.getData(pStack);
            if (data == null) {
                return false;
            }
            float mat = this.getMaterial(pStack);
            float price = data.getPrice(bi.m_40614_());
            if (price != -1.0f && (times = Math.min(pOther.m_41613_(), (int)Math.floor(((float)this.getMaxMaterial(pStack) - mat) / price))) > 0) {
                this.addMaterial(pStack, price * (float)times);
                pOther.m_41764_(pOther.m_41613_() - times);
                return pOther.m_41613_() == 0;
            }
        }
        return false;
    }

    public boolean m_142207_(ItemStack pStack, Slot pSlot, ClickAction pAction, Player pPlayer) {
        if (pAction == ClickAction.SECONDARY) {
            if (pSlot.m_7993_().m_41619_()) {
                int amount;
                Block block;
                float price;
                float mat;
                BlockPack data = BlockPackItem.getData(pStack);
                if (data != null && (mat = this.getMaterial(pStack)) - (price = data.getPrice(block = BlockPackItem.getSelectedBlock(pStack))) * (float)(amount = Math.min(64, (int)Math.floor(mat / price))) >= 0.0f) {
                    this.addMaterial(pStack, -price * (float)amount);
                    ItemStack itemStack = new ItemStack((ItemLike)block.m_5456_());
                    itemStack.m_41764_(amount);
                    pSlot.m_5852_(itemStack);
                    return true;
                }
            } else {
                return this.m_142305_(pStack, pSlot.m_7993_(), pSlot, pAction, pPlayer, SlotAccess.f_147290_);
            }
        }
        return false;
    }

    public int m_142158_(ItemStack pStack) {
        float maxMaterial = this.getMaxMaterial(pStack);
        float material = maxMaterial - this.getMaterial(pStack);
        return Math.round(13.0f - material * 13.0f / maxMaterial);
    }

    public int m_142159_(ItemStack pStack) {
        float maxMaterial = this.getMaxMaterial(pStack);
        float material = this.getMaterial(pStack);
        float f = Math.max(0.0f, (maxMaterial - material) / maxMaterial);
        return Mth.m_14169_((float)((239.0f - 36.0f * f) / 360.0f), (float)0.67f, (float)0.82f);
    }
}

