/*
 * Decompiled with CFR 0.152.
 */
package com.bobvarioa.buildingpacks.item;

import com.bobvarioa.buildingpacks.capabilty.BuildingPower;
import com.bobvarioa.buildingpacks.capabilty.IBuildingPowersHandler;
import com.bobvarioa.buildingpacks.item.templates.InventoryListener;
import com.bobvarioa.buildingpacks.register.ModCaps;
import com.bobvarioa.buildingpacks.register.ModItems;
import java.util.Optional;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class HardHat
extends ArmorItem
implements InventoryListener,
Equipable {
    public HardHat(Item.Properties pProperties) {
        super((ArmorMaterial)new HardHatMaterial(), ArmorItem.Type.HELMET, pProperties);
    }

    public EquipmentSlot m_40402_() {
        return EquipmentSlot.HEAD;
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int pSlotId, boolean pIsSelected) {
        Player player;
        Optional cap;
        super.m_6883_(stack, level, entity, pSlotId, pIsSelected);
        if (stack.m_150930_((Item)ModItems.HARD_HAT.get()) && entity instanceof Player && !(cap = (player = (Player)entity).getCapability(ModCaps.BUILDING_POWERS).resolve()).isEmpty()) {
            IBuildingPowersHandler powersHandler = (IBuildingPowersHandler)cap.get();
            powersHandler.setPower(BuildingPower.DRAFTING_SEE, pSlotId == EquipmentSlot.HEAD.m_20749_());
        }
    }

    @Override
    public void leftInventory(Player player) {
        Optional cap = player.getCapability(ModCaps.BUILDING_POWERS).resolve();
        if (!cap.isEmpty()) {
            IBuildingPowersHandler powersHandler = (IBuildingPowersHandler)cap.get();
            powersHandler.setPower(BuildingPower.DRAFTING_SEE, false);
        }
    }

    @Nullable
    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        return "buildingpacks:textures/models/armor/hard_hat_layer_1.png";
    }

    public static class HardHatMaterial
    implements ArmorMaterial {
        public int m_266425_(ArmorItem.Type pType) {
            return -1;
        }

        public int m_7366_(ArmorItem.Type pType) {
            return 1;
        }

        public int m_6646_() {
            return 0;
        }

        public SoundEvent m_7344_() {
            return SoundEvents.f_11675_;
        }

        public Ingredient m_6230_() {
            return Ingredient.f_43901_;
        }

        public String m_6082_() {
            return "hard_hat";
        }

        public float m_6651_() {
            return 0.0f;
        }

        public float m_6649_() {
            return 0.1f;
        }
    }
}

