/*
 * Decompiled with CFR 0.152.
 */
package com.bobvarioa.buildingpacks.mixin.effortlessbuilding;

import com.bobvarioa.buildingpacks.compat.effortlessbuilding.BuilderChainExtensions;
import com.bobvarioa.buildingpacks.item.BlockPackItem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import nl.requios.effortlessbuilding.EffortlessBuildingClient;
import nl.requios.effortlessbuilding.buildmode.BuildModeEnum;
import nl.requios.effortlessbuilding.capability.CapabilityHandler;
import nl.requios.effortlessbuilding.compatibility.CompatHelper;
import nl.requios.effortlessbuilding.network.PacketHandler;
import nl.requios.effortlessbuilding.network.ServerBreakBlocksPacket;
import nl.requios.effortlessbuilding.systems.BuilderChain;
import nl.requios.effortlessbuilding.utilities.BlockEntry;
import nl.requios.effortlessbuilding.utilities.BlockSet;
import nl.requios.effortlessbuilding.utilities.ClientBlockUtilities;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.gen.Accessor;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BuilderChain.class})
public abstract class BuilderChainMixin
implements BuilderChainExtensions {
    @Override
    @Accessor(remap=false)
    public abstract void setBuildingState(BuilderChain.BuildingState var1);

    @Inject(method={"determineItemStack(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/item/ItemStack;)Lnet/minecraft/world/item/ItemStack;"}, at={@At(value="HEAD")}, remap=false, cancellable=true)
    private void determineItemStack(Player player, ItemStack heldItem, CallbackInfoReturnable<ItemStack> cir) {
        if (heldItem.m_41720_() instanceof BlockPackItem) {
            cir.setReturnValue((Object)CompatHelper.getItemBlockFromStack((ItemStack)heldItem));
        }
    }

    @Inject(method={"onLeftClick()V"}, at={@At(value="HEAD")}, remap=false, cancellable=true)
    public void onLeftClick(CallbackInfo ci) {
        BuilderChain _this = (BuilderChain)this;
        if (_this.getAbilitiesState() != BuilderChain.AbilitiesState.NONE && _this.getBuildingState() != BuilderChain.BuildingState.PLACING) {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player != null && (CapabilityHandler.canBreakFar((Player)player) || player.m_21205_().m_41720_() instanceof BlockPackItem)) {
                BlockSet blocks = _this.getBlocks();
                if (_this.getBuildingState() == BuilderChain.BuildingState.IDLE) {
                    this.setBuildingState(BuilderChain.BuildingState.BREAKING);
                    blocks.setStartPos(new BlockEntry(_this.getStartPosForBreaking()));
                    EffortlessBuildingClient.BUILD_MODIFIERS.findCoordinates(blocks, (Player)player);
                    EffortlessBuildingClient.BUILDER_FILTER.filterOnCoordinates(blocks, (Player)player);
                    Level level = player.m_9236_();
                    for (BlockEntry blockEntry : blocks) {
                        blockEntry.existingBlockState = level.m_8055_(blockEntry.blockPos);
                    }
                    EffortlessBuildingClient.BUILDER_FILTER.filterOnExistingBlockStates(blocks, (Player)player);
                }
                BuildModeEnum buildMode = EffortlessBuildingClient.BUILD_MODES.getBuildMode();
                if (buildMode.instance.onClick(blocks)) {
                    this.setBuildingState(BuilderChain.BuildingState.IDLE);
                    if (!blocks.isEmpty()) {
                        EffortlessBuildingClient.BLOCK_PREVIEWS.onBlocksBroken(blocks);
                        ClientBlockUtilities.playSoundIfFurtherThanNormal((Player)player, (BlockEntry)blocks.getLastBlockEntry(), (boolean)true);
                        player.m_6674_(InteractionHand.MAIN_HAND);
                        blocks.skipFirst = buildMode == BuildModeEnum.DISABLED;
                        PacketHandler.INSTANCE.sendToServer((Object)new ServerBreakBlocksPacket(blocks));
                    }
                }
            }
        } else {
            _this.cancel();
        }
        ci.cancel();
    }
}

