/*
 * Decompiled with CFR 0.152.
 */
package com.bobvarioa.buildingpacks.mixin.effortlessbuilding;

import com.bobvarioa.buildingpacks.BlockPack;
import com.bobvarioa.buildingpacks.item.BlockPackItem;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import nl.requios.effortlessbuilding.utilities.InventoryHelper;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={InventoryHelper.class})
public class InventoryHelperMixin {
    @ModifyConstant(method={"removeFromInventory(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/item/Item;I)V"}, constant={@Constant(intValue=0, ordinal=0)}, remap=false)
    private static int removeFromInventory(int amountFound, Player player, Item item, int amount) {
        if (!player.m_7500_()) {
            if (!(item instanceof BlockItem)) {
                return amountFound;
            }
            BlockItem bi = (BlockItem)item;
            Block block = bi.m_40614_();
            int amountFoundNew = amountFound;
            int preferredSlot = player.m_150109_().f_35977_;
            ItemStack itemstack = player.m_150109_().m_8020_(preferredSlot);
            Item item2 = itemstack.m_41720_();
            if (item2 instanceof BlockPackItem) {
                int i;
                BlockPackItem bpi = (BlockPackItem)item2;
                BlockPack data = BlockPackItem.getData(itemstack);
                if (data == null) {
                    return 0;
                }
                float price = data.getPrice(block);
                float mat = bpi.getMaterial(itemstack);
                for (i = 1; i < amount && price * (float)i < mat; ++i) {
                }
                if (price * (float)i > mat) {
                    --i;
                }
                bpi.addMaterial(itemstack, -(price * (float)i));
                amountFoundNew += i;
            }
            return amountFoundNew;
        }
        return amountFound;
    }

    @Inject(method={"findTotalItemsInInventory(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/item/Item;)I"}, at={@At(value="TAIL")}, remap=false, cancellable=true)
    private static void findTotalItemsInInventory(Player player, Item item, CallbackInfoReturnable<Integer> cir) {
        int total = (Integer)cir.getReturnValue();
        for (ItemStack stack : player.m_150109_().f_35974_) {
            Item item2;
            if (stack.m_41619_() || !((item2 = stack.m_41720_()) instanceof BlockPackItem)) continue;
            BlockPackItem bpi = (BlockPackItem)item2;
            BlockPack data = BlockPackItem.getData(stack);
            if (data == null) continue;
            Block block = BlockPackItem.getSelectedBlock(stack);
            float price = data.getPrice(block);
            if (!block.m_5456_().equals(item)) continue;
            total += (int)Math.floor(bpi.getMaterial(stack) / price);
        }
        cir.setReturnValue((Object)total);
    }
}

