/*
 * Decompiled with CFR 0.152.
 */
package com.bobvarioa.buildingpacks.network;

import com.bobvarioa.buildingpacks.item.BlockPackItem;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public record BreakBlockPacket(BlockPos pos, float price) {
    public static BreakBlockPacket decode(FriendlyByteBuf buf) {
        return new BreakBlockPacket(buf.m_130135_(), buf.readFloat());
    }

    public static void encode(BreakBlockPacket packet, FriendlyByteBuf buf) {
        buf.m_130064_(packet.pos);
        buf.writeFloat(packet.price);
    }

    public static void onMessageReceived(BreakBlockPacket message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        ctx.setPacketHandled(true);
        if (sideReceived != LogicalSide.SERVER) {
            return;
        }
        ServerPlayer sendingPlayer = ctx.getSender();
        if (sendingPlayer == null) {
            return;
        }
        ctx.enqueueWork(() -> BreakBlockPacket.processMessage(message, sendingPlayer));
    }

    public static void processMessage(BreakBlockPacket packet, ServerPlayer player) {
        ItemStack stack = player.m_21205_();
        Item item = player.m_21205_().m_41720_();
        if (item instanceof BlockPackItem) {
            BlockPackItem bpi = (BlockPackItem)item;
            Level level = player.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                bpi.addMaterial(stack, packet.price);
                BreakBlockPacket.destroyBlock(serverLevel, packet.pos, false, player, 512);
            }
        }
    }

    public static boolean destroyBlock(ServerLevel level, BlockPos pPos, boolean pDropBlock, ServerPlayer player, int pRecursionLeft) {
        boolean flag;
        BlockState blockstate = level.m_8055_(pPos);
        if (blockstate.m_60795_()) {
            return false;
        }
        FluidState fluidstate = level.m_6425_(pPos);
        if (!(blockstate.m_60734_() instanceof BaseFireBlock)) {
            level.m_5898_((Player)player, 2001, pPos, Block.m_49956_((BlockState)blockstate));
        }
        if (pDropBlock) {
            BlockEntity blockentity = blockstate.m_155947_() ? level.m_7702_(pPos) : null;
            Block.m_49881_((BlockState)blockstate, (Level)level, (BlockPos)pPos, (BlockEntity)blockentity, (Entity)player, (ItemStack)ItemStack.f_41583_);
        }
        if (flag = level.m_6933_(pPos, fluidstate.m_76188_(), 3, pRecursionLeft)) {
            level.m_220407_(GameEvent.f_157794_, pPos, GameEvent.Context.m_223719_((Entity)player, (BlockState)blockstate));
        }
        return flag;
    }
}

