/*
 * Decompiled with CFR 0.152.
 */
package com.bobvarioa.buildingpacks.network;

import com.bobvarioa.buildingpacks.item.BlockPackItem;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public record DropItemPacket(int amount) {
    public static DropItemPacket decode(FriendlyByteBuf buf) {
        return new DropItemPacket(buf.readInt());
    }

    public static void encode(DropItemPacket packet, FriendlyByteBuf buf) {
        buf.writeInt(packet.amount);
    }

    public static void onMessageReceived(DropItemPacket message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        ctx.setPacketHandled(true);
        if (sideReceived != LogicalSide.SERVER) {
            return;
        }
        ServerPlayer sendingPlayer = ctx.getSender();
        if (sendingPlayer == null) {
            return;
        }
        ctx.enqueueWork(() -> DropItemPacket.processMessage(message, sendingPlayer));
    }

    public static void processMessage(DropItemPacket packet, ServerPlayer player) {
        ItemStack stack = player.m_21205_();
        Item item = player.m_21205_().m_41720_();
        if (item instanceof BlockPackItem) {
            BlockPackItem bpi = (BlockPackItem)item;
            bpi.dropItem(stack, (Player)player, packet.amount);
        }
    }
}

