/*
 * Decompiled with CFR 0.152.
 */
package com.bobvarioa.buildingpacks.network;

import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public record IndexUpdatePacket(int index) {
    public static IndexUpdatePacket decode(FriendlyByteBuf buf) {
        return new IndexUpdatePacket(buf.readInt());
    }

    public static void encode(IndexUpdatePacket packet, FriendlyByteBuf buf) {
        buf.writeInt(packet.index);
    }

    public static void onMessageReceived(IndexUpdatePacket message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        ctx.setPacketHandled(true);
        if (sideReceived != LogicalSide.SERVER) {
            return;
        }
        ServerPlayer sendingPlayer = ctx.getSender();
        if (sendingPlayer == null) {
            return;
        }
        ctx.enqueueWork(() -> IndexUpdatePacket.processMessage(message, sendingPlayer));
    }

    public static void processMessage(IndexUpdatePacket packet, ServerPlayer player) {
        ItemStack stack = player.m_21205_();
        CompoundTag tag = stack.m_41784_();
        tag.m_128405_("index", packet.index);
    }
}

