/*
 * Decompiled with CFR 0.152.
 */
package com.bobvarioa.buildingpacks.network;

import com.bobvarioa.buildingpacks.capabilty.BuildingPower;
import com.bobvarioa.buildingpacks.capabilty.IBuildingPowersHandler;
import com.bobvarioa.buildingpacks.register.ModCaps;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public record PowerUpdatePacket(BuildingPower power, boolean state) {
    public static PowerUpdatePacket decode(FriendlyByteBuf buf) {
        return new PowerUpdatePacket((BuildingPower)buf.m_130066_(BuildingPower.class), buf.readBoolean());
    }

    public static void encode(PowerUpdatePacket packet, FriendlyByteBuf buf) {
        buf.m_130068_((Enum)packet.power());
        buf.writeBoolean(packet.state());
    }

    public static void onMessageReceived(PowerUpdatePacket message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        ctx.setPacketHandled(true);
        if (sideReceived != LogicalSide.CLIENT) {
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        ctx.enqueueWork(() -> PowerUpdatePacket.processMessage(message, player));
    }

    public static void processMessage(PowerUpdatePacket packet, LocalPlayer player) {
        Optional cap = player.getCapability(ModCaps.BUILDING_POWERS).resolve();
        if (!cap.isEmpty()) {
            IBuildingPowersHandler powersHandler = (IBuildingPowersHandler)cap.get();
            powersHandler.setPower(packet.power, packet.state);
        }
    }
}

