/*
 * Decompiled with CFR 0.152.
 */
package com.bobvarioa.buildingpacks.network;

import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public record ToolIndexUpdatePacket(int index) {
    public static ToolIndexUpdatePacket decode(FriendlyByteBuf buf) {
        return new ToolIndexUpdatePacket(buf.readInt());
    }

    public static void encode(ToolIndexUpdatePacket packet, FriendlyByteBuf buf) {
        buf.writeInt(packet.index);
    }

    public static void onMessageReceived(ToolIndexUpdatePacket message, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        LogicalSide sideReceived = ctx.getDirection().getReceptionSide();
        ctx.setPacketHandled(true);
        if (sideReceived != LogicalSide.SERVER) {
            return;
        }
        ServerPlayer sendingPlayer = ctx.getSender();
        if (sendingPlayer == null) {
            return;
        }
        ctx.enqueueWork(() -> ToolIndexUpdatePacket.processMessage(message, sendingPlayer));
    }

    public static void processMessage(ToolIndexUpdatePacket packet, ServerPlayer player) {
        ItemStack stack = player.m_21205_();
        CompoundTag tag = stack.m_41784_();
        tag.m_128405_("toolIndex", packet.index);
    }
}

