/*
 * Decompiled with CFR 0.152.
 */
package ma.shaur.bettercoppergolem.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import ma.shaur.bettercoppergolem.BetterCopperGolem;
import ma.shaur.bettercoppergolem.config.Config;
import net.fabricmc.loader.api.FabricLoader;

public class ConfigHandler {
    private static final File configFile = FabricLoader.getInstance().getConfigDir().resolve("bettercoppergolem-config.json").toFile();
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private static volatile Config config = null;

    public static Config getConfig() {
        return config;
    }

    public static void init() {
        block3: {
            if (config != null) {
                return;
            }
            try {
                ConfigHandler.loadConfig();
            }
            catch (JsonIOException | JsonSyntaxException | IOException e) {
                BetterCopperGolem.LOGGER.error("Error loading config", e);
                if (config != null) break block3;
                config = new Config();
            }
        }
    }

    public static void loadConfig() throws JsonSyntaxException, JsonIOException, IOException {
        if (!configFile.exists()) {
            ConfigHandler.saveConfig();
        } else {
            config = (Config)gson.fromJson((Reader)new FileReader(configFile), Config.class);
        }
    }

    public static void saveConfig() throws JsonIOException, IOException {
        if (config == null) {
            config = new Config();
        }
        configFile.getParentFile().mkdirs();
        try (FileWriter writer = new FileWriter(configFile);){
            gson.toJson((Object)config, (Appendable)writer);
            writer.flush();
            writer.close();
        }
    }
}

