/*
 * Decompiled with CFR 0.152.
 */
package com.minecraft.jumpcash;

import com.minecraft.jumpcash.JumpCashCommand;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;

public class JumpCash
extends JavaPlugin
implements Listener {
    private Economy economy;
    private FileConfiguration config;
    private double jumpReward;
    private boolean usePermission;
    private String permission;
    private boolean enableMilestones;
    private Map<Integer, Double> milestones;
    private Map<UUID, Integer> playerJumpCount;
    private boolean notifyOnJump;
    private boolean notifyOnMilestone;
    private String jumpMessage;
    private String milestoneMessage;
    private boolean enableCooldown;
    private int cooldownSeconds;
    private Map<UUID, Long> cooldowns;

    @Override
    public void onEnable() {
        this.saveDefaultConfig();
        this.config = this.getConfig();
        this.loadConfiguration();
        this.playerJumpCount = new HashMap<UUID, Integer>();
        this.cooldowns = new HashMap<UUID, Long>();
        if (!this.setupEconomy()) {
            this.getLogger().severe("Vault not found! Disabling JumpCash.");
            this.getServer().getPluginManager().disablePlugin(this);
            return;
        }
        this.getServer().getPluginManager().registerEvents(this, this);
        this.getCommand("jumpcash").setExecutor(new JumpCashCommand(this));
        this.getLogger().info("JumpCash has been enabled successfully!");
    }

    @Override
    public void onDisable() {
        this.getLogger().info("JumpCash has been disabled.");
    }

    private boolean setupEconomy() {
        if (this.getServer().getPluginManager().getPlugin("Vault") == null) {
            return false;
        }
        RegisteredServiceProvider<Economy> rsp = this.getServer().getServicesManager().getRegistration(Economy.class);
        if (rsp == null) {
            return false;
        }
        this.economy = rsp.getProvider();
        return this.economy != null;
    }

    private void loadConfiguration() {
        this.jumpReward = this.config.getDouble("rewards.jump-reward", 1.0);
        this.usePermission = this.config.getBoolean("general.use-permission", false);
        this.permission = this.config.getString("general.permission", "jumpcash.use");
        this.notifyOnJump = this.config.getBoolean("messages.notify-on-jump", true);
        this.jumpMessage = this.config.getString("messages.jump-message", "&aYou earned &6$%amount% &afor jumping!");
        this.enableMilestones = this.config.getBoolean("milestones.enabled", true);
        this.notifyOnMilestone = this.config.getBoolean("milestones.notify", true);
        this.milestoneMessage = this.config.getString("milestones.message", "&6Congratulations! &aYou've reached &6%jumps% &ajumps and earned a bonus of &6$%amount%&a!");
        this.enableCooldown = this.config.getBoolean("cooldown.enabled", false);
        this.cooldownSeconds = this.config.getInt("cooldown.seconds", 1);
        this.milestones = new HashMap<Integer, Double>();
        if (this.config.contains("milestones.rewards")) {
            for (String key : this.config.getConfigurationSection("milestones.rewards").getKeys(false)) {
                try {
                    int jumpCount = Integer.parseInt(key);
                    double reward = this.config.getDouble("milestones.rewards." + key);
                    this.milestones.put(jumpCount, reward);
                }
                catch (NumberFormatException e) {
                    this.getLogger().warning("Invalid milestone key: " + key);
                }
            }
        }
    }

    public void reloadConfigs() {
        this.reloadConfig();
        this.config = this.getConfig();
        this.loadConfiguration();
    }

    @EventHandler
    public void onPlayerJump(PlayerMoveEvent event) {
        Player player = event.getPlayer();
        UUID playerId = player.getUniqueId();
        if (event.getFrom().getY() < event.getTo().getY()) {
            if (this.usePermission && !player.hasPermission(this.permission)) {
                return;
            }
            if (this.enableCooldown) {
                long lastJumpTime;
                long currentTime = System.currentTimeMillis();
                if (this.cooldowns.containsKey(playerId) && currentTime - (lastJumpTime = this.cooldowns.get(playerId).longValue()) < (long)(this.cooldownSeconds * 1000)) {
                    return;
                }
                this.cooldowns.put(playerId, currentTime);
            }
            this.economy.depositPlayer((OfflinePlayer)player, this.jumpReward);
            if (this.notifyOnJump) {
                String message = this.jumpMessage.replace("%amount%", String.format("%.2f", this.jumpReward)).replace("&", "\u00a7");
                player.sendMessage(message);
            }
            if (this.enableMilestones) {
                int jumps = this.playerJumpCount.getOrDefault(playerId, 0) + 1;
                this.playerJumpCount.put(playerId, jumps);
                if (this.milestones.containsKey(jumps)) {
                    double bonus = this.milestones.get(jumps);
                    this.economy.depositPlayer((OfflinePlayer)player, bonus);
                    if (this.notifyOnMilestone) {
                        String message = this.milestoneMessage.replace("%jumps%", String.valueOf(jumps)).replace("%amount%", String.format("%.2f", bonus)).replace("&", "\u00a7");
                        player.sendMessage(message);
                    }
                }
            }
        }
    }

    public Economy getEconomy() {
        return this.economy;
    }

    public Map<UUID, Integer> getPlayerJumpCount() {
        return this.playerJumpCount;
    }

    public double getJumpReward() {
        return this.jumpReward;
    }

    public Map<Integer, Double> getMilestones() {
        return this.milestones;
    }
}

