/*
 * Decompiled with CFR 0.152.
 */
package com.minecraft.jumpcash;

import com.minecraft.jumpcash.JumpCash;
import java.util.Map;
import java.util.UUID;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class JumpCashCommand
implements CommandExecutor {
    private final JumpCash plugin;

    public JumpCashCommand(JumpCash plugin) {
        this.plugin = plugin;
    }

    @Override
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 0) {
            this.showHelp(sender);
            return true;
        }
        switch (args[0].toLowerCase()) {
            case "reload": {
                if (!sender.hasPermission("jumpcash.admin")) {
                    sender.sendMessage(String.valueOf((Object)ChatColor.RED) + "You don't have permission to use this command.");
                    return true;
                }
                this.plugin.reloadConfigs();
                sender.sendMessage(String.valueOf((Object)ChatColor.GREEN) + "JumpCash configuration reloaded!");
                return true;
            }
            case "stats": {
                if (!(sender instanceof Player)) {
                    sender.sendMessage(String.valueOf((Object)ChatColor.RED) + "This command can only be used by players.");
                    return true;
                }
                Player player = (Player)sender;
                UUID playerId = player.getUniqueId();
                Map<UUID, Integer> jumpCounts = this.plugin.getPlayerJumpCount();
                int jumps = jumpCounts.getOrDefault(playerId, 0);
                sender.sendMessage(String.valueOf((Object)ChatColor.GREEN) + "Jump Statistics:");
                sender.sendMessage(String.valueOf((Object)ChatColor.GOLD) + "Total jumps: " + String.valueOf((Object)ChatColor.WHITE) + jumps);
                sender.sendMessage(String.valueOf((Object)ChatColor.GOLD) + "Money earned from jumps: " + String.valueOf((Object)ChatColor.WHITE) + String.format("%.2f", (double)jumps * this.plugin.getJumpReward()));
                return true;
            }
            case "info": {
                sender.sendMessage(String.valueOf((Object)ChatColor.GREEN) + "JumpCash Information:");
                sender.sendMessage(String.valueOf((Object)ChatColor.GOLD) + "Current jump reward: " + String.valueOf((Object)ChatColor.WHITE) + String.format("%.2f", this.plugin.getJumpReward()));
                Map<Integer, Double> milestones = this.plugin.getMilestones();
                if (!milestones.isEmpty()) {
                    sender.sendMessage(String.valueOf((Object)ChatColor.GOLD) + "Available milestones:");
                    for (Map.Entry<Integer, Double> entry : milestones.entrySet()) {
                        sender.sendMessage(String.valueOf((Object)ChatColor.YELLOW) + "  " + String.valueOf(entry.getKey()) + " jumps: " + String.valueOf((Object)ChatColor.WHITE) + "$" + String.format("%.2f", entry.getValue()));
                    }
                }
                return true;
            }
        }
        this.showHelp(sender);
        return true;
    }

    private void showHelp(CommandSender sender) {
        sender.sendMessage(String.valueOf((Object)ChatColor.GREEN) + "JumpCash Commands:");
        sender.sendMessage(String.valueOf((Object)ChatColor.GREEN) + "-----------------------------------------------------------");
        sender.sendMessage(String.valueOf((Object)ChatColor.GOLD) + "/jumpcash stats " + String.valueOf((Object)ChatColor.WHITE) + "- View your jump statistics");
        sender.sendMessage(String.valueOf((Object)ChatColor.GOLD) + "/jumpcash info " + String.valueOf((Object)ChatColor.WHITE) + "- View plugin information");
        if (sender.hasPermission("jumpcash.admin")) {
            sender.sendMessage(String.valueOf((Object)ChatColor.GOLD) + "/jumpcash reload " + String.valueOf((Object)ChatColor.WHITE) + "- Reload the configuration");
        }
        sender.sendMessage(String.valueOf((Object)ChatColor.GREEN) + "-----------------------------------------------------------");
    }
}

