/*
 * Decompiled with CFR 0.152.
 */
package com.ghasto.logistical_improvements;

import com.ghasto.logistical_improvements.batch_size.BatchSizeAccessor;
import com.ghasto.logistical_improvements.batch_size.ConfigureBatchSize;
import com.ghasto.logistical_improvements.cog_material.CogMaterialAccessor;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBehaviour;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBlockEntity;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelPosition;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.LogicalSide;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.UseItemOnBlockEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="vanilla_logistics")
public class VanillaLogistics {
    public static final String MODID = "vanilla_logistics";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Vanilla Logistics");

    public VanillaLogistics(IEventBus eventBus) {
        eventBus.addListener(this::registerPackets);
        NeoForge.EVENT_BUS.addListener(this::useItemOnBlock);
    }

    public static ResourceLocation asId(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)path);
    }

    private void registerPackets(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registry = event.registrar("2");
        registry.playToServer(ConfigureBatchSize.TYPE, ConfigureBatchSize.STREAM_CODEC, (payload, context) -> {
            Player player = context.player();
            FactoryPanelPosition pos = payload.position();
            Level level = player.level();
            if (!level.isLoaded(pos.pos())) {
                return;
            }
            BlockEntity patt0$temp = level.getBlockEntity(pos.pos());
            if (!(patt0$temp instanceof FactoryPanelBlockEntity)) {
                return;
            }
            FactoryPanelBlockEntity be = (FactoryPanelBlockEntity)patt0$temp;
            FactoryPanelBehaviour behavior = (FactoryPanelBehaviour)be.panels.get(pos.slot());
            if (!(behavior instanceof BatchSizeAccessor)) {
                return;
            }
            BatchSizeAccessor accessor = (BatchSizeAccessor)behavior;
            if (accessor.getMinimumBatchSize() == payload.value()) {
                return;
            }
            accessor.setMinimumBatchSize(payload.value());
            be.notifyUpdate();
        });
    }

    private void useItemOnBlock(UseItemOnBlockEvent event) {
        if (event.getHand() == InteractionHand.OFF_HAND) {
            return;
        }
        if (event.getUsePhase() != UseItemOnBlockEvent.UsePhase.BLOCK) {
            return;
        }
        BlockState blockState = event.getLevel().getBlockState(event.getPos());
        if (!blockState.is(TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)VanillaLogistics.asId("material_cogs")))) {
            return;
        }
        ItemStack stack = event.getItemStack();
        if (!stack.is(ItemTags.PLANKS)) {
            return;
        }
        BlockState material = ((BlockItem)stack.getItem()).getBlock().defaultBlockState();
        BlockEntity blockEntity = event.getLevel().getBlockEntity(event.getPos());
        if (!(blockEntity instanceof KineticBlockEntity)) {
            return;
        }
        CogMaterialAccessor accessor = (CogMaterialAccessor)blockEntity;
        if (accessor.getMaterial() == material) {
            return;
        }
        if (event.getSide() == LogicalSide.SERVER) {
            accessor.setMaterial(material);
            event.getLevel().levelEvent(2001, event.getPos(), Block.getId((BlockState)material));
        }
        event.setCancellationResult(ItemInteractionResult.SUCCESS);
        event.setCanceled(true);
    }
}

