/*
 * Decompiled with CFR 0.152.
 */
package com.ghasto.logistical_improvements;

import com.ghasto.logistical_improvements.BatchSizeAccessor;
import com.ghasto.logistical_improvements.ConfigureBatchSize;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBehaviour;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBlockEntity;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelPosition;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="vanilla_logistics")
public class LogisticalImprovements {
    public static final String MODID = "vanilla_logistics";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Vanilla Logistics");

    public LogisticalImprovements(IEventBus eventBus, ModContainer modContainer) {
        eventBus.addListener(this::commonSetup);
        eventBus.addListener(this::registerPackets);
    }

    private void registerPackets(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registry = event.registrar("2");
        registry.playToServer(ConfigureBatchSize.TYPE, ConfigureBatchSize.STREAM_CODEC, (payload, context) -> {
            Player player = context.player();
            FactoryPanelPosition pos = payload.position();
            Level level = player.level();
            if (!level.isLoaded(pos.pos())) {
                return;
            }
            BlockEntity patt0$temp = level.getBlockEntity(pos.pos());
            if (!(patt0$temp instanceof FactoryPanelBlockEntity)) {
                return;
            }
            FactoryPanelBlockEntity be = (FactoryPanelBlockEntity)patt0$temp;
            FactoryPanelBehaviour behavior = (FactoryPanelBehaviour)be.panels.get(pos.slot());
            if (!(behavior instanceof BatchSizeAccessor)) {
                return;
            }
            BatchSizeAccessor accessor = (BatchSizeAccessor)behavior;
            if (accessor.getMinimumBatchSize() == payload.value()) {
                return;
            }
            accessor.setMinimumBatchSize(payload.value());
            be.notifyUpdate();
        });
    }

    private void commonSetup(FMLCommonSetupEvent event) {
    }
}

