/*
 * Decompiled with CFR 0.152.
 */
package com.ghasto.logistical_improvements.mixin;

import com.ghasto.logistical_improvements.BatchSizeAccessor;
import com.llamalad7.mixinextras.sugar.Local;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBehaviour;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBlock;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBlockEntity;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import org.joml.Math;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={FactoryPanelBehaviour.class})
public abstract class FactoryPanelBehaviourMixin
implements BatchSizeAccessor {
    @Shadow
    public FactoryPanelBlock.PanelSlot slot;
    private int minimumBatchSize = 1;

    @Shadow
    public abstract FactoryPanelBlockEntity panelBE();

    @Override
    public int getMinimumBatchSize() {
        return this.minimumBatchSize;
    }

    @Override
    public void setMinimumBatchSize(int minimumBatchSize) {
        this.minimumBatchSize = minimumBatchSize;
    }

    @Unique
    private void addTag(CompoundTag tag) {
        tag.putInt(this.slot.name() + "_minimumBatchSize", this.minimumBatchSize);
    }

    @Inject(method={"writeSafe"}, at={@At(value="TAIL")})
    private void writeSafe(CompoundTag nbt, HolderLookup.Provider registries, CallbackInfo ci) {
        this.addTag(nbt);
    }

    @Inject(method={"write"}, at={@At(value="TAIL")})
    private void write(CompoundTag nbt, HolderLookup.Provider registries, boolean clientPacket, CallbackInfo ci) {
        this.addTag(nbt);
    }

    @Inject(method={"read"}, at={@At(value="TAIL")})
    private void read(CompoundTag nbt, HolderLookup.Provider registries, boolean clientPacket, CallbackInfo ci) {
        this.minimumBatchSize = nbt.getInt(this.slot.name() + "_minimumBatchSize");
    }

    @Inject(method={"tryRestock"}, at={@At(value="INVOKE", target="Lcom/simibubi/create/content/logistics/stockTicker/PackageOrderWithCrafts;simple(Ljava/util/List;)Lcom/simibubi/create/content/logistics/stockTicker/PackageOrderWithCrafts;")}, cancellable=true)
    private void onTryRestock(CallbackInfo ci, @Local(ordinal=5) int amountToOrder, @Local(ordinal=0) int availableOnNetwork) {
        if (Math.min((int)amountToOrder, (int)availableOnNetwork) < this.minimumBatchSize) {
            ci.cancel();
        }
    }
}

